/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.invoice.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.invoice.dao.BillInvoiceMapper;
import com.els.base.invoice.entity.BillInvoice;
import com.els.base.invoice.entity.BillInvoiceExample;
import com.els.base.invoice.service.BillInvoiceService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBillInvoiceService")
public class BillInvoiceServiceImpl
implements BillInvoiceService {
    @Resource
    protected BillInvoiceMapper billInvoiceMapper;

    @Override
    @CacheEvict(value={"billInvoice"}, allEntries=true)
    @Transactional
    public void deleteByExample(BillInvoiceExample example) {
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u4e0d\u80fd\u8fdb\u884c\u5168\u8868\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\uff01");
        this.billInvoiceMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"billInvoice"}, allEntries=true)
    @Transactional
    public int updateByExampleSelective(BillInvoice record, BillInvoiceExample example) {
        return this.billInvoiceMapper.updateByExampleSelective(record, example);
    }

    @Override
    @Cacheable(value={"billInvoice"}, keyGenerator="redisKeyGenerator")
    public int countByExample(BillInvoiceExample example) {
        return this.billInvoiceMapper.countByExample(example);
    }

    @Override
    @CacheEvict(value={"billInvoice"}, allEntries=true)
    @Transactional
    public void updateBillInvoiceFlag(List<String> billIds, Integer flag) {
        Assert.isNotNull((Object)flag);
        Assert.isNotNull(billIds);
        BillInvoiceExample billInvoiceExample = new BillInvoiceExample();
        billInvoiceExample.createCriteria().andBillIdIn((List)billIds);
        BillInvoice billInvoice = new BillInvoice();
        billInvoice.setInvoiceFlag(flag);
        int i = this.billInvoiceMapper.countByExample(billInvoiceExample);
        if (i > 0) {
            this.billInvoiceMapper.updateByExampleSelective(billInvoice, billInvoiceExample);
        }
    }

    @Override
    @Cacheable(value={"billInvoice"}, keyGenerator="redisKeyGenerator")
    public List<BillInvoice> queryByBillId(String billId) {
        Assert.isNotBlank((String)billId, (String)"\u53d1\u7968ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BillInvoiceExample billInvoiceExample = new BillInvoiceExample();
        billInvoiceExample.createCriteria().andBillIdEqualTo(billId);
        return this.billInvoiceMapper.selectByExample(billInvoiceExample);
    }

    @CacheEvict(value={"billInvoice"}, allEntries=true)
    public void addObj(BillInvoice t) {
        this.billInvoiceMapper.insertSelective(t);
    }

    @CacheEvict(value={"billInvoice"}, allEntries=true)
    public void deleteObjById(String id) {
        this.billInvoiceMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"billInvoice"}, allEntries=true)
    public void modifyObj(BillInvoice t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.billInvoiceMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"billInvoice"}, keyGenerator="redisKeyGenerator")
    public BillInvoice queryObjById(String id) {
        return this.billInvoiceMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"billInvoice"}, keyGenerator="redisKeyGenerator")
    public List<BillInvoice> queryAllObjByExample(BillInvoiceExample example) {
        return this.billInvoiceMapper.selectByExample(example);
    }

    @Cacheable(value={"billInvoice"}, keyGenerator="redisKeyGenerator")
    public PageView<BillInvoice> queryObjByPage(BillInvoiceExample example) {
        PageView<BillInvoice> pageView = example.getPageView();
        pageView.setQueryResult(this.billInvoiceMapper.selectByExampleByPage(example));
        return pageView;
    }
}

