/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.payment.command;

import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.payment.service.BillPaymentImportFromSapService;
import com.els.base.payment.vo.BillPaymentVo;
import com.els.base.utils.SpringContextHolder;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class ImportCommand
extends AbstractBillCommand<String> {
    BillPaymentVo billPaymentVo;

    public ImportCommand() {
    }

    public ImportCommand(BillPaymentVo billPaymentVo) {
        this.billPaymentVo = billPaymentVo;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.validate(this.billPaymentVo);
        this.processor(this.billPaymentVo);
        return null;
    }

    private void processor(BillPaymentVo billPaymentVo) {
        BillPaymentImportFromSapService billPaymentImportFromSapService = (BillPaymentImportFromSapService)SpringContextHolder.getOneBean(BillPaymentImportFromSapService.class);
        billPaymentImportFromSapService.importBillPaymentFromSap(billPaymentVo.getType(), billPaymentVo.getStartYear(), billPaymentVo.getEndYear(), billPaymentVo.getPaymentStartTime(), billPaymentVo.getPaymentEndTime(), billPaymentVo.getCompanySapCode());
    }

    private void validate(BillPaymentVo billPaymentVo) {
        Assert.isNotNull((Object)billPaymentVo, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)billPaymentVo.getType(), (String)"\u4ed8\u6b3e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)billPaymentVo.getCompanySapCode(), (String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)billPaymentVo.getStartYear(), (String)"\u4f1a\u8ba1\u5f00\u59cb\u5e74\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)billPaymentVo.getEndYear(), (String)"\u4f1a\u8ba1\u7ed3\u675f\u5e74\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (!StringUtils.isNumeric((String)billPaymentVo.getType())) {
            throw new CommonException("\u7c7b\u578b\u7684\u503c\u4e0d\u5bf9\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (billPaymentVo.getStartYear() > billPaymentVo.getEndYear()) {
            throw new CommonException("\u4f1a\u8ba1\u5e74\u9650\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        Date paymentStartTime = billPaymentVo.getPaymentStartTime();
        Date paymentEndTime = billPaymentVo.getPaymentEndTime();
        if (paymentStartTime != null && paymentEndTime != null && paymentStartTime.getTime() > paymentEndTime.getTime()) {
            throw new CommonException("\u51ed\u8bc1\u65f6\u95f4\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }
}

