/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.payment.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.payment.dao.BillPaymentMapper;
import com.els.base.payment.entity.BillPayment;
import com.els.base.payment.entity.BillPaymentExample;
import com.els.base.payment.service.BillPaymentService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultBillPaymentService")
public class BillPaymentServiceImpl
implements BillPaymentService {
    @Resource
    protected BillPaymentMapper billPaymentMapper;

    @Override
    @CacheEvict(value={"billPayment"}, allEntries=true)
    public int insertBatch(List<BillPayment> list) {
        Assert.isNotEmpty(list, (String)"\u4ed8\u6b3e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        return this.billPaymentMapper.insertBatch(list);
    }

    @CacheEvict(value={"billPayment"}, allEntries=true)
    public void addObj(BillPayment t) {
        this.billPaymentMapper.insertSelective(t);
    }

    @CacheEvict(value={"billPayment"}, allEntries=true)
    public void deleteObjById(String id) {
        this.billPaymentMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"billPayment"}, allEntries=true)
    public void modifyObj(BillPayment t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.billPaymentMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"billPayment"}, keyGenerator="redisKeyGenerator")
    public BillPayment queryObjById(String id) {
        return this.billPaymentMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"billPayment"}, keyGenerator="redisKeyGenerator")
    public List<BillPayment> queryAllObjByExample(BillPaymentExample example) {
        return this.billPaymentMapper.selectByExample(example);
    }

    @Cacheable(value={"billPayment"}, keyGenerator="redisKeyGenerator")
    public PageView<BillPayment> queryObjByPage(BillPaymentExample example) {
        PageView<BillPayment> pageView = example.getPageView();
        pageView.setQueryResult(this.billPaymentMapper.selectByExampleByPage(example));
        return pageView;
    }
}

