/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.rebate.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.invoice.entity.BillInvoice;
import com.els.base.rebate.dao.BillInvoiceRebateMapper;
import com.els.base.rebate.entity.BillInvoiceRebate;
import com.els.base.rebate.entity.BillInvoiceRebateExample;
import com.els.base.rebate.service.BillInvoiceRebateService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBillInvoiceRebateService")
public class BillInvoiceRebateServiceImpl
implements BillInvoiceRebateService {
    @Resource
    protected BillInvoiceRebateMapper billInvoiceRebateMapper;

    @Override
    @CacheEvict(value={"billInvoiceRebate"}, allEntries=true)
    @Transactional
    public void deleteInvoiceRebate(BillInvoice billInvoice) {
        Assert.isNotNull((Object)billInvoice, (String)"\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)billInvoice.getId(), (String)"\u53d1\u7968ID\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)billInvoice.getBillId(), (String)"\u5bf9\u8d26\u6e05\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BillInvoiceRebateExample billInvoiceRebateExample = new BillInvoiceRebateExample();
        billInvoiceRebateExample.createCriteria().andBillIdEqualTo(billInvoice.getBillId()).andBillInvoiceIdEqualTo(billInvoice.getId());
        List<BillInvoiceRebate> billInvoiceRebates = this.billInvoiceRebateMapper.selectByExample(billInvoiceRebateExample);
        if (CollectionUtils.isEmpty(billInvoiceRebates)) {
            for (BillInvoiceRebate billInvoiceRebate : billInvoiceRebates) {
                this.billInvoiceRebateMapper.deleteByPrimaryKey(billInvoiceRebate.getId());
            }
        }
    }

    @CacheEvict(value={"billInvoiceRebate"}, allEntries=true)
    public void addObj(BillInvoiceRebate t) {
        this.billInvoiceRebateMapper.insertSelective(t);
    }

    @CacheEvict(value={"billInvoiceRebate"}, allEntries=true)
    public void deleteObjById(String id) {
        this.billInvoiceRebateMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"billInvoiceRebate"}, allEntries=true)
    public void modifyObj(BillInvoiceRebate t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.billInvoiceRebateMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"billInvoiceRebate"}, keyGenerator="redisKeyGenerator")
    public BillInvoiceRebate queryObjById(String id) {
        return this.billInvoiceRebateMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"billInvoiceRebate"}, keyGenerator="redisKeyGenerator")
    public List<BillInvoiceRebate> queryAllObjByExample(BillInvoiceRebateExample example) {
        return this.billInvoiceRebateMapper.selectByExample(example);
    }

    @Cacheable(value={"billInvoiceRebate"}, keyGenerator="redisKeyGenerator")
    public PageView<BillInvoiceRebate> queryObjByPage(BillInvoiceRebateExample example) {
        PageView<BillInvoiceRebate> pageView = example.getPageView();
        pageView.setQueryResult(this.billInvoiceRebateMapper.selectByExampleByPage(example));
        return pageView;
    }
}

