/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.voucher.command;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.voucher.entity.BillVoucher;
import com.els.base.voucher.vo.BillVoucherVo;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.BeanUtils;

public class ExportExcelUtil {
    public static FileData getBillVoucherFileData(List<BillVoucher> billVoucherList) throws IOException {
        FileData fileData = new FileData();
        String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
        fileData.setProjectId(ProjectUtils.getProjectId());
        fileData.setCompanyId(CompanyUtils.currentCompanyId());
        fileData.setFileName(MessageFormat.format("\u53ef\u5f00\u7968\u51ed\u8bc1-{0}", dateStr) + ".xls");
        fileData.setFileSuffix("xls");
        fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
        fileData.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
        fileData = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
        FileOutputStream fos = new FileOutputStream(fileData.toFile());
        if (CollectionUtils.isEmpty(billVoucherList)) {
            return fileData;
        }
        ArrayList<BillVoucherVo> billVoucherVos = new ArrayList<BillVoucherVo>();
        for (BillVoucher billVoucher : billVoucherList) {
            BillVoucherVo billVoucherVo = new BillVoucherVo();
            BeanUtils.copyProperties((Object)billVoucher, (Object)billVoucherVo);
            billVoucherVos.add(billVoucherVo);
        }
        ExportParams params = new ExportParams();
        params.setSheetName("\u5165\u9000\u5e93\u51ed\u8bc1");
        params.setType(ExcelType.HSSF);
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, BillVoucherVo.class, billVoucherVos);
        workbook.write((OutputStream)fos);
        fos.flush();
        fos.close();
        return fileData;
    }
}

