/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.deduction.service.impl;

import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.deduction.dao.DeductionMapper;
import com.els.base.deduction.entity.Deduction;
import com.els.base.deduction.entity.DeductionExample;
import com.els.base.deduction.service.DeductionService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultDeductionService")
public class DeductionServiceImpl
implements DeductionService {
    @Resource
    protected DeductionMapper deductionMapper;
    @Resource
    protected CompanyService companyService;

    @CacheEvict(value={"deduction"}, allEntries=true)
    public void addObj(Deduction t) {
        this.deductionMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"deduction"}, allEntries=true)
    public void addAll(List<Deduction> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.deductionMapper.insertBatch(list);
    }

    @CacheEvict(value={"deduction"}, allEntries=true)
    public void deleteObjById(String id) {
        this.deductionMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"deduction"}, allEntries=true)
    public void deleteByExample(DeductionExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.deductionMapper.deleteByExample(example);
    }

    @CacheEvict(value={"deduction"}, allEntries=true)
    public void modifyObj(Deduction t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.deductionMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"deduction"}, keyGenerator="redisKeyGenerator")
    public Deduction queryObjById(String id) {
        return this.deductionMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"deduction"}, keyGenerator="redisKeyGenerator")
    public List<Deduction> queryAllObjByExample(DeductionExample example) {
        return this.deductionMapper.selectByExample(example);
    }

    @Cacheable(value={"deduction"}, keyGenerator="redisKeyGenerator")
    public PageView<Deduction> queryObjByPage(DeductionExample example) {
        PageView<Deduction> pageView = example.getPageView();
        pageView.setQueryResult(this.deductionMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"deduction"}, allEntries=true)
    public void insert(Deduction deduction, Company company, User user) {
        this.valid(deduction);
        this.complete(deduction, company, user);
        this.addObj(deduction);
    }

    private void complete(Deduction deduction, Company company, User user) {
        deduction.setPurCompanyId(company.getId());
        deduction.setPurCompanyFullName(company.getCompanyFullName());
        deduction.setPurCompanyName(company.getCompanyName());
        deduction.setPurCompanySapCode(company.getCompanySapCode());
        deduction.setPurCompanySrmCode(company.getCompanyCode());
        Company supCompany = this.companyService.queryCompanyBySapCode(deduction.getSupCompanySapCode());
        deduction.setSupCompanyFullName(supCompany.getCompanyFullName());
        deduction.setSupCompanyId(supCompany.getId());
        deduction.setSupCompanyName(supCompany.getCompanyName());
        deduction.setSupCompanySapCode(supCompany.getCompanySapCode());
        deduction.setSupCompanySrmCode(supCompany.getCompanyCode());
        deduction.setProjectId(company.getProjectId());
        deduction.setBillFlag(Constant.NO_INT);
        deduction.setCurrencyType("RMB");
        deduction.setIsEnable(Constant.YES_INT);
        deduction.setCreateTime(new Date());
        deduction.setCreateUserName(user.getNickName());
        deduction.setOperateDate(new Date());
        deduction.setOperateUser(user.getNickName());
        String companyCode = deduction.getCompanyCode();
        String dateTime = DateFormatUtils.format((Date)deduction.getCreateTime(), (String)"yyyyMM");
        DeductionExample example = new DeductionExample();
        example.createCriteria().andDeductionNoLike(dateTime + companyCode + "____");
        int i = this.deductionMapper.countByExample(example);
        String format = String.format("%s%s%04d", dateTime, companyCode, i + 1);
        deduction.setDeductionNo(format);
    }

    private void valid(Deduction deduction) {
        Assert.isNotBlank((String)deduction.getCompanyCode(), (String)"\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)deduction.getCompanyName(), (String)"\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)deduction.getSupCompanySapCode(), (String)"\u4f9b\u5e94\u5546sap\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)deduction.getSupCompanyFullName(), (String)"\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)deduction.getDeductionDate(), (String)"\u6263\u6b3e\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)deduction.getDeductionAmount(), (String)"\u6263\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)deduction.getDeductionType(), (String)"\u6263\u6b3e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    @CacheEvict(value={"deduction"}, allEntries=true)
    public void modify(Deduction deduction, User user) {
        this.valid(deduction);
        this.complete(deduction, user);
        this.modifyObj(deduction);
    }

    private void complete(Deduction deduction, User user) {
        Company supCompany = this.companyService.queryCompanyBySapCode(deduction.getSupCompanySapCode());
        deduction.setSupCompanyFullName(supCompany.getCompanyFullName());
        deduction.setSupCompanyId(supCompany.getId());
        deduction.setSupCompanyName(supCompany.getCompanyName());
        deduction.setSupCompanySapCode(supCompany.getCompanySapCode());
        deduction.setSupCompanySrmCode(supCompany.getCompanyCode());
        deduction.setBillFlag(Constant.NO_INT);
        deduction.setOperateDate(new Date());
        deduction.setOperateUser(user.getNickName());
    }
}

