/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.finance.service.impl;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.bill.entity.BillItem;
import com.els.base.bill.entity.BillItemExample;
import com.els.base.bill.service.BillItemService;
import com.els.base.bill.service.BillService;
import com.els.base.bill.utils.BillStatus;
import com.els.base.common.ICommandInvoker;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.dealings.entity.BillDealings;
import com.els.base.dealings.service.BillDealingsService;
import com.els.base.finance.command.ComandInvoker;
import com.els.base.finance.command.GetDealingsListCommand;
import com.els.base.finance.command.GetSapVoucherListCommand;
import com.els.base.finance.command.WriteBackDeductionCommand;
import com.els.base.finance.command.WriteBackInvetoryCommand;
import com.els.base.finance.command.WriteBackSapBillCommand;
import com.els.base.finance.command.WriteBackSapGoodsCommand;
import com.els.base.finance.deductionSap.ZSRMRFCDZDPZResponse;
import com.els.base.finance.invetorySap.ZSRMRFCMKOLResponse;
import com.els.base.finance.sap.TABLEOFZSRMRFCRKPZ;
import com.els.base.finance.sap.TABLEOFZSRMRFCWLZ;
import com.els.base.finance.sap.ZSRMRFCRET;
import com.els.base.finance.sap.ZSRMRFCRKFPResponse;
import com.els.base.finance.sap.ZSRMRFCRKPZ2;
import com.els.base.finance.sap.ZSRMRFCWLZ2;
import com.els.base.finance.service.SapBillService;
import com.els.base.finance.soap.ZSRMRFCSHTZDResponse;
import com.els.base.invoice.entity.BillInvoice;
import com.els.base.invoice.entity.BillInvoiceExample;
import com.els.base.invoice.service.BillInvoiceService;
import com.els.base.plan.entity.DeliveryPlanExample;
import com.els.base.plan.service.DeliveryPlanService;
import com.els.base.purchase.service.PurOrderItemExtService;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.purchase.service.SupplierOrderItemService;
import com.els.base.taxclassify.entity.TaxClassify;
import com.els.base.taxclassify.entity.TaxClassifyExample;
import com.els.base.taxclassify.service.TaxClassifyService;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.voucher.entity.BillVoucher;
import com.els.base.voucher.entity.BillVoucherExample;
import com.els.base.voucher.service.BillVoucherService;
import com.els.liby.invetory.entity.SupInvetoryDetail;
import com.els.liby.invetory.entity.SupInvetoryDetailExample;
import com.els.liby.invetory.service.SupInvetoryDetailService;
import com.els.liby.organization.entity.Organization;
import com.els.liby.organization.entity.OrganizationExample;
import com.els.liby.organization.service.OrganizationService;
import com.google.common.collect.ArrayListMultimap;
import com.google.gson.Gson;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SapBillServiceImpl
implements SapBillService {
    private static Logger log = LoggerFactory.getLogger(SapBillServiceImpl.class);
    private static Gson json = new Gson();
    @Resource
    private CompanyService companyService;
    @Resource
    private BillService billService;
    @Resource
    private BillVoucherService billVoucherService;
    @Resource
    private ComandInvoker billFinaceComandInvoker;
    @Resource
    private ICommandInvoker iCommandInvoker;
    @Resource
    private BillItemService billItemService;
    @Resource
    private BillInvoiceService billInvoiceService;
    @Resource
    private TaxClassifyService taxClassfyService;
    @Resource
    private BillDealingsService billDealingsService;
    @Resource
    private DeliveryPlanService deliveryPlanService;
    @Resource
    private PurOrderItemExtService purOrderItemExtService;
    @Resource
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Resource
    private SupInvetoryDetailService supInvetoryDetailService;
    @Resource
    private SupplierOrderItemService supplierOrderItemService;
    @Resource
    private PurchaseOrderItemService purchaseOrderItemService;
    @Resource
    private OrganizationService organizationService;

    @Override
    public void writeBackGoodsAndInvetory() {
        this.threadPoolTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                SapBillServiceImpl.this.writeBackGoods();
            }
        });
        this.threadPoolTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                SupInvetoryDetailExample example = new SupInvetoryDetailExample();
                example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andIsLastestStateEqualTo(Constant.YES_INT).andRecordStatusEqualTo(Constant.YES_INT);
                List invetoryDetails = SapBillServiceImpl.this.supInvetoryDetailService.queryAllObjByExample((IExample)example);
                SapBillServiceImpl.this.invetoryBackSap(invetoryDetails);
            }
        });
    }

    @Override
    @Transactional
    public int importByVoucherDate(String companyCode, String companySapCode, String beginDate, String endDate) throws ParseException {
        TABLEOFZSRMRFCRKPZ outData = this.billFinaceComandInvoker.invoke(new GetSapVoucherListCommand(companyCode, companySapCode, beginDate, endDate));
        List<ZSRMRFCRKPZ2> items = outData.getItem();
        String bukrs = items.get(0).getBUKRS();
        String description = this.getPurCompanyFullName(bukrs);
        Company supCompany = this.getCompanyInformation(companySapCode);
        Company purCompany = this.companyService.queryCompanyByCode("51000000");
        List billVoucherList = items.stream().map(item -> this.initBillVoucher(purCompany, (ZSRMRFCRKPZ2)item, description, supCompany)).collect(Collectors.toList());
        log.info(String.format("EVENT=\u83b7\u53d6sap\u51ed\u8bc1\u5217\u8868|RESULT=%s", json.toJson(billVoucherList)));
        List targetList = billVoucherList.stream().filter(billVoucher -> this.isVoucherExist((BillVoucher)billVoucher)).collect(Collectors.toList());
        List targetList2 = targetList.stream().filter(voucher -> this.isExistsBillType((BillVoucher)voucher, targetList)).collect(Collectors.toList());
        List<BillVoucher> targetVoucherList = targetList2.stream().filter(voucher -> this.isExistsBillType123((BillVoucher)voucher, targetList2)).collect(Collectors.toList());
        log.info(String.format("EVNET=\u53ef\u5165\u5e93\u51ed\u8bc1\u5217\u8868|RESULT=%s", json.toJson(targetVoucherList)));
        if (CollectionUtils.isEmpty(targetVoucherList)) {
            throw new CommonException("\u6682\u65f6\u8fd8\u6ca1\u6709\u5b58\u5728\u9700\u8981\u5bf9\u8d26\u7684\u5165\u9000\u5e93\u51ed\u8bc1\uff01");
        }
        BillVoucherExample example = new BillVoucherExample();
        example.createCriteria().andIsLatestEqualTo(Constant.YES_INT);
        List vouchers = this.billVoucherService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)vouchers)) {
            BillVoucher voucher2 = new BillVoucher();
            voucher2.setIsLatest(Constant.NO_INT);
            this.billVoucherService.updateByExampleSelective(voucher2, example);
        }
        this.insertBillVoucher(targetVoucherList);
        return 0;
    }

    private boolean isExistsBillType123(BillVoucher voucher, List<BillVoucher> billVouchers) {
        List list;
        List voucherList;
        return !"123".equals(voucher.getBillType()) || !CollectionUtils.isEmpty(voucherList = (list = billVouchers.stream().filter(i -> i.getVoucherNo().equals(voucher.getVoucherNo()) && i.getVoucherProject().equals(voucher.getVoucherProject())).collect(Collectors.toList())).stream().filter(i -> i.getBillType().equals("122")).collect(Collectors.toList()));
    }

    private boolean isExistsBillType(BillVoucher voucher, List<BillVoucher> billVouchers) {
        List list;
        List voucherList;
        if (("102".equals(voucher.getBillType()) || "122".equals(voucher.getBillType())) && CollectionUtils.isEmpty(voucherList = (list = billVouchers.stream().filter(i -> i.getVoucherNo().equals(voucher.getVoucherNo()) && i.getVoucherProject().equals(voucher.getVoucherProject())).collect(Collectors.toList())).stream().filter(i -> i.getBillType().equals("101")).collect(Collectors.toList()))) {
            return false;
        }
        return !"162".equals(voucher.getBillType()) || !CollectionUtils.isEmpty(voucherList = (list = billVouchers.stream().filter(i -> i.getVoucherNo().equals(voucher.getVoucherNo()) && i.getVoucherProject().equals(voucher.getVoucherProject())).collect(Collectors.toList())).stream().filter(i -> i.getBillType().equals("161")).collect(Collectors.toList()));
    }

    private Company getCompanyInformation(String companySapCode) {
        CompanyExample example = new CompanyExample();
        example.createCriteria().andCompanySapCodeEqualTo(companySapCode);
        List list = this.companyService.queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)list, (String)("\u4f9b\u5e94\u5546sap\u7f16\u7801" + companySapCode + "\u672a\u5728\u7cfb\u7edf\u7ef4\u62a4"));
        Company supCompany = (Company)list.get(0);
        return supCompany;
    }

    private String getPurCompanyFullName(String bukrs) {
        OrganizationExample ozExample = new OrganizationExample();
        ozExample.createCriteria().andOrganizationTypeEqualTo("T001").andCodeEqualTo(bukrs);
        List organizations = this.organizationService.queryAllObjByExample((IExample)ozExample);
        String description = ((Organization)organizations.get(0)).getDescription();
        Assert.isNotEmpty((Collection)organizations, (String)("\u516c\u53f8\u4ee3\u7801" + bukrs + "\u672a\u5728\u7cfb\u7edf\u7ef4\u62a4"));
        return description;
    }

    private List<BillVoucher> isExists(List<BillVoucher> billVoucherList) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        billVoucherList.stream().forEach(billVoucher -> {
            String key = billVoucher.getVoucherNo() + billVoucher.getVoucherProject();
            multimap.put((Object)key, billVoucher);
        });
        Set keyMaps = multimap.keySet();
        ArrayList<BillVoucher> targetList = new ArrayList<BillVoucher>();
        BillVoucher bill101 = new BillVoucher();
        bill101.setBillType("101");
        for (String key : keyMaps) {
            List lists = multimap.get((Object)key);
            if (lists.contains(bill101)) {
                targetList.addAll(lists);
                continue;
            }
            List newlist = lists.stream().map(b -> {
                if ("122".equals(b.getBillType()) || "102".equals(b.getBillType()) || "123".equals(b.getBillType())) {
                    return null;
                }
                return b;
            }).filter(b -> b != null).collect(Collectors.toList());
            targetList.addAll(newlist);
        }
        BillVoucher bill161 = new BillVoucher();
        bill161.setBillType("161");
        for (String key : keyMaps) {
            List lists = multimap.get((Object)key);
            if (lists.contains(bill161)) {
                targetList.addAll(lists);
                continue;
            }
            List newlist = lists.stream().map(b -> {
                if ("162".equals(b.getBillType())) {
                    return null;
                }
                return b;
            }).filter(b -> b != null).collect(Collectors.toList());
            targetList.addAll(newlist);
        }
        return targetList;
    }

    @Override
    public void writeBackSapBill(List<String> billIds, User user) {
        Assert.isNotEmpty(billIds, (String)"\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a");
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn((List)billIds);
        List bills = this.billService.queryAllObjByExample((IExample)billExample);
        for (Bill bill : bills) {
            if (bill.getPurConfirmBillStatus().equals(Constant.NO_INT)) {
                throw new CommonException("\u9009\u62e9\u7684\u5bf9\u8d26\u5355\u53f7:" + bill.getBillNo() + ",\u91c7\u8d2d\u65b9\u672a\u786e\u8ba4\u53d1\u7968!");
            }
            if (!bill.getAbolishStatus().equals(BillStatus.YES_WRITEBACK.getCode())) continue;
            throw new CommonException("\u9009\u62e9\u7684\u5bf9\u8d26\u5355\u53f7:" + bill.getBillNo() + ",\u5355\u636e\u5df2\u56de\u5199!");
        }
        String payConditionsCode = null;
        for (Bill bill : bills) {
            BillInvoiceExample example = new BillInvoiceExample();
            example.createCriteria().andBillIdEqualTo(bill.getId()).andInvoiceDistributionIsNull().andSapInvoiceNoIsNull();
            example.or().andBillIdEqualTo(bill.getId()).andInvoiceDistributionEqualTo("1").andSapInvoiceNoIsNull();
            List billInvoices = this.billInvoiceService.queryAllObjByExample((IExample)example);
            Assert.isNotEmpty((Collection)billInvoices, (String)"\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            bill.setInvoiceList(billInvoices);
            for (BillInvoice invoice : billInvoices) {
                Assert.isNotNull((Object)invoice.getPostingTime(), (String)"\u53d1\u7968\u8fc7\u8d26\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u7f16\u8f91\u53d1\u7968!");
                BillItemExample itemExample = new BillItemExample();
                itemExample.createCriteria().andBillInvoiceIdEqualTo(invoice.getId()).andIsEnableEqualTo(Constant.YES_INT);
                List List2 = this.billItemService.queryAllObjByExample((IExample)itemExample);
                List<BillItem> billItems = this.Exists(List2);
                BigDecimal rng = billItems.get(0).getQuantity();
                invoice.setBillVoucherList(billItems);
                payConditionsCode = bill.getPayConditionsCode();
                ZSRMRFCRKFPResponse responseResult = this.billFinaceComandInvoker.invoke(new WriteBackSapBillCommand(invoice, payConditionsCode, user, rng));
                log.info(String.format("EVENT=\u5bf9\u8d26\u56de\u5199sap|PARAMS=%s|RESULT=%s", json.toJson((Object)invoice), json.toJson((Object)responseResult)));
                ZSRMRFCRET esnfo = responseResult.getESINFO();
                if (!"S".equals(esnfo.getTYPE())) {
                    throw new CommonException(esnfo.getMSG());
                }
                example.clear();
                example.createCriteria().andIdEqualTo(invoice.getId());
                invoice.setSapInvoiceNo(responseResult.getEBELNR());
                invoice.setVoucher(responseResult.getEKJPZH());
                this.billInvoiceService.updateByExampleSelective(invoice, example);
                List collect = billInvoices.stream().filter(i -> StringUtils.isEmpty((String)i.getSapInvoiceNo())).collect(Collectors.toList());
                BillItem tmpItem = new BillItem();
                Bill tmpBill = new Bill();
                if (CollectionUtils.isEmpty(collect)) {
                    tmpBill.setAbolishStatus(BillStatus.YES_WRITEBACK.getCode());
                    tmpItem.setAbolishStatus(BillStatus.YES_WRITEBACK.getCode());
                } else {
                    tmpBill.setAbolishStatus(BillStatus.PORTION_WRITEBACK.getCode());
                    tmpItem.setAbolishStatus(BillStatus.PORTION_WRITEBACK.getCode());
                }
                billExample.clear();
                billExample.createCriteria().andIdIn((List)billIds);
                this.billService.updateByExampleSelective(tmpBill, billExample);
                itemExample.clear();
                itemExample.createCriteria().andBillIdIn((List)billIds);
                this.billItemService.updateByExampleSelective(tmpItem, itemExample);
            }
        }
    }

    private List<BillItem> Exists(List<BillItem> billItems) {
        BigDecimal rng = new BigDecimal(0);
        ArrayList<BillItem> comBillItems = new ArrayList<BillItem>();
        Map map = billItems.stream().collect(Collectors.groupingBy(o -> o.getVoucherNo() + "_" + o.getVoucherProject(), Collectors.toList()));
        for (String key : map.keySet()) {
            BillItem billItem;
            List list = map.get(key);
            List voucherList = list.stream().filter(i -> i.getBillType().equals("101")).collect(Collectors.toList());
            List voucherList2 = list.stream().filter(i -> i.getBillType().equals("161")).collect(Collectors.toList());
            BigDecimal add = list.stream().map(i -> i.getNotIncludeTaxAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal quantity = list.stream().map(i -> i.getMaterialQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (quantity.compareTo(new BigDecimal(0)) == 0) {
                if (add.compareTo(new BigDecimal(0)) == 0) continue;
                rng = rng.add(add);
                continue;
            }
            if (CollectionUtils.isNotEmpty(voucherList)) {
                billItem = (BillItem)voucherList.get(0);
                billItem.setNotIncludeTaxAmount(add);
                billItem.setMaterialQuantity(quantity);
                comBillItems.add(billItem);
                continue;
            }
            if (!CollectionUtils.isNotEmpty(voucherList2)) continue;
            billItem = (BillItem)voucherList2.get(0);
            billItem.setNotIncludeTaxAmount(add);
            billItem.setMaterialQuantity(quantity);
            comBillItems.add(billItem);
        }
        ((BillItem)comBillItems.get(0)).setQuantity(rng);
        return comBillItems;
    }

    @Override
    @Transactional
    public void writeBackGoods() {
        DeliveryPlanExample example = new DeliveryPlanExample();
        example.createCriteria().andIsLockEqualTo("F");
        List deliveryPlans = this.deliveryPlanService.queryAllObjByExample((IExample)example);
        ZSRMRFCSHTZDResponse responseResult = this.billFinaceComandInvoker.invoke(new WriteBackSapGoodsCommand(deliveryPlans));
        ZSRMRFCRET esinfo = responseResult.getESINFO();
        if (!"S".equals(esinfo.getTYPE())) {
            throw new CommonException(esinfo.getMSG());
        }
    }

    @Override
    @Transactional
    public void invetoryBackSap(List<SupInvetoryDetail> invetoryDetails) {
        ZSRMRFCMKOLResponse responseResult = this.billFinaceComandInvoker.invoke(new WriteBackInvetoryCommand(invetoryDetails));
        com.els.base.finance.invetorySap.ZSRMRFCRET esinfo = responseResult.getESINFO();
        if (!"S".equals(esinfo.getTYPE())) {
            throw new CommonException(esinfo.getMSG());
        }
    }

    @Override
    @Transactional
    public void deductionBackSap(Bill bill) {
        ZSRMRFCDZDPZResponse responseResult = this.billFinaceComandInvoker.invoke(new WriteBackDeductionCommand(bill));
        com.els.base.finance.deductionSap.ZSRMRFCRET esinfo = responseResult.getESINFO();
        if (!"S".equals(esinfo.getTYPE())) {
            throw new CommonException(esinfo.getMSG());
        }
    }

    private void insertBillVoucher(List<BillVoucher> voucherList) {
        if (CollectionUtils.isEmpty(voucherList)) {
            return;
        }
        for (BillVoucher billVoucher : voucherList) {
            billVoucher.setId(null);
            billVoucher.setIsEnable(Constant.YES_INT);
            billVoucher.setBillFlag(0);
            this.billVoucherService.addObj(billVoucher);
        }
    }

    private Boolean isVoucherExist(BillVoucher billVoucher) {
        String materialVoucherNo = billVoucher.getMaterialVoucherNo();
        String materialVoucherItemNo = billVoucher.getMaterialVoucherItemNo();
        String billType = billVoucher.getBillType();
        String supCompanySapCode = billVoucher.getSupCompanySapCode();
        log.info("\u7269\u6599\u51ed\u8bc1\u53f7\u4e3a\uff1a{}", (Object)materialVoucherNo);
        log.info("\u7269\u6599\u51ed\u8bc1\u884c\u53f7\u4e3a\uff1a{}", (Object)materialVoucherItemNo);
        log.info("\u79fb\u52a8\u7c7b\u578b\uff1a{}", (Object)billType);
        if (StringUtils.isEmpty((String)billType) || StringUtils.isEmpty((String)supCompanySapCode)) {
            return false;
        }
        BillVoucherExample billVoucherExample = new BillVoucherExample();
        billVoucherExample.createCriteria().andBillTypeEqualTo(billType).andMaterialVoucherNoEqualTo(materialVoucherNo).andMaterialVoucherItemNoEqualTo(materialVoucherItemNo);
        List list = this.billVoucherService.queryAllObjByExample((IExample)billVoucherExample);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List list2 = list.stream().filter(i -> Constant.NO_INT.equals(i.getBillFlag())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(list2)) {
                this.billVoucherService.deleteByExample((IExample)billVoucherExample);
                return true;
            }
            return false;
        }
        return true;
    }

    private BillVoucher initBillVoucher(Company purCompany, ZSRMRFCRKPZ2 item, String description, Company supCompany) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        BillVoucher billVoucher = new BillVoucher();
        String cpudt = item.getCPUDT();
        XMLGregorianCalendar cputm = item.getCPUTM();
        String xmlFormat = cputm.toXMLFormat();
        cpudt = cpudt + " " + xmlFormat;
        this.setPurCompanyInfo(purCompany, description, billVoucher);
        this.setSupCompanyInfo(item, billVoucher, supCompany);
        billVoucher.setAccountingYear(item.getMJAHR());
        billVoucher.setMaterialVoucherNo(item.getMBLNR());
        billVoucher.setMaterialVoucherItemNo(item.getZEILE());
        if (StringUtils.isNotEmpty((String)item.getKONNR())) {
            billVoucher.setAgreementNo(item.getKONNR());
            billVoucher.setAgreementItemNo(item.getKTPNR());
            try {
                billVoucher.setAgreementDate(sdf.parse(item.getVEDAT()));
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new CommonException(e.getMessage());
            }
        }
        try {
            billVoucher.setVoucherTime(sdf.parse(item.getBLDAT()));
            billVoucher.setPostingTime(sdf.parse(item.getBUDAT()));
            billVoucher.setInputDate(s.parse(cpudt));
            billVoucher.setInputTime(sdf.parse(item.getBEDAT()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException(e.getMessage());
        }
        billVoucher.setPurchaseOrderNo(item.getEBELN());
        billVoucher.setPurchaseOrderItemNo(item.getEBELP());
        billVoucher.setPurchaseOrderNo(item.getEBELN());
        billVoucher.setMaterialNo(item.getMATNR().replaceAll("^0+", ""));
        billVoucher.setMaterialDesc(item.getMAKTX());
        billVoucher.setStockSpaceCode(item.getLGORT());
        billVoucher.setStockSpaceRemark(item.getLGOBE());
        billVoucher.setCompany(item.getBUKRS());
        billVoucher.setFactory(item.getWERKS());
        Assert.isNotBlank((String)item.getBWART(), (String)"\u79fb\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        billVoucher.setBillType(item.getBWART());
        Assert.isNotNull((Object)item.getMENGE(), (String)"\u7269\u6599\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        billVoucher.setMaterialQuantity(item.getMENGE());
        billVoucher.setMaterialUnit(item.getMEINS());
        billVoucher.setUserName(item.getUSNAM());
        billVoucher.setDeliveryOrderNo(item.getZZSHD());
        billVoucher.setDeliveryOrderItemNo(item.getZSHDH());
        billVoucher.setPaymentWay(item.getZTERM());
        billVoucher.setMark(item.getZFLAG());
        billVoucher.setTaxCode(item.getMWSKZ());
        billVoucher.setTaxRate(item.getTEXT1());
        billVoucher.setOrderPrice(item.getNETPR());
        billVoucher.setPriceEntity(item.getPEINH());
        billVoucher.setIsLatest(Constant.YES_INT);
        if (billVoucher.getPriceEntity().compareTo(new BigDecimal(0)) != 1) {
            throw new CommonException("\u4ef7\u683c\u5355\u4f4d\u53ea\u80fd\u4e3a\u6b63\u6570\uff01");
        }
        BigDecimal divide = billVoucher.getOrderPrice().divide(billVoucher.getPriceEntity(), 10, 5);
        BigDecimal multiply = divide.multiply(billVoucher.getMaterialQuantity());
        BigDecimal scale = multiply.setScale(2, 4);
        billVoucher.setNotIncludeTaxAmount(scale);
        BigDecimal multiply2 = billVoucher.getNotIncludeTaxAmount().multiply(billVoucher.getTaxRate());
        BigDecimal scale2 = multiply2.setScale(2, 4);
        billVoucher.setTaxAmount(scale2);
        BigDecimal decimal = billVoucher.getNotIncludeTaxAmount().add(scale2);
        BigDecimal scale3 = decimal.setScale(2, 4);
        billVoucher.setIncludeTaxAmount(scale3);
        BigDecimal divide2 = scale3.divide(billVoucher.getMaterialQuantity(), 10, 4);
        BigDecimal scale4 = divide2.setScale(4, 4);
        billVoucher.setLatestPrice(scale4);
        if ("-".equals(billVoucher.getMark())) {
            billVoucher.setNotIncludeTaxAmount(scale.multiply(new BigDecimal(-1)));
            billVoucher.setTaxAmount(scale2.multiply(new BigDecimal(-1)));
            billVoucher.setIncludeTaxAmount(scale3.multiply(new BigDecimal(-1)));
            billVoucher.setMaterialQuantity(billVoucher.getMaterialQuantity().multiply(new BigDecimal(-1)));
        }
        billVoucher.setCurrencyType(item.getWAERS());
        TaxClassifyExample example = new TaxClassifyExample();
        example.createCriteria().andCustomerMaterialNoEqualTo(billVoucher.getMaterialNo());
        List taxClassifies = this.taxClassfyService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)taxClassifies)) {
            TaxClassify taxClassify = (TaxClassify)taxClassifies.get(0);
            billVoucher.setGoodsandlaborName(taxClassify.getGoodsandlaborName());
            billVoucher.setCombinedTaxCode(((TaxClassify)taxClassifies.get(0)).getCombinedTaxCode());
        }
        billVoucher.setVoucherAccountingYear(item.getLFGJA());
        billVoucher.setVoucherNo(item.getLFBNR());
        billVoucher.setVoucherProject(item.getLFPOS());
        billVoucher.setIsEnable(Constant.YES_INT);
        return billVoucher;
    }

    private void setPurCompanyInfo(Company purCompany, String description, BillVoucher billVoucher) {
        billVoucher.setPurCompanyId(purCompany.getId());
        billVoucher.setPurCompanySapCode(purCompany.getCompanySapCode());
        billVoucher.setPurCompanySrmCode(purCompany.getCompanyCode());
        billVoucher.setPurCompanyName(purCompany.getCompanyName());
        billVoucher.setPurCompanyFullName(purCompany.getCompanyFullName());
    }

    private void setSupCompanyInfo(ZSRMRFCRKPZ2 item, BillVoucher billVoucher, Company company) {
        String sapCode = item.getLIFNR();
        if (StringUtils.isNotBlank((String)sapCode)) {
            sapCode = sapCode.replaceAll("^0+", "");
        }
        billVoucher.setSupCompanyFullName(company.getCompanyFullName());
        billVoucher.setSupCompanyName(company.getCompanyName());
        billVoucher.setSupCompanySrmCode(company.getCompanyCode());
        billVoucher.setSupCompanySapCode(sapCode);
        billVoucher.setSupCompanyId(company.getId());
    }

    @Override
    public int importByDealings() {
        this.importByDealings(DateUtils.addDays((Date)new Date(), (int)-1), null);
        return 0;
    }

    @Override
    public int importByDealings(Date startTime, Date endTime) {
        TABLEOFZSRMRFCWLZ outData = this.billFinaceComandInvoker.invoke(new GetDealingsListCommand(startTime, endTime));
        if (outData == null) {
            return 0;
        }
        List<ZSRMRFCWLZ2> items = outData.getItem();
        if (CollectionUtils.isEmpty(items)) {
            return 0;
        }
        List<ZSRMRFCWLZ2> its = this.isWlzExist(items);
        Company purCompany = this.companyService.queryCompanyByCode("51000000");
        List<BillDealings> dealingList = its.stream().map(item -> this.initBillDealings((ZSRMRFCWLZ2)item, purCompany)).collect(Collectors.toList());
        this.insertBillDealings(dealingList);
        return 0;
    }

    private List<ZSRMRFCWLZ2> isWlzExist(List<ZSRMRFCWLZ2> items) {
        ArrayList<ZSRMRFCWLZ2> wlz = new ArrayList<ZSRMRFCWLZ2>();
        for (ZSRMRFCWLZ2 item : items) {
            if (!"C001".equals(item.getKTOKK()) && !"C002".equals(item.getKTOKK()) && !"C006".equals(item.getKTOKK())) continue;
            wlz.add(item);
        }
        return wlz;
    }

    private void insertBillDealings(List<BillDealings> dealingList) {
        if (CollectionUtils.isEmpty(dealingList)) {
            return;
        }
        for (BillDealings dealing : dealingList) {
            dealing.setId(UUIDGenerator.generateUUID());
            dealing.setIsEnable(Constant.YES_INT);
            this.billDealingsService.addObj(dealing);
        }
    }

    private BillDealings initBillDealings(ZSRMRFCWLZ2 item, Company purCompany) {
        BillDealings dealings = new BillDealings();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        dealings.setPurCompanyId(purCompany.getId());
        dealings.setPurCompanySrmCode(purCompany.getCompanyCode());
        dealings.setPurCompanyFullName(purCompany.getCompanyFullName());
        dealings.setPurCompanyName(purCompany.getCompanyName());
        dealings.setClearingMark(item.getZQZBS());
        dealings.setCompanyCode(item.getBUKRS());
        dealings.setCompanyName(item.getBUTXT());
        dealings.setSupCompanySapCode(item.getLIFNR());
        dealings.setSupCompanySapName(item.getNAME1());
        try {
            dealings.setPostingDate(format.parse(item.getBUDAT()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        dealings.setVoucherType(item.getBLART());
        dealings.setSubject(item.getHKONT());
        dealings.setSubjectRemark(item.getTXT20());
        dealings.setVoucherNo(item.getBELNR());
        dealings.setLocalCurrencyPrice(item.getDMBTR());
        dealings.setLocalCurrency(item.getWAERS());
        dealings.setRemark(item.getSGTXT());
        dealings.setDirection(item.getSHKZG());
        dealings.setVoucherBillNo(item.getAUGBL());
        dealings.setCreateTime(new Date());
        dealings.setUpdateTime(new Date());
        return dealings;
    }
}

