/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.finance.service.impl;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.service.BillService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.finance.command.ComandInvoker;
import com.els.base.finance.command.GetVoucherTimeTaskCommand;
import com.els.base.finance.command.WriteBackDeductionCommand;
import com.els.base.finance.deductionSap.ZSRMRFCDZDPZResponse;
import com.els.base.finance.deductionSap.ZSRMRFCRET;
import com.els.base.finance.sap.TABLEOFZSRMRFCRKPZ;
import com.els.base.finance.sap.ZSRMRFCRKPZ2;
import com.els.base.finance.service.VoucherTimeTaskService;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.taxclassify.entity.TaxClassify;
import com.els.base.taxclassify.entity.TaxClassifyExample;
import com.els.base.taxclassify.service.TaxClassifyService;
import com.els.base.util.BillBusinessTypeEnum;
import com.els.base.voucher.entity.BillVoucher;
import com.els.base.voucher.entity.BillVoucherExample;
import com.els.base.voucher.service.BillVoucherService;
import com.els.liby.organization.entity.Organization;
import com.els.liby.organization.entity.OrganizationExample;
import com.els.liby.organization.service.OrganizationService;
import com.google.gson.Gson;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VoucherTimeTaskServiceImpl
implements VoucherTimeTaskService {
    private static Logger log = LoggerFactory.getLogger(VoucherTimeTaskServiceImpl.class);
    private static Gson json = new Gson();
    @Resource
    private CompanyService companyService;
    @Resource
    private BillService billService;
    @Resource
    private BillVoucherService billVoucherService;
    @Resource
    private ComandInvoker billFinaceComandInvoker;
    @Resource
    private TaxClassifyService taxClassfyService;
    @Resource
    private OrganizationService organizationService;

    @Override
    @Transactional
    public List<BillVoucher> importByVoucherDate(String companyCode, String companySapCode, String beginDate, String endDate) throws ParseException {
        TABLEOFZSRMRFCRKPZ outData = this.billFinaceComandInvoker.invoke(new GetVoucherTimeTaskCommand(companyCode, companySapCode, beginDate, endDate));
        if (outData == null || CollectionUtils.isEmpty(outData.getItem())) {
            return null;
        }
        List<ZSRMRFCRKPZ2> items = outData.getItem();
        String bukrs = items.get(0).getBUKRS();
        String description = this.getPurCompanyFullName(bukrs);
        Company supCompany = this.getCompanyInformation(companySapCode);
        Company purCompany = this.companyService.queryCompanyByCode("51000000");
        List billVoucherList = items.stream().map(item -> this.initBillVoucher(purCompany, (ZSRMRFCRKPZ2)item, description, supCompany, companyCode, beginDate, endDate)).collect(Collectors.toList());
        log.info(String.format("EVENT=\u83b7\u53d6sap\u51ed\u8bc1\u5217\u8868|RESULT=%s", json.toJson(billVoucherList)));
        if (CollectionUtils.isEmpty(billVoucherList)) {
            return null;
        }
        List targetList = billVoucherList.stream().filter(billVoucher -> this.isVoucherExist((BillVoucher)billVoucher)).collect(Collectors.toList());
        List targetList2 = targetList.stream().filter(voucher -> this.isExistsBillType((BillVoucher)voucher, targetList)).collect(Collectors.toList());
        List<BillVoucher> targetVoucherList = targetList2.stream().filter(voucher -> this.isExistsBillType123((BillVoucher)voucher, targetList2)).collect(Collectors.toList());
        log.info(String.format("EVNET=\u53ef\u5165\u5e93\u51ed\u8bc1\u5217\u8868|RESULT=%s", json.toJson(targetVoucherList)));
        if (CollectionUtils.isEmpty(targetVoucherList)) {
            return null;
        }
        this.insertBillVoucher(targetVoucherList);
        return targetVoucherList;
    }

    private boolean isExistsBillType123(BillVoucher voucher, List<BillVoucher> billVouchers) {
        List list;
        List voucherList;
        return !"123".equals(voucher.getBillType()) || !CollectionUtils.isEmpty(voucherList = (list = billVouchers.stream().filter(i -> i.getVoucherNo().equals(voucher.getVoucherNo()) && i.getVoucherProject().equals(voucher.getVoucherProject())).collect(Collectors.toList())).stream().filter(i -> i.getBillType().equals("122")).collect(Collectors.toList()));
    }

    private boolean isExistsBillType(BillVoucher voucher, List<BillVoucher> billVouchers) {
        List list;
        List voucherList;
        if (("102".equals(voucher.getBillType()) || "122".equals(voucher.getBillType())) && CollectionUtils.isEmpty(voucherList = (list = billVouchers.stream().filter(i -> i.getVoucherNo().equals(voucher.getVoucherNo()) && i.getVoucherProject().equals(voucher.getVoucherProject())).collect(Collectors.toList())).stream().filter(i -> i.getBillType().equals("101")).collect(Collectors.toList()))) {
            return false;
        }
        return !"162".equals(voucher.getBillType()) || !CollectionUtils.isEmpty(voucherList = (list = billVouchers.stream().filter(i -> i.getVoucherNo().equals(voucher.getVoucherNo()) && i.getVoucherProject().equals(voucher.getVoucherProject())).collect(Collectors.toList())).stream().filter(i -> i.getBillType().equals("161")).collect(Collectors.toList()));
    }

    private Company getCompanyInformation(String companySapCode) {
        Company company = this.companyService.queryCompanyBySapCode(companySapCode);
        return company;
    }

    private String getPurCompanyFullName(String bukrs) {
        OrganizationExample ozExample = new OrganizationExample();
        ozExample.createCriteria().andOrganizationTypeEqualTo("T001").andCodeEqualTo(bukrs);
        List organizations = this.organizationService.queryAllObjByExample((IExample)ozExample);
        String description = ((Organization)organizations.get(0)).getDescription();
        Assert.isNotEmpty((Collection)organizations, (String)("\u516c\u53f8\u4ee3\u7801" + bukrs + "\u672a\u5728\u7cfb\u7edf\u7ef4\u62a4"));
        return description;
    }

    private BillVoucher initBillVoucher(Company purCompany, ZSRMRFCRKPZ2 item, String description, Company supCompany, String companyCode, String beginDate, String endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        BillVoucher billVoucher = new BillVoucher();
        String cpudt = item.getCPUDT();
        XMLGregorianCalendar cputm = item.getCPUTM();
        String xmlFormat = cputm.toXMLFormat();
        cpudt = cpudt + " " + xmlFormat;
        this.setPurCompanyInfo(purCompany, description, billVoucher);
        this.setSupCompanyInfo(item, billVoucher, supCompany);
        billVoucher.setAccountingYear(item.getMJAHR());
        billVoucher.setMaterialVoucherNo(item.getMBLNR());
        billVoucher.setMaterialVoucherItemNo(item.getZEILE());
        if (StringUtils.isNotEmpty((String)item.getKONNR())) {
            billVoucher.setAgreementNo(item.getKONNR());
            billVoucher.setAgreementItemNo(item.getKTPNR());
            try {
                billVoucher.setAgreementDate(sdf.parse(item.getVEDAT()));
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new CommonException(e.getMessage());
            }
        }
        try {
            billVoucher.setVoucherTime(sdf.parse(item.getBLDAT()));
            billVoucher.setPostingTime(sdf.parse(item.getBUDAT()));
            billVoucher.setInputDate(s.parse(cpudt));
            billVoucher.setInputTime(sdf.parse(item.getBEDAT()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException(e.getMessage());
        }
        billVoucher.setPurchaseOrderNo(item.getEBELN());
        billVoucher.setPurchaseOrderItemNo(item.getEBELP());
        billVoucher.setPurchaseOrderNo(item.getEBELN());
        billVoucher.setMaterialNo(item.getMATNR().replaceAll("^0+", ""));
        billVoucher.setMaterialDesc(item.getMAKTX());
        billVoucher.setStockSpaceCode(item.getLGORT());
        billVoucher.setStockSpaceRemark(item.getLGOBE());
        billVoucher.setCompany(item.getBUKRS());
        billVoucher.setFactory(item.getWERKS());
        Assert.isNotBlank((String)item.getBWART(), (String)"\u79fb\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        billVoucher.setBillType(item.getBWART());
        Assert.isNotNull((Object)item.getMENGE(), (String)"\u7269\u6599\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        billVoucher.setMaterialQuantity(item.getMENGE());
        billVoucher.setMaterialUnit(item.getMEINS());
        billVoucher.setUserName(item.getUSNAM());
        billVoucher.setDeliveryOrderNo(item.getZZSHD());
        billVoucher.setDeliveryOrderItemNo(item.getZSHDH());
        billVoucher.setPaymentWay(item.getZTERM());
        billVoucher.setMark(item.getZFLAG());
        billVoucher.setTaxCode(item.getMWSKZ());
        billVoucher.setTaxRate(item.getTEXT1());
        billVoucher.setOrderPrice(item.getNETPR());
        billVoucher.setPriceEntity(item.getPEINH());
        billVoucher.setIsLatest(Constant.YES_INT);
        if (billVoucher.getPriceEntity().compareTo(new BigDecimal(0)) != 1) {
            String reason = "\u4f9b\u5e94\u5546:" + billVoucher.getSupCompanyFullName() + ",\u516c\u53f8:" + companyCode + "\u5165\u53c2\u533a\u95f4:" + beginDate + "-" + endDate + "\u751f\u6210\u5bf9\u8d26\u5355\u5931\u8d25:\u4ef7\u683c\u5355\u4f4d\u53ea\u80fd\u4e3a\u6b63\u6570\uff01";
            this.sendMessagesToPur(reason, BillBusinessTypeEnum.BILL_FALSE_RESAON.getCode());
            return null;
        }
        BigDecimal divide = billVoucher.getOrderPrice().divide(billVoucher.getPriceEntity(), 10, 5);
        BigDecimal multiply = divide.multiply(billVoucher.getMaterialQuantity());
        BigDecimal scale = multiply.setScale(2, 4);
        billVoucher.setNotIncludeTaxAmount(scale);
        BigDecimal multiply2 = billVoucher.getNotIncludeTaxAmount().multiply(billVoucher.getTaxRate());
        BigDecimal scale2 = multiply2.setScale(2, 4);
        billVoucher.setTaxAmount(scale2);
        BigDecimal decimal = billVoucher.getNotIncludeTaxAmount().add(scale2);
        BigDecimal scale3 = decimal.setScale(2, 4);
        billVoucher.setIncludeTaxAmount(scale3);
        BigDecimal divide2 = scale3.divide(billVoucher.getMaterialQuantity(), 10, 4);
        BigDecimal scale4 = divide2.setScale(4, 4);
        billVoucher.setLatestPrice(scale4);
        if ("-".equals(billVoucher.getMark())) {
            billVoucher.setNotIncludeTaxAmount(scale.multiply(new BigDecimal(-1)));
            billVoucher.setTaxAmount(scale2.multiply(new BigDecimal(-1)));
            billVoucher.setIncludeTaxAmount(scale3.multiply(new BigDecimal(-1)));
            billVoucher.setMaterialQuantity(billVoucher.getMaterialQuantity().multiply(new BigDecimal(-1)));
        }
        billVoucher.setCurrencyType(item.getWAERS());
        TaxClassifyExample example = new TaxClassifyExample();
        example.createCriteria().andCustomerMaterialNoEqualTo(billVoucher.getMaterialNo());
        List taxClassifies = this.taxClassfyService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)taxClassifies)) {
            TaxClassify taxClassify = (TaxClassify)taxClassifies.get(0);
            billVoucher.setGoodsandlaborName(taxClassify.getGoodsandlaborName());
            billVoucher.setCombinedTaxCode(((TaxClassify)taxClassifies.get(0)).getCombinedTaxCode());
        }
        billVoucher.setVoucherAccountingYear(item.getLFGJA());
        billVoucher.setVoucherNo(item.getLFBNR());
        billVoucher.setVoucherProject(item.getLFPOS());
        billVoucher.setIsEnable(Constant.YES_INT);
        return billVoucher;
    }

    protected void sendMessagesToPur(String date, String businessType) {
        Message message = Message.init((Object)date).setBusinessTypeCode(businessType).setCompanyCode("51000000").setMsgLevel(MessageLevelEnum.HIGH).addReceiverId("20180704105632-e13655014dce400b9");
        MessageSendUtils.sendMessage((Message)message);
    }

    private void insertBillVoucher(List<BillVoucher> voucherList) {
        if (CollectionUtils.isEmpty(voucherList)) {
            return;
        }
        for (BillVoucher billVoucher : voucherList) {
            billVoucher.setId(null);
            billVoucher.setIsEnable(Constant.YES_INT);
            billVoucher.setBillFlag(0);
            this.billVoucherService.addObj(billVoucher);
        }
    }

    private Boolean isVoucherExist(BillVoucher billVoucher) {
        String materialVoucherNo = billVoucher.getMaterialVoucherNo();
        String materialVoucherItemNo = billVoucher.getMaterialVoucherItemNo();
        String billType = billVoucher.getBillType();
        String supCompanySapCode = billVoucher.getSupCompanySapCode();
        log.info("\u7269\u6599\u51ed\u8bc1\u53f7\u4e3a\uff1a{}", (Object)materialVoucherNo);
        log.info("\u7269\u6599\u51ed\u8bc1\u884c\u53f7\u4e3a\uff1a{}", (Object)materialVoucherItemNo);
        log.info("\u79fb\u52a8\u7c7b\u578b\uff1a{}", (Object)billType);
        if (StringUtils.isEmpty((String)billType) || StringUtils.isEmpty((String)supCompanySapCode)) {
            return false;
        }
        BillVoucherExample billVoucherExample = new BillVoucherExample();
        billVoucherExample.createCriteria().andBillTypeEqualTo(billType).andMaterialVoucherNoEqualTo(materialVoucherNo).andMaterialVoucherItemNoEqualTo(materialVoucherItemNo).andBillFlagEqualTo(Constant.NO_INT);
        int i = this.billVoucherService.countByExample(billVoucherExample);
        if (i > 0) {
            this.billVoucherService.deleteByExample((IExample)billVoucherExample);
        }
        billVoucherExample.clear();
        billVoucherExample.createCriteria().andBillTypeEqualTo(billType).andMaterialVoucherNoEqualTo(materialVoucherNo).andMaterialVoucherItemNoEqualTo(materialVoucherItemNo).andBillFlagEqualTo(Constant.YES_INT);
        int j = this.billVoucherService.countByExample(billVoucherExample);
        if (j > 0) {
            return false;
        }
        return true;
    }

    private void setPurCompanyInfo(Company purCompany, String description, BillVoucher billVoucher) {
        billVoucher.setPurCompanyId(purCompany.getId());
        billVoucher.setPurCompanySapCode(purCompany.getCompanySapCode());
        billVoucher.setPurCompanySrmCode(purCompany.getCompanyCode());
        billVoucher.setPurCompanyName(purCompany.getCompanyName());
        billVoucher.setPurCompanyFullName(purCompany.getCompanyFullName());
    }

    private void setSupCompanyInfo(ZSRMRFCRKPZ2 item, BillVoucher billVoucher, Company company) {
        String sapCode = item.getLIFNR();
        if (StringUtils.isNotBlank((String)sapCode)) {
            sapCode = sapCode.replaceAll("^0+", "");
        }
        billVoucher.setSupCompanyFullName(company.getCompanyFullName());
        billVoucher.setSupCompanyName(company.getCompanyName());
        billVoucher.setSupCompanySrmCode(company.getCompanyCode());
        billVoucher.setSupCompanySapCode(sapCode);
        billVoucher.setSupCompanyId(company.getId());
    }

    @Override
    @Transactional
    public void deductionBackSap(Bill bill) {
        ZSRMRFCDZDPZResponse responseResult = this.billFinaceComandInvoker.invoke(new WriteBackDeductionCommand(bill));
        ZSRMRFCRET esinfo = responseResult.getESINFO();
        if (!"S".equals(esinfo.getTYPE())) {
            String date = "\u4f9b\u5e94\u5546:" + bill.getSupCompanyFullName() + ",\u516c\u53f8:" + bill.getCompanyCode() + "\u5165\u53c2\u533a\u95f4," + DateFormatUtils.format((long)bill.getStartTime().intValue(), (String)"yyyy-MM-dd") + "-" + DateFormatUtils.format((long)bill.getEndTime().intValue(), (String)"yyyy-MM-dd") + "\u751f\u6210\u5bf9\u8d26\u5355\u5931\u8d25:\u51b2\u9500\u51ed\u8bc1\u56de\u5199sap\u5931\u8d25" + esinfo.getMSG();
            this.sendMessagesToPur(date, BillBusinessTypeEnum.BILL_FALSE_RESAON.getCode());
        }
    }
}

