/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.service.impl;

import com.els.base.bill.dao.BillItemMapper;
import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.bill.entity.BillItem;
import com.els.base.bill.entity.BillItemExample;
import com.els.base.bill.service.BillItemService;
import com.els.base.bill.service.BillService;
import com.els.base.bill.utils.BillStatus;
import com.els.base.bill.utils.CalculateBillUtil;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.voucher.entity.BillVoucher;
import com.els.base.voucher.entity.BillVoucherExample;
import com.els.base.voucher.service.BillVoucherService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBillItemService")
public class BillItemServiceImpl
implements BillItemService {
    @Resource
    protected BillItemMapper billItemMapper;
    @Resource
    protected BillVoucherService billVoucherService;
    @Resource
    protected BillService billService;

    @Override
    @Cacheable(value={"billItem"}, keyGenerator="redisKeyGenerator")
    public List<BillItem> queryBillVoucherList(List<String> ids) {
        BillItemExample billItemExample = new BillItemExample();
        List group = Lists.partition(ids, (int)999);
        ArrayList<BillItem> items = new ArrayList<BillItem>();
        for (List list : group) {
            billItemExample.clear();
            billItemExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andBillIdIn(list);
            List<BillItem> list2 = this.billItemMapper.selectByExample(billItemExample);
            items.addAll(list2);
        }
        return items;
    }

    @Override
    @Cacheable(value={"billItem"}, keyGenerator="redisKeyGenerator")
    public List<BillItem> queryBillVoucherList(String id) {
        BillItemExample billItemExample = new BillItemExample();
        billItemExample.createCriteria().andBillInvoiceIdEqualTo(id).andIsEnableEqualTo(Constant.YES_INT).andBillTypeIsNotNull().andBillTypeNotEqualTo("666");
        return this.billItemMapper.selectByExample(billItemExample);
    }

    @Override
    @Cacheable(value={"billItem"}, keyGenerator="redisKeyGenerator")
    public List<BillItem> queryRebateVoucherList(String id) {
        BillItemExample billItemExample = new BillItemExample();
        billItemExample.createCriteria().andBillInvoiceIdEqualTo(id).andIsEnableEqualTo(Constant.YES_INT).andBillTypeEqualTo("666");
        return this.billItemMapper.selectByExample(billItemExample);
    }

    @CacheEvict(value={"billItem"}, allEntries=true)
    public void addObj(BillItem t) {
        this.billItemMapper.insertSelective(t);
    }

    @CacheEvict(value={"billItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.billItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"billItem"}, allEntries=true)
    public void modifyObj(BillItem t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.billItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"billItem"}, keyGenerator="redisKeyGenerator")
    public BillItem queryObjById(String id) {
        return this.billItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"billItem"}, keyGenerator="redisKeyGenerator")
    public List<BillItem> queryAllObjByExample(BillItemExample example) {
        return this.billItemMapper.selectByExample(example);
    }

    @Cacheable(value={"billItem"}, keyGenerator="redisKeyGenerator")
    public PageView<BillItem> queryObjByPage(BillItemExample example) {
        PageView<BillItem> pageView = example.getPageView();
        pageView.setQueryResult(this.billItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"billItem"}, allEntries=true)
    public Bill delete(List<BillItem> data, User loginUser) {
        Assert.isNotEmpty(data, (String)"\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a");
        List ids = data.stream().map(billItem -> billItem.getId()).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andBillNoEqualTo(data.get(0).getBillNo());
        List bills = this.billService.queryAllObjByExample((IExample)billExample);
        Bill bill = (Bill)bills.get(0);
        if (bill.getPurSendStatus().equals(Constant.YES_INT)) {
            throw new CommonException("\u5f53\u524d\u5355\u636e\u5df2\u53d1\u9001\uff0c\u65e0\u6cd5\u5220\u9664SAP\u5bf9\u8d26\u660e\u7ec6");
        }
        BillItemExample example = new BillItemExample();
        example.createCriteria().andIdIn(ids);
        List<BillItem> billItems = this.billItemMapper.selectByExample(example);
        example.clear();
        example.createCriteria().andBillNoEqualTo(billItems.get(0).getBillNo());
        List<BillItem> list = this.billItemMapper.selectByExample(example);
        ArrayList<BillItem> itemsDel = new ArrayList<BillItem>();
        for (BillItem billItem2 : billItems) {
            List items = list.stream().filter(i -> billItem2.getVoucherNo().equals(i.getVoucherNo()) && billItem2.getVoucherProject().equals(i.getVoucherProject())).collect(Collectors.toList());
            itemsDel.addAll(items);
        }
        if (list.size() == 1 || list.size() == itemsDel.size()) {
            throw new CommonException("SAP\u5bf9\u8d26\u660e\u7ec6\u5e94\u81f3\u5c11\u4fdd\u7559\u4e00\u6761\u6570\u636e,\u4e0d\u5141\u8bb8\u6e05\u7a7a!");
        }
        List idList = itemsDel.stream().map(item -> item.getVoucherId()).collect(Collectors.toList());
        BillVoucherExample voucherExample = new BillVoucherExample();
        voucherExample.createCriteria().andIdIn(idList);
        BillVoucher voucher = new BillVoucher();
        voucher.setBillFlag(Constant.NO_INT);
        this.billVoucherService.updateByExampleSelective(voucher, voucherExample);
        List idList2 = itemsDel.stream().map(item -> item.getId()).collect(Collectors.toList());
        example.clear();
        example.createCriteria().andIdIn(idList2);
        BillItem billItem2 = new BillItem();
        billItem2.setIsEnable(Constant.NO_INT);
        billItem2.setBillFlag(Constant.NO_INT);
        this.billItemMapper.updateByExampleSelective(billItem2, example);
        this.calculateTax(bill, itemsDel);
        return bill;
    }

    private void calculateTax(Bill bill, List<BillItem> billItems) {
        BigDecimal notIncludeTaxAmount = bill.getNotIncludeTaxAmount();
        BigDecimal includeTaxAmount = bill.getIncludeTaxAmount();
        BigDecimal taxAmount = bill.getTaxAmount();
        for (BillItem bitem : billItems) {
            notIncludeTaxAmount = notIncludeTaxAmount.subtract(bitem.getNotIncludeTaxAmount());
            includeTaxAmount = includeTaxAmount.subtract(bitem.getIncludeTaxAmount());
            taxAmount = taxAmount.subtract(bitem.getTaxAmount());
        }
        bill.setNotIncludeTaxAmount(notIncludeTaxAmount);
        bill.setIncludeTaxAmount(includeTaxAmount);
        bill.setTaxAmount(taxAmount);
        bill.setTotalAmount(includeTaxAmount);
        this.billService.updateByPrimaryKeySelective(bill);
    }

    @Override
    @CacheEvict(value={"billItem"}, allEntries=true)
    @Transactional
    public int updateByExampleSelective(BillItem record, BillItemExample example) {
        return this.billItemMapper.updateByExampleSelective(record, example);
    }

    @Override
    @CacheEvict(value={"billItem"}, allEntries=true)
    @Transactional
    public void modify(BillItem billItem, User loginUser) {
        BillExample example = new BillExample();
        example.createCriteria().andIdEqualTo(billItem.getBillId());
        List bills = this.billService.queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)bills, (String)"\u672a\u627e\u5230\u7b26\u5408\u8981\u6c42\u7684\u5bf9\u8d26\u5355");
        Bill bill = (Bill)bills.get(0);
        if (BillStatus.YES_WRITEBACK.getCode().equals(bill.getAbolishStatus())) {
            throw new CommonException("\u8be5\u5bf9\u8d26\u5355\u5df2\u56de\u5199,\u4e0d\u5141\u8bb8\u4fee\u6539\u5bf9\u8d26\u660e\u7ec6");
        }
        BillItem item = new BillItem();
        item.setId(billItem.getId());
        item.setIncludeTaxAmount(billItem.getIncludeTaxAmount());
        BigDecimal add = new BigDecimal(1).add(billItem.getTaxRate());
        BigDecimal divide = billItem.getIncludeTaxAmount().divide(add, 2, RoundingMode.HALF_UP);
        item.setNotIncludeTaxAmount(divide);
        item.setTaxAmount(billItem.getIncludeTaxAmount().subtract(divide).setScale(2, 4));
        this.billItemMapper.updateByPrimaryKeySelective(item);
        BillVoucher voucher = new BillVoucher();
        voucher.setId(billItem.getVoucherId());
        voucher.setNotIncludeTaxAmount(item.getNotIncludeTaxAmount());
        voucher.setTaxAmount(item.getTaxAmount());
        voucher.setIncludeTaxAmount(item.getIncludeTaxAmount());
        voucher.setTaxAmount(item.getTaxAmount());
        this.billVoucherService.modifyObj(voucher);
        BillItemExample example2 = new BillItemExample();
        example2.createCriteria().andBillIdEqualTo(bill.getId()).andIsEnableEqualTo(Constant.YES_INT);
        List<BillItem> voucherList = this.billItemMapper.selectByExample(example2);
        CalculateBillUtil.calculateAmountItem(bill, voucherList);
        this.billService.modifyObj(bill);
    }

    @CacheEvict(value={"billItem"}, allEntries=true)
    public void deleteByExample(BillItemExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.billItemMapper.deleteByExample(example);
    }

    @CacheEvict(value={"billItem"}, allEntries=true)
    @Transactional
    public void addAll(List<BillItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.billItemMapper.insertSelective((BillItem)record));
    }
}

