/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.utils;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillItem;
import com.els.base.core.utils.Assert;
import com.els.base.invoice.entity.BillInvoice;
import com.els.base.voucher.entity.BillVoucher;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class CalculateBillUtil {
    public static void calculateAmount(Bill bill, List<BillVoucher> billVoucherList) {
        BigDecimal itemNotIncludeTaxAmount = BigDecimal.ZERO;
        BigDecimal itemIncludeTaxAmount = BigDecimal.ZERO;
        BigDecimal itemTaxAmount = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(billVoucherList)) {
            for (BillVoucher billVoucher : billVoucherList) {
                Assert.isNotNull((Object)billVoucher.getNotIncludeTaxAmount(), (String)"\u5f00\u7968\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                Assert.isNotNull((Object)billVoucher.getIncludeTaxAmount(), (String)"\u5f00\u7968\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                Assert.isNotNull((Object)billVoucher.getTaxAmount(), (String)"\u5f00\u7968\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                Assert.isNotBlank((String)billVoucher.getBillType(), (String)"\u79fb\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                itemNotIncludeTaxAmount = itemNotIncludeTaxAmount.add(billVoucher.getNotIncludeTaxAmount());
                itemIncludeTaxAmount = itemIncludeTaxAmount.add(billVoucher.getIncludeTaxAmount());
                itemTaxAmount = itemTaxAmount.add(billVoucher.getTaxAmount());
            }
        }
        bill.setNotIncludeTaxAmount(itemNotIncludeTaxAmount);
        bill.setIncludeTaxAmount(itemIncludeTaxAmount);
        bill.setTaxAmount(itemTaxAmount);
        bill.setTotalAmount(itemIncludeTaxAmount);
    }

    public static void calculateInvoiceAmount(BillInvoice billInvoice, List<BillItem> billItemVoucherList) {
        BigDecimal itemNotIncludeTaxAmount = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(billItemVoucherList)) {
            for (BillItem billItem : billItemVoucherList) {
                Assert.isNotNull((Object)billItem, (String)"\u5165\u9000\u5e93\u51ed\u8bc1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                Assert.isNotNull((Object)billItem.getNotIncludeTaxAmount(), (String)"\u5f00\u7968\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                Assert.isNotNull((Object)billItem.getIncludeTaxAmount(), (String)"\u5f00\u7968\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                Assert.isNotNull((Object)billItem.getTaxAmount(), (String)"\u5f00\u7968\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                Assert.isNotBlank((String)billItem.getBillType(), (String)"\u79fb\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                itemNotIncludeTaxAmount = itemNotIncludeTaxAmount.add(billItem.getNotIncludeTaxAmount());
            }
        }
        billInvoice.setVoucherTaxAmount(itemNotIncludeTaxAmount);
    }

    public static void calculateAmountItem(Bill bill, List<BillItem> voucherList) {
        BigDecimal itemNotIncludeTaxAmount = BigDecimal.ZERO;
        BigDecimal itemIncludeTaxAmount = BigDecimal.ZERO;
        BigDecimal itemTaxAmount = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(voucherList)) {
            for (BillItem billVoucher : voucherList) {
                Assert.isNotNull((Object)billVoucher.getNotIncludeTaxAmount(), (String)"\u5f00\u7968\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                Assert.isNotNull((Object)billVoucher.getIncludeTaxAmount(), (String)"\u5f00\u7968\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                Assert.isNotNull((Object)billVoucher.getTaxAmount(), (String)"\u5f00\u7968\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                Assert.isNotBlank((String)billVoucher.getBillType(), (String)"\u79fb\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                itemNotIncludeTaxAmount = itemNotIncludeTaxAmount.add(billVoucher.getNotIncludeTaxAmount());
                itemIncludeTaxAmount = itemIncludeTaxAmount.add(billVoucher.getIncludeTaxAmount());
                itemTaxAmount = itemTaxAmount.add(billVoucher.getTaxAmount());
            }
        }
        bill.setNotIncludeTaxAmount(itemNotIncludeTaxAmount);
        bill.setIncludeTaxAmount(itemIncludeTaxAmount);
        bill.setTaxAmount(itemTaxAmount);
        bill.setTotalAmount(itemIncludeTaxAmount);
    }
}

