/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.finance.service.impl;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.bill.service.BillService;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Constant;
import com.els.base.finance.letterSap.ZSRMRFCDZHS01;
import com.els.base.finance.service.LetterSapService;
import com.els.base.finance.service.LetterTimeService;
import com.els.base.letter.entity.Letter;
import com.els.base.letter.entity.LetterExample;
import com.els.base.letter.service.LetterService;
import com.els.base.letter.util.LetterBusinessTypeEnum;
import com.els.base.letter.util.LetterStatus;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.util.BillBusinessTypeEnum;
import com.els.base.utils.uuid.UUIDGenerator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LetterTimeServiceImpl
implements LetterTimeService {
    @Resource
    protected BillService billService;
    @Resource
    protected LetterSapService letterSapService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected LetterService letterService;
    @Resource
    protected CompanyUserRefService companyUserRefService;

    @Override
    @Transactional
    @CacheEvict(value={"letter"}, allEntries=true)
    public void createLetter() throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.set(5, 0);
        String endTime = DateFormatUtils.format((Date)cale.getTime(), (String)"yyyy-MM-dd");
        Date endDate = format.parse(endTime);
        BillExample example = new BillExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andAbolishStatusNotEqualTo(Constant.YES_INT);
        List bills = this.billService.queryAllObjByExample((IExample)example);
        Map map = bills.stream().collect(Collectors.groupingBy(o -> o.getSupCompanySapCode() + o.getCompanyCode(), Collectors.toList()));
        ArrayList<Letter> letters = new ArrayList<Letter>();
        String timeWork = "1";
        for (String key : map.keySet()) {
            String date;
            Bill bill = (Bill)map.get(key).get(0);
            String sapCode = bill.getSupCompanySapCode();
            String companyCode = bill.getCompanyCode();
            String companyName = bill.getCompanyName();
            Letter letter = new Letter();
            letter.setCompanyName(companyName);
            letter.setSupCompanySapCode(sapCode);
            letter.setCompanyCode(companyCode);
            letter.setEndTime(endDate);
            LetterExample example2 = new LetterExample();
            example2.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andSupCompanySapCodeEqualTo(sapCode).andCompanyCodeEqualTo(companyCode).andEndTimeEqualTo(letter.getEndTime());
            List list = this.letterService.queryAllObjByExample((IExample)example2);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                date = "\u4f9b\u5e94\u5546sap:" + sapCode + ",\u516c\u53f8:" + companyCode + "\u622a\u6b62\u65e5\u671f\uff1a" + DateFormatUtils.format((Date)endDate, (String)"yyyy-MM-dd") + "\u751f\u6210\u5bf9\u8d26\u51fd\u5931\u8d25:\u6682\u65f6\u8fd8\u6ca1\u6709\u9700\u8981\u751f\u6210\u5bf9\u8d26\u51fd\u7684\u51fd\u636e\uff01";
                this.sendMessagesToPur(date, BillBusinessTypeEnum.BILL_FALSE_RESAON.getCode());
            }
            if ((letter = this.initLetter(letter, sapCode, companyCode, endTime, timeWork)) == null) {
                date = "\u4f9b\u5e94\u5546sap:" + sapCode + ",\u516c\u53f8:" + companyCode + "\u622a\u6b62\u65e5\u671f\uff1a" + DateFormatUtils.format((Date)endDate, (String)"yyyy-MM-dd") + "\u751f\u6210\u5bf9\u8d26\u51fd\u5931\u8d25:\u6682\u65f6\u8fd8\u6ca1\u6709\u9700\u8981\u751f\u6210\u5bf9\u8d26\u51fd\u7684\u51fd\u636e\uff01";
                this.sendMessagesToPur(date, BillBusinessTypeEnum.BILL_FALSE_RESAON.getCode());
                continue;
            }
            letters.add(letter);
        }
        this.letterService.addAll(letters);
        for (Letter letter : letters) {
            this.sendMessagesToSup(letter, LetterBusinessTypeEnum.LETTER_SEND.getCode());
        }
    }

    protected void sendMessagesToPur(String date, String businessType) {
        Message message = Message.init((Object)date).setBusinessTypeCode(businessType).setCompanyCode("51000000").setMsgLevel(MessageLevelEnum.HIGH).addReceiverId("20180704105632-e13655014dce400b9");
        MessageSendUtils.sendMessage((Message)message);
    }

    private void sendMessagesToSup(Letter data, String code) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getSupCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(code).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId("1").addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    private Letter initLetter(Letter letter, String sapCode, String companyCode, String endTime, String timeWork) {
        ZSRMRFCDZHS01 zsrmrfcdzhs01 = this.letterSapService.importBySap(sapCode, companyCode, endTime, timeWork);
        if (zsrmrfcdzhs01 == null) {
            return null;
        }
        this.completeInfo(sapCode, letter, zsrmrfcdzhs01);
        return letter;
    }

    private void completeInfo(String sapCode, Letter letter, ZSRMRFCDZHS01 zsrmrfcdzhs01) {
        this.completePurAndSup(letter);
        this.completeLetter(letter, zsrmrfcdzhs01);
    }

    private void completeLetter(Letter letter, ZSRMRFCDZHS01 zsrmrfcdzhs01) {
        letter.setId(UUIDGenerator.generateUUID());
        String code = this.generateCodeService.getNextCode("LETTER_NO");
        letter.setLetterNo(code);
        letter.setIsEnable(Constant.YES_INT);
        letter.setCreateTime(new Date());
        letter.setCreateUser("\u8d85\u7ea7\u7ba1\u7406\u5458");
        letter.setCreateUserId("1");
        letter.setPayAmount(zsrmrfcdzhs01.getZYFKX());
        letter.setReceiveAmount(zsrmrfcdzhs01.getZYSKX());
        letter.setBailAmount(zsrmrfcdzhs01.getBZJYE());
        letter.setSpareField2(zsrmrfcdzhs01.getWAERS());
        letter.setConfirmStatus(LetterStatus.NO_CONFIRM.getCode());
        letter.setSendStatus(Constant.YES_INT);
    }

    private void completePurAndSup(Letter letter) {
        Company company = this.companyService.queryCompanyByCode("51000000");
        letter.setPurCompanyFullName(company.getCompanyFullName());
        letter.setPurCompanyId(company.getId());
        letter.setPurCompanyName(company.getCompanyName());
        letter.setPurCompanySapCode(company.getCompanySapCode());
        letter.setPurCompanySrmCode(company.getCompanyCode());
        Company supCompany = this.companyService.queryCompanyBySapCode(letter.getSupCompanySapCode());
        letter.setSupCompanyFullName(supCompany.getCompanyFullName());
        letter.setSupCompanyId(supCompany.getId());
        letter.setSupCompanyName(supCompany.getCompanyName());
        letter.setSupCompanySrmCode(supCompany.getCompanyCode());
    }
}

