/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.letter.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.bill.service.BillService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.finance.service.LetterTimeService;
import com.els.base.letter.entity.Letter;
import com.els.base.letter.entity.LetterExample;
import com.els.base.letter.service.LetterService;
import com.els.base.letter.util.LetterStatus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u5bf9\u8d26\u51fd")
@Controller
@RequestMapping(value={"letter"})
public class LetterController {
    @Resource
    protected LetterService letterService;
    @Resource
    protected LetterTimeService letterTimeService;
    @Resource
    protected BillService billService;
    @Value(value="${delivery.order.print.font.path}")
    protected String fontPathStr;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u5bf9\u8d26\u51fd")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Letter letter) {
        this.letterService.createLetter(letter, SpringSecurityUtils.getLoginUser(), CompanyUtils.currentCompany());
        return ResponseResult.success((Object)letter.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u5bf9\u8d26\u51fd(\u5b9a\u65f6\u4efb\u52a1\u8c03\u7528)")
    @RequestMapping(value={"service/stackcreate"})
    @ResponseBody
    public ResponseResult<String> stackcreate() throws ParseException {
        this.letterTimeService.createLetter();
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u5bf9\u8d26\u51fd")
    @RequestMapping(value={"service/modify"})
    @ResponseBody
    public ResponseResult<String> modify(@RequestBody List<Letter> letters) {
        Assert.isNotEmpty(letters, (String)"\u6570\u636e\u4e3a\u7a7a,\u4fdd\u5b58\u5931\u8d25\uff01");
        List list2 = letters.stream().map(i -> i.getId()).collect(Collectors.toList());
        LetterExample example = new LetterExample();
        example.createCriteria().andIdIn(list2);
        List lets = this.letterService.queryAllObjByExample((IExample)example);
        List list = lets.stream().filter(i -> LetterStatus.SUP_CONFIRM.equals(i.getConfirmStatus()) || LetterStatus.PUR_BACK.equals(i.getConfirmStatus())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list)) {
            throw new CommonException("\u5bf9\u8d26\u51fd\u5df2\u786e\u8ba4\u4e0d\u5141\u8bb8\u4fee\u6539,\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        for (Letter letter : letters) {
            Assert.isNotBlank((String)letter.getId(), (String)"id\u4e3a\u7a7a,\u4fdd\u5b58\u5931\u8d25\uff01");
            this.letterService.modify(letter, SpringSecurityUtils.getLoginUser());
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u5bf9\u8d26\u51fd")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.letterService.deleteByIds(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u786e\u8ba4\u5bf9\u8d26\u51fd")
    @RequestMapping(value={"service/confirmBySup"})
    @ResponseBody
    public ResponseResult<String> confirmBySup(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.letterService.confirmBySup(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u786e\u8ba4\u5bf9\u8d26\u51fd")
    @RequestMapping(value={"service/confirmByPur"})
    @ResponseBody
    public ResponseResult<String> confirmByPur(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.letterService.confirmByPur(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u9000\u56de\u5bf9\u8d26\u51fd")
    @RequestMapping(value={"service/backByPur"})
    @ResponseBody
    public ResponseResult<String> backByPur(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.letterService.backByPur(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5bf9\u8d26\u6db5\u6253\u5370")
    @RequestMapping(value={"service/print"})
    @ResponseBody
    public ResponseResult<FileData> print(@ApiParam(value="id\u5217\u8868") @RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"id\u5217\u8868\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25\uff01");
        Assert.isNotBlank((String)this.fontPathStr, (String)"\u6253\u5370\u7684\u5b57\u4f53\u8fd8\u6ca1\u6709\u8bbe\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        FileData fileData = this.letterService.print(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(), ids, this.fontPathStr);
        return ResponseResult.success((Object)fileData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5bf9\u8d26\u51fd")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Letter", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForPur"})
    @ResponseBody
    public ResponseResult<PageView<Letter>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper, @RequestParam(required=false) String id) {
        LetterExample example = new LetterExample();
        example.setPageView((PageView<Letter>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        LetterExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (StringUtils.isEmpty((String)id)) {
            criteria.andConfirmStatusNotEqualTo(LetterStatus.PUR_CONFIRM.getCode());
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.letterService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5bf9\u8d26\u51fd")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Letter", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForSup"})
    @ResponseBody
    public ResponseResult<PageView<Letter>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper, @RequestParam(required=false) String id) {
        LetterExample example = new LetterExample();
        example.setPageView((PageView<Letter>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        LetterExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (StringUtils.isEmpty((String)id)) {
            criteria.andConfirmStatusNotEqualTo(LetterStatus.PUR_CONFIRM.getCode());
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.letterService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u5f00\u7968\u6e05\u5355\u5934\u6570\u636e-\u91c7\u8d2d\u5458\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Bill", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/bill/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Bill>> findForPurByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BillExample example = new BillExample();
        example.setPageView((PageView<Bill>)new PageView(pageNo, pageSize));
        BillExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andAbolishStatusNotEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView<Bill> pageData = this.billService.findByPageForDistinct(example);
        return ResponseResult.success(pageData);
    }

    private List<Bill> complet(List<Bill> bills) {
        ArrayList<Bill> bs = new ArrayList<Bill>();
        Map map = bills.stream().collect(Collectors.groupingBy(o -> o.getSupCompanySapCode() + o.getCompanyCode(), Collectors.toList()));
        for (String key : map.keySet()) {
            Bill bill = (Bill)map.get(key).get(0);
            bs.add(bill);
        }
        return bs;
    }
}

