/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.letter.util;

import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.letter.entity.Letter;
import com.els.base.utils.pdf.HtmlToPdfParam;
import com.els.base.utils.pdf.HtmlToPdfUtils;
import com.els.base.utils.template.BeetlTemplateUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LetterPrintUtils {
    private static final Logger log = LoggerFactory.getLogger(LetterPrintUtils.class);

    public static FileData generatePdf(String projectId, String companyId, Map<String, Object> params, String printType, Letter letter) throws Exception {
        String html = BeetlTemplateUtils.renderFromFile((String)"templateLetter.html", params);
        log.info(html);
        String filename = String.format("%s%s%s", letter.getCompanyCode(), letter.getSupCompanyFullName(), DateFormatUtils.format((Date)letter.getEndTime(), (String)"yyyy-MM-dd"));
        FileData pdfFile = LetterPrintUtils.createEmptyPDF(projectId, companyId, filename);
        HtmlToPdfParam param = new HtmlToPdfParam();
        param.setTitle(filename);
        param.setPageSize("A4");
        param.setVertical(true);
        HtmlToPdfUtils.generatePdf((String)html, (File)pdfFile.toFile(), (HtmlToPdfParam)param);
        return pdfFile;
    }

    private static FileData createEmptyPDF(String projectId, String companyId, String fileName) throws IOException {
        FileData pdfFile = new FileData();
        pdfFile.setProjectId(projectId);
        pdfFile.setCompanyId(companyId);
        pdfFile.setFileName(fileName + ".pdf");
        pdfFile.setFileSuffix("pdf");
        pdfFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
        pdfFile.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
        pdfFile = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), pdfFile);
        return pdfFile;
    }
}

