/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purVoucher.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.purVoucher.dao.BillPurVoucherMapper;
import com.els.base.purVoucher.entity.BillPurVoucher;
import com.els.base.purVoucher.entity.BillPurVoucherExample;
import com.els.base.purVoucher.service.BillPurVoucherService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBillPurVoucherService")
public class BillPurVoucherServiceImpl
implements BillPurVoucherService {
    @Resource
    protected BillPurVoucherMapper billPurVoucherMapper;

    @CacheEvict(value={"billPurVoucher"}, allEntries=true)
    public void addObj(BillPurVoucher t) {
        this.billPurVoucherMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"billPurVoucher"}, allEntries=true)
    public void addAll(List<BillPurVoucher> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.billPurVoucherMapper.insertBatch(list);
    }

    @CacheEvict(value={"billPurVoucher"}, allEntries=true)
    public void deleteObjById(String id) {
        this.billPurVoucherMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"billPurVoucher"}, allEntries=true)
    public void deleteByExample(BillPurVoucherExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.billPurVoucherMapper.deleteByExample(example);
    }

    @CacheEvict(value={"billPurVoucher"}, allEntries=true)
    public void modifyObj(BillPurVoucher t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.billPurVoucherMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"billPurVoucher"}, keyGenerator="redisKeyGenerator")
    public BillPurVoucher queryObjById(String id) {
        return this.billPurVoucherMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"billPurVoucher"}, keyGenerator="redisKeyGenerator")
    public List<BillPurVoucher> queryAllObjByExample(BillPurVoucherExample example) {
        return this.billPurVoucherMapper.selectByExample(example);
    }

    @Cacheable(value={"billPurVoucher"}, keyGenerator="redisKeyGenerator")
    public PageView<BillPurVoucher> queryObjByPage(BillPurVoucherExample example) {
        PageView<BillPurVoucher> pageView = example.getPageView();
        pageView.setQueryResult(this.billPurVoucherMapper.selectByExampleByPage(example));
        return pageView;
    }
}

