/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.conditions.service.impl;

import com.els.base.conditions.dao.ConditionsMapper;
import com.els.base.conditions.entity.Conditions;
import com.els.base.conditions.entity.ConditionsExample;
import com.els.base.conditions.service.ConditionsService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultConditionsService")
public class ConditionsServiceImpl
implements ConditionsService {
    @Resource
    protected ConditionsMapper conditionsMapper;

    @CacheEvict(value={"conditions"}, allEntries=true)
    public void addObj(Conditions t) {
        this.conditionsMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"conditions"}, allEntries=true)
    public void addAll(List<Conditions> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.conditionsMapper.insertBatch(list);
    }

    @CacheEvict(value={"conditions"}, allEntries=true)
    public void deleteObjById(String id) {
        this.conditionsMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"conditions"}, allEntries=true)
    public void deleteByExample(ConditionsExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.conditionsMapper.deleteByExample(example);
    }

    @CacheEvict(value={"conditions"}, allEntries=true)
    public void modifyObj(Conditions t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.conditionsMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"conditions"}, keyGenerator="redisKeyGenerator")
    public Conditions queryObjById(String id) {
        return this.conditionsMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"conditions"}, keyGenerator="redisKeyGenerator")
    public List<Conditions> queryAllObjByExample(ConditionsExample example) {
        return this.conditionsMapper.selectByExample(example);
    }

    @Cacheable(value={"conditions"}, keyGenerator="redisKeyGenerator")
    public PageView<Conditions> queryObjByPage(ConditionsExample example) {
        PageView<Conditions> pageView = example.getPageView();
        pageView.setQueryResult(this.conditionsMapper.selectByExampleByPage(example));
        return pageView;
    }
}

