/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.bill.entity.BillItem;
import com.els.base.bill.service.BillItemService;
import com.els.base.bill.service.BillService;
import com.els.base.bill.service.BillTimeTaskService;
import com.els.base.bill.utils.BillStatus;
import com.els.base.bill.vo.BillInvoiceExportExcelVo;
import com.els.base.bill.vo.BillVo;
import com.els.base.common.ExcelFileData;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.project.ProjectService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParam;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.finance.service.SapBillService;
import com.els.base.invoice.entity.BillInvoice;
import com.els.base.invoice.entity.BillInvoiceExample;
import com.els.base.invoice.service.BillInvoiceService;
import com.els.base.purchase.service.PurOrderItemExtService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.json.JsonUtils;
import com.els.liby.invetory.entity.SupInvetoryDetailExample;
import com.els.liby.invetory.service.SupInvetoryDetailService;
import com.els.liby.organization.service.OrganizationService;
import com.els.liby.organization.utils.UserOrganizationUtils;
import com.google.gson.Gson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u5f00\u7968\u6e05\u5355\u6570\u636e"})
@Controller
@RequestMapping(value={"bill"})
public class BillController {
    private static Logger log = LoggerFactory.getLogger(BillController.class);
    private static Gson json = new Gson();
    @Resource
    private BillService billService;
    @Resource
    private BillItemService billItemService;
    @Resource
    private CompanyPurRefService companyPurRefService;
    @Resource
    private BillInvoiceService billInvoiceService;
    @Resource
    private SapBillService sapBillService;
    @Resource
    private CompanyService companyService;
    @Resource
    private ProjectService projectService;
    @Resource
    private PurOrderItemExtService purOrderItemExtService;
    @Resource
    private SupInvetoryDetailService supInvetoryDetailService;
    @Resource
    private BillTimeTaskService billTimeTaskService;
    @Resource
    private OrganizationService organizationService;
    @Value(value="${delivery.order.print.font.path}")
    protected String fontPathStr;

    @ApiOperation(value="\u8d22\u52a1\u53d1\u7968-\u56de\u5199SAP", httpMethod="POST")
    @RequestMapping(value={"service/backSAP"})
    @ResponseBody
    public ResponseResult<String> backSAP(@RequestBody List<Bill> bills) {
        Assert.isNotEmpty(bills, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> billIds = bills.stream().map(bill -> bill.getId()).collect(Collectors.toList());
        this.sapBillService.writeBackSapBill(billIds, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(value="\u9001\u8d27\u901a\u77e5\u5355-\u56de\u5199SAP", httpMethod="POST")
    @RequestMapping(value={"service/goodsbackSAP"})
    @ResponseBody
    public ResponseResult<String> goodsbackSAP() {
        this.sapBillService.writeBackGoods();
        return ResponseResult.success();
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u5e93\u5b58\u53ca\u751f\u4ea7\u8ba1\u5212-\u56de\u5199SAP", httpMethod="POST")
    @RequestMapping(value={"service/invetoryBackSap"})
    @ResponseBody
    public ResponseResult<String> invetoryBackSap() {
        SupInvetoryDetailExample example = new SupInvetoryDetailExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andIsLastestStateEqualTo(Constant.YES_INT).andRecordStatusEqualTo(Constant.YES_INT);
        List invetoryDetails = this.supInvetoryDetailService.queryAllObjByExample((IExample)example);
        this.sapBillService.invetoryBackSap(invetoryDetails);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5bf9\u8d26\u5355\u6253\u5370")
    @RequestMapping(value={"service/print"})
    @ResponseBody
    public ResponseResult<FileData> print(@ApiParam(value="\u5bf9\u8d26\u5355id\u5217\u8868") @RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u9884\u4ed8\u6b3e\u5355id\u5217\u8868\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25\uff01");
        Assert.isNotBlank((String)this.fontPathStr, (String)"\u6253\u5370\u7684\u5b57\u4f53\u8fd8\u6ca1\u6709\u8bbe\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        log.info("\u5b57\u4f53\u4e3a[{}]", (Object)this.fontPathStr);
        FileData fileData = this.billService.print(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(), ids, this.fontPathStr);
        return ResponseResult.success((Object)fileData);
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u5bf9\u8d26\u5355(\u91c7\u8d2d\u5546\u5907\u6ce8)")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody List<Bill> data) {
        if (CollectionUtils.isEmpty(data)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        for (Bill bill : data) {
            Assert.isNotBlank((String)bill.getId(), (String)"id \u4e3a\u7a7a,\u4fdd\u5b58\u5931\u8d25");
            Assert.isNotBlank((String)bill.getPayConditionsCode(), (String)"\u4ed8\u6b3e\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            this.billService.modifyRemark(bill);
        }
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5bfc\u51fa\u5bf9\u8d26\u6e05\u5355\u6570\u636e(\u91c7\u8d2d\u65b9)", httpMethod="POST")
    @RequestMapping(value={"service/pur/exportBill"})
    @ResponseBody
    public ResponseResult<FileData> purExportBill(@RequestBody(required=false) QueryParamWapper wapper, String queryParams) throws IOException, WriteException, ParseException {
        BillExample example = new BillExample();
        BillExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotEmpty((String)queryParams)) {
            QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParamWapper);
        }
        criteria.andIsEnableEqualTo(Constant.YES_INT).andPurCompanyIdEqualTo(ProjectUtils.getCompanyId());
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        List billList = this.billService.queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)billList, (String)"\u5bfc\u51fa\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        List<String> idList = billList.stream().map(Bill::getId).collect(Collectors.toList());
        List<BillItem> billItems = this.billItemService.queryBillVoucherList(idList);
        for (BillItem billItem : billItems) {
            List list = billList.stream().filter(i -> billItem.getBillId().equals(i.getId())).collect(Collectors.toList());
            Bill bill = (Bill)list.get(0);
            billItem.setId(bill.getPurUserName());
            billItem.setPurCompanyId(bill.getCompanyName());
            billItem.setSupCompanyId(bill.getPayConditionsDesc());
            billItem.setInputDate(bill.getCreateTime());
            billItem.setSpareDate(bill.getPostingEndTime());
            billItem.setVoucherTime(bill.getPostingStartTime());
        }
        Assert.isNotEmpty(billItems, (String)"\u5bfc\u51fa\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeaderColumnDown();
        FileData fileData = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, billItems, "\u5f00\u7968\u6e05\u5355\u884c", "\u5f00\u7968\u6e05\u5355\u884c", 0);
        return ResponseResult.success((Object)fileData);
    }

    private List<TitleAndModelKey> createExcelHeaderColumnDown() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u516c\u53f8\u540d\u79f0", (String)"purCompanyId"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7b80\u79f0", (String)"supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u8ba2\u5355\u53f7", (String)"purchaseOrderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u884c\u9879", (String)"purchaseOrderItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u534f\u8bae\u53f7", (String)"agreementNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u534f\u8bae\u65e5\u671f", (String)"agreementDate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u534f\u8bae\u884c\u53f7", (String)"agreementItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u53c2\u8003\u51ed\u8bc1\u53f7", (String)"voucherNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u53c2\u8003\u51ed\u8bc1\u884c\u53f7", (String)"voucherProject"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u51ed\u8bc1\u53f7", (String)"materialVoucherNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u51ed\u8bc1\u884c\u53f7", (String)"materialVoucherItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8fc7\u8d26\u65e5\u671f", (String)"postingTime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u65e5\u671f", (String)"inputTime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u542b\u7a0e\u5355\u4ef7", (String)"orderPrice"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ef7\u683c\u5355\u4f4d", (String)"priceEntity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e01\u79cd", (String)"currencyType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7a0e\u7387", (String)"taxRate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6570\u91cf", (String)"materialQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u79fb\u52a8\u7c7b\u578b", (String)"billType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7b26\u53f7", (String)"mark"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u7968\u672a\u7a0e\u91d1\u989d", (String)"notIncludeTaxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u7968\u7a0e\u989d", (String)"taxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u7968\u542b\u7a0e\u91d1\u989d", (String)"includeTaxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u4e2a\u542b\u7a0e\u5355\u4ef7", (String)"latestPrice"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5de5\u5382", (String)"factory"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e93\u5b58\u5730\u70b9", (String)"stockSpaceRemark"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u5355\u4f4d", (String)"materialUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d27\u7269\u548c\u52b3\u52a1\u540d\u79f0", (String)"goodsandlaborName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5408\u5e76\u7a0e\u52a1\u7f16\u7801", (String)"combinedTaxCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u53f7", (String)"billNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5236\u5355\u4eba", (String)"id"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ed8\u6b3e\u6761\u4ef6", (String)"supCompanyId"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5236\u5355\u65f6\u95f4", (String)"inputDate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u51ed\u8bc1\u5f00\u59cb\u65e5\u671f", (String)"voucherTime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u51ed\u8bc1\u7ed3\u675f\u65e5\u671f", (String)"spareDate"));
        return titleAndModelKeys;
    }

    @ApiOperation(value="\u751f\u6210\u53d1\u7968\u6a21\u677f", httpMethod="GET")
    @RequestMapping(value={"service/invoiceTemplet"})
    @ResponseBody
    public ModelAndView invoiceTemplet(@RequestParam(required=true) String id, HttpServletResponse response) throws IOException, RowsExceededException, WriteException, ParseException {
        Assert.isNotBlank((String)id, (String)"\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a");
        List<TitleAndModelKey> titleAndModelKeys = this.invoiceCreateExportExcelHeader();
        List<BillInvoiceExportExcelVo> vos = this.billService.getInvoiceList(id);
        int i = 0;
        for (BillInvoiceExportExcelVo vo : vos) {
            vo.setNo(++i);
        }
        response.reset();
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode("\u53d1\u7968\u6a21\u677f.xls", "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/vnd.ms-excel");
        ServletOutputStream outputStream = response.getOutputStream();
        WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, vos, (String)"SAP\u5bf9\u8d26\u660e\u7ec6", null, (int)0);
        writableWorkbook.write();
        outputStream.flush();
        writableWorkbook.close();
        outputStream.close();
        return null;
    }

    private List<TitleAndModelKey> invoiceCreateExportExcelHeader() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e8f\u53f7", (String)"no"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d27\u7269\u6216\u5e94\u7a0e\u52b3\u52a1\u3001\u670d\u52a1\u540d\u79f0", (String)"goodsandlaborName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"materialUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u89c4\u683c\u578b\u53f7", (String)"materialDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6570\u91cf", (String)"materialQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91d1\u989d", (String)"includeTaxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7a0e\u7387", (String)"taxRate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5546\u54c1\u7a0e\u76ee", (String)"productTax"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6298\u6263\u91d1\u989d", (String)"deductionAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7a0e\u989d", (String)"taxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6298\u6263\u7a0e\u989d", (String)"deductionTaxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6298\u6263\u7387", (String)"decutionRate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u4ef7", (String)"price"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ef7\u683c\u65b9\u5f0f", (String)"priceMode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u7248\u672c\u53f7", (String)"taxCodeVersion"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", (String)"taxCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f01\u4e1a\u5546\u54c1\u7f16\u7801", (String)"productCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f7f\u7528\u4f18\u60e0\u653f\u7b56\u6807\u8bc6", (String)"remark"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u96f6\u7a0e\u7387\u6807\u8bc6", (String)"taxRemark"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f18\u60e0\u653f\u7b56\u8bf4\u660e", (String)"information"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e2d\u5916\u5408\u4f5c\u6cb9\u6c14\u7530\u6807\u8bc6", (String)"gasRemark"));
        return titleAndModelKeys;
    }

    @ApiOperation(value="\u5bfc\u51fa\u5bf9\u8d26\u6e05\u5355\u6570\u636e(\u4f9b\u5e94\u5546\u65b9)", httpMethod="POST")
    @RequestMapping(value={"service/sup/exportBill"})
    @ResponseBody
    public ResponseResult<FileData> supExportBill(@RequestBody(required=false) QueryParamWapper wapper, String queryParams) throws IOException, WriteException, ParseException {
        BillExample example = new BillExample();
        BillExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotEmpty((String)queryParams)) {
            QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParamWapper);
        }
        criteria.andIsEnableEqualTo(Constant.YES_INT).andPurSendStatusEqualTo(Constant.YES_INT).andSupCompanyIdEqualTo(CompanyUtils.currentCompany().getId());
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        List billList = this.billService.queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)billList, (String)"\u5bfc\u51fa\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        List<String> idList = billList.stream().map(Bill::getId).collect(Collectors.toList());
        List<BillItem> billItems = this.billItemService.queryBillVoucherList(idList);
        for (BillItem billItem : billItems) {
            List list = billList.stream().filter(i -> billItem.getBillId().equals(i.getId())).collect(Collectors.toList());
            Bill bill = (Bill)list.get(0);
            billItem.setId(bill.getPurUserName());
            billItem.setPurCompanyId(bill.getCompanyName());
            billItem.setSupCompanyId(bill.getPayConditionsDesc());
            billItem.setInputDate(bill.getCreateTime());
            billItem.setSpareDate(bill.getPostingEndTime());
            billItem.setVoucherTime(bill.getPostingStartTime());
        }
        Assert.isNotEmpty(billItems, (String)"\u5bfc\u51fa\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeaderColumnDown();
        FileData fileData = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, billItems, "\u5f00\u7968\u6e05\u5355\u884c", "\u5f00\u7968\u6e05\u5355\u884c", 0);
        return ResponseResult.success((Object)fileData);
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u91c7\u8d2d\u5458\u521b\u5efa\u5f00\u7968\u6e05\u5355\u9884\u89c8\u6570\u636e")
    @RequestMapping(value={"service/pur/prepare"})
    @ResponseBody
    public ResponseResult<Bill> prepareForPur(@RequestBody Bill bill) throws ParseException {
        this.billService.prepareFilter(bill);
        Bill newBill = this.billService.prepareForPur(ProjectUtils.getProject(), SpringSecurityUtils.getLoginUser(), CompanyUtils.currentCompany(), bill.getCompanyCode(), bill.getSupCompanySapCode(), bill.getPostingStartTime(), bill.getPostingEndTime());
        return ResponseResult.success((Object)newBill);
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u521b\u5efa\u5f00\u7968\u6e05\u5355\u6570\u636e")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BillVo bill) {
        this.billService.createBill(ProjectUtils.getProject(), SpringSecurityUtils.getLoginUser(), CompanyUtils.currentCompany(), bill);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u6279\u91cf\u5220\u9664\u5f00\u7968\u6e05\u5355")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<Bill> billList) {
        Assert.isNotEmpty(billList, (String)"\u64cd\u4f5c\u5931\u8d25,ids\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        this.billService.deleteObjByIds(ProjectUtils.getProject(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), billList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u67e5\u8be2\u91c7\u8d2d\u5f00\u7968\u6e05\u5355\u8be6\u60c5")
    @RequestMapping(value={"service/findDetailById"})
    @ResponseBody
    public ResponseResult<Bill> findDetailById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u64cd\u4f5c\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        Bill bill = (Bill)this.billService.queryObjById(id);
        return ResponseResult.success((Object)bill);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u91c7\u8d2d\u5458\u53d1\u9001\u5f00\u7968\u6e05\u5355\u7ed9\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/pur/send"})
    @ResponseBody
    public ResponseResult<String> sendForPur(@RequestBody(required=true) List<Bill> billList) {
        Assert.isNotEmpty(billList, (String)"\u64cd\u4f5c\u5931\u8d25,ids\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        this.billService.sendForPur(ProjectUtils.getProject(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), billList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u4f9b\u5e94\u5546\u786e\u8ba4\u5355\u636e")
    @RequestMapping(value={"service/sup/confirm"})
    @ResponseBody
    public ResponseResult<String> confirmForSup(@RequestBody(required=true) List<Bill> billList) {
        Assert.isNotEmpty(billList, (String)"\u64cd\u4f5c\u5931\u8d25,ids\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        this.billService.confirmForSup(ProjectUtils.getProject(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), billList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u4f9b\u5e94\u5546\u56de\u7b7e\uff0c\u786e\u8ba4\u53d1\u7968\u6ca1\u6709\u95ee\u9898")
    @RequestMapping(value={"service/sup/sign"})
    @ResponseBody
    public ResponseResult<String> signForSup(@RequestBody(required=true) List<Bill> billList) {
        Assert.isNotEmpty(billList, (String)"\u64cd\u4f5c\u5931\u8d25,ids\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        this.billService.signForSup(ProjectUtils.getProject(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), billList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u91c7\u8d2d\u5458\u786e\u8ba4\u5355\u636e\u53d1\u7968\u6ca1\u6709\u95ee\u9898")
    @RequestMapping(value={"service/pur/sign"})
    @ResponseBody
    public ResponseResult<String> signForPur(@RequestBody(required=true) List<Bill> billList) {
        Assert.isNotEmpty(billList, (String)"\u64cd\u4f5c\u5931\u8d25,ids\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        this.billService.signForPur(ProjectUtils.getProject(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), billList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u4f9b\u5e94\u5546\u62d2\u7edd\u5355\u636e")
    @RequestMapping(value={"service/sup/reject"})
    @ResponseBody
    public ResponseResult<String> rejectForSup(@RequestBody(required=true) List<Bill> billList) {
        Assert.isNotEmpty(billList, (String)"\u64cd\u4f5c\u5931\u8d25,ids\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        this.billService.rejectForSup(ProjectUtils.getProject(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), billList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u91c7\u8d2d\u5458\u4f5c\u5e9f\u5355\u636e")
    @RequestMapping(value={"service/pur/abolish"})
    @ResponseBody
    public ResponseResult<String> abolishForPur(@RequestBody(required=true) List<Bill> billList) {
        Assert.isNotEmpty(billList, (String)"\u64cd\u4f5c\u5931\u8d25,ids\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        this.billService.abolishForPur(ProjectUtils.getProject(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), billList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u91c7\u8d2d\u5458\u9000\u56de\u53d1\u7968")
    @RequestMapping(value={"service/rejectInvoice"})
    @ResponseBody
    public ResponseResult<String> rejectInvoice(@RequestBody(required=true) List<Bill> billList) {
        Assert.isNotEmpty(billList, (String)"\u64cd\u4f5c\u5931\u8d25,ids\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        this.billService.rejectInvoice(ProjectUtils.getProject(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), billList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u5f00\u7968\u6e05\u5355\u5934\u6570\u636e-\u4f9b\u5e94\u5546\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Bill", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Bill>> findForSupByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper, @RequestParam(required=false) String id) {
        String companyCode = CompanyUtils.currentCompany().getCompanySapCode();
        log.info(String.format("EVNET=\u67e5\u8be2\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u5f00\u7968\u6e05\u5355\u5934\u6570\u636e-\u4f9b\u5e94\u5546\u67e5\u8be2|QUERY_PARAMS=%s|COMPANYCODE=%s", json.toJson((Object)wapper), companyCode));
        BillExample example = new BillExample();
        example.setPageView((PageView<Bill>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        BillExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andPurSendStatusEqualTo(Constant.YES_INT).andSupCompanyIdEqualTo(CompanyUtils.currentCompany().getId());
        if (StringUtils.isEmpty((String)id)) {
            criteria.andAbolishStatusEqualTo(BillStatus.NO_WRITEBACK.getCode());
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.billService.queryObjByPage((IExample)example);
        List<Bill> billList = this.getBillList(pageData.getQueryResult());
        pageData.setQueryResult(billList);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u5f00\u7968\u6e05\u5355\u5934\u6570\u636e-\u91c7\u8d2d\u5458\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Bill", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Bill>> findForPurByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper, @RequestParam(required=false) String id) {
        BillExample example = new BillExample();
        example.setPageView((PageView<Bill>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        BillExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andPurCompanyIdEqualTo(ProjectUtils.getCompanyId());
        List list = UserOrganizationUtils.getUserCompanyCode((String)SpringSecurityUtils.getLoginUserId());
        if (!CollectionUtils.isNotEmpty((Collection)list)) {
            return ResponseResult.success((Object)new PageView());
        }
        criteria.andCompanyCodeIn(list);
        if (StringUtils.isEmpty((String)id)) {
            criteria.andAbolishStatusEqualTo(BillStatus.NO_WRITEBACK.getCode());
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.billService.queryObjByPage((IExample)example);
        List<Bill> billList = this.getBillList(pageData.getQueryResult());
        pageData.setQueryResult(billList);
        return ResponseResult.success((Object)pageData);
    }

    private List<Bill> getBillList(List<Bill> billList) {
        ArrayList<Bill> billTempList = new ArrayList<Bill>();
        if (CollectionUtils.isEmpty(billList)) {
            return billTempList;
        }
        for (Bill bill : billList) {
            List<BillInvoice> billInvoiceList = this.billInvoiceService.queryByBillId(bill.getId());
            bill.setInvoiceList(billInvoiceList);
            billTempList.add(bill);
        }
        return billTempList;
    }

    @ApiOperation(httpMethod="GET", value="\u5bfc\u51fa\u53d1\u7968\u4fe1\u606f")
    @RequestMapping(value={"service/exportBillInvoiceDetail"})
    @ResponseBody
    public ModelAndView exportSapBillDetail(@RequestParam(required=true) String id, HttpServletResponse response) throws Exception {
        List<TitleAndModelKey> titleAndModelKeys = this.createExportExcelHeader();
        BillInvoiceExample example = new BillInvoiceExample();
        example.createCriteria().andBillIdEqualTo(id);
        List billInvoices = this.billInvoiceService.queryAllObjByExample((IExample)example);
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode("SAP\u5bf9\u8d26\u660e\u7ec6.xls", "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/vnd.ms-excel");
        ServletOutputStream outputStream = response.getOutputStream();
        WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)billInvoices, (String)"\u53d1\u7968\u4fe1\u606f", null, (int)0);
        writableWorkbook.write();
        outputStream.flush();
        writableWorkbook.close();
        outputStream.close();
        return null;
    }

    private List<TitleAndModelKey> createExportExcelHeader() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u53d1\u7968\u7f16\u7801", (String)"invoiceNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u53d1\u7968\u65e5\u671f", (String)"invoiceTime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5206\u914d", (String)"invoiceDistribution"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u62ac\u5934\u6587\u672c", (String)"invoiceTitle"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6587\u672c", (String)"invoiceText"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u7968\u672a\u7a0e\u91d1\u989d", (String)"notIncludeTaxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u7968\u7a0e\u989d", (String)"taxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u7968\u542b\u7a0e\u91d1\u989d", (String)"includeTaxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5bf9\u8d26\u5355\u542b\u7a0e\u603b\u91d1\u989d", (String)"totalAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8fc7\u8d26\u65e5\u671f", (String)"postingTime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"SAP\u53d1\u7968\u7f16\u7801", (String)"sapInvoiceNo"));
        return titleAndModelKeys;
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u6743\u9650\u663e\u793a\u516c\u53f8\u4ee3\u7801")
    @RequestMapping(value={"service/findCompanyCode"})
    @ResponseBody
    public ResponseResult<List<String>> findbusiness(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) List<QueryParam> queryParams) {
        List list = UserOrganizationUtils.getUserCompanyCode((String)SpringSecurityUtils.getLoginUserId());
        return ResponseResult.success((Object)list);
    }

    @ApiOperation(httpMethod="POST", value="\u5b9a\u65f6\u4efb\u52a1\u751f\u6210\u5bf9\u8d26\u5355\u6d4b\u8bd5")
    @RequestMapping(value={"service/createByTimeTask"})
    @ResponseBody
    public ResponseResult<String> createByTimeTask() throws ParseException {
        this.billTimeTaskService.createBill();
        return ResponseResult.success();
    }
}

