/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.finance.command;

import com.els.base.finance.command.AbstractCommand;
import com.els.base.finance.command.ComandInvoker;
import com.els.base.finance.letterSap.TABLEOFZSRMRFCDZHS01;
import com.els.base.finance.letterSap.ZSRMRFCDZHResponse;
import com.els.base.finance.service.impl.LetterSapServiceImpl;
import com.els.base.finance.util.SapException;
import com.els.base.finance.util.SoapServiceRequestText;
import com.els.base.util.BillSapConfUtils;
import com.qqt.service.vo.HttpCallbackResultVO;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSapLetterCommand
extends AbstractCommand<TABLEOFZSRMRFCDZHS01> {
    private static Logger log = LoggerFactory.getLogger(LetterSapServiceImpl.class);
    private static String username = BillSapConfUtils.getServiceUsername();
    private static String password = BillSapConfUtils.getServicePassword();
    private static String serviceUrl = BillSapConfUtils.getLetterUrl();
    private static String serviceNameSpace = BillSapConfUtils.getNameSpace();
    private static String serviceMethod = BillSapConfUtils.getLetterServiceMethod();
    private String sapCode;
    private String companyCode;
    private String endTime;
    private String timeWork;

    public GetSapLetterCommand(String sapCode, String companyCode, String endTime, String timeWork) {
        this.sapCode = sapCode;
        this.companyCode = companyCode;
        this.endTime = endTime;
        this.timeWork = timeWork;
    }

    @Override
    public TABLEOFZSRMRFCDZHS01 execute(ComandInvoker context) {
        log.debug("\u3010\u5bf9\u8d26\u51fdsap\u63a5\u53e3\u83b7\u53d6\u3011serviceUrl\u4e3a[{}]", (Object)serviceUrl);
        SoapServiceRequestText request = new SoapServiceRequestText();
        request.setUrl(serviceUrl);
        if (StringUtils.isNotBlank((String)serviceNameSpace)) {
            request.setNamespace(serviceNameSpace);
        }
        if (!StringUtils.isEmpty((String)username)) {
            String src = username.trim() + ":" + password.trim();
            String encoding = new String(Base64.encodeBase64((byte[])src.getBytes()));
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Basic " + encoding);
            request.addHeaders(headers);
        }
        request.setMethodName(serviceMethod);
        String xmlParams = this.getXmlParams(this.sapCode, this.companyCode, this.endTime);
        request.setXmlParams(xmlParams);
        log.debug("\u3010\u5bf9\u8d26\u51fdsap\u63a5\u53e3\u83b7\u53d6\u3011\u8bf7\u6c42\u53c2\u6570\u4e3a[{}]", (Object)xmlParams);
        log.debug("\u3010\u5bf9\u8d26\u51fdsap\u63a5\u53e3\u83b7\u53d6\u3011\u5f00\u59cb\u8c03\u7528sap\u63a5\u53e3");
        long startTime = System.currentTimeMillis();
        HttpCallbackResultVO vo = request.execute(ZSRMRFCDZHResponse.class);
        long endTime = System.currentTimeMillis();
        log.debug("\u3010\u5bf9\u8d26\u51fdsap\u63a5\u53e3\u83b7\u53d6\u3011\u7ed3\u675f\u8c03\u7528sap\u63a5\u53e3,\u7528\u65f6\u4e3a[{}]", (Object)(endTime - startTime));
        if (vo.getStatus() < 200 || vo.getStatus() > 299) {
            log.error("--> http status {}", (Object)vo.getStatus());
            log.error("--> ReasonPhrase {}", (Object)vo.getReasonPhrase());
            log.error("--> error {}", (Object)vo.getError());
            throw new SapException("500 SAP Internal Server Error");
        }
        log.debug("\u3010\u5bf9\u8d26\u51fdsap\u63a5\u53e3\u83b7\u53d6\u3011\u8fd4\u56de\u7ed3\u679c\u4e3a", vo.getResult());
        ZSRMRFCDZHResponse respone = (ZSRMRFCDZHResponse)vo.getResult();
        if (respone == null) {
            throw new SapException("\u5bf9\u8d26\u51fdsap\u63a5\u53e3\u83b7\u53d6,\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
        }
        TABLEOFZSRMRFCDZHS01 outData = respone.getETDZHDATA();
        if (StringUtils.isEmpty((String)this.timeWork)) {
            if (outData == null || CollectionUtils.isEmpty(outData.getItem())) {
                throw new SapException("SAP\u8fd4\u56de\u7684\u4fe1\u606f\u4e3a\u7a7a!");
            }
            log.info("\u3010\u5bf9\u8d26\u51fdsap\u63a5\u53e3\u83b7\u53d6\u30111\u3001\u4ecesap\u83b7\u53d6\u6570\u636e[{}]\u6761", (Object)outData.getItem().size());
        }
        return outData;
    }

    private String getXmlParams(String sapCode, String companyCode, String endTime) {
        StringBuffer sbBuffer = new StringBuffer();
        sbBuffer.append("<ET_DZH_DATA>");
        sbBuffer.append("</ET_DZH_DATA>");
        sbBuffer.append("<IR_BUDAT>");
        sbBuffer.append("<item>");
        sbBuffer.append("<SIGN>I</SIGN>");
        sbBuffer.append("<OPTION>BT</OPTION>");
        sbBuffer.append("<LOW></LOW>");
        sbBuffer.append("<HIGH>" + endTime + "</HIGH>");
        sbBuffer.append("</item>");
        sbBuffer.append("</IR_BUDAT>");
        sbBuffer.append(" <IR_BUKRS>");
        sbBuffer.append("<item>");
        sbBuffer.append("<SIGN>I</SIGN>");
        sbBuffer.append("<OPTION>EQ</OPTION>");
        sbBuffer.append("<LOW>" + companyCode + "</LOW>");
        sbBuffer.append("<HIGH/>");
        sbBuffer.append("</item>");
        sbBuffer.append("</IR_BUKRS>");
        sbBuffer.append("<IR_LIFNR>");
        sbBuffer.append("<item>");
        sbBuffer.append("<SIGN>I</SIGN>");
        sbBuffer.append("<OPTION>EQ</OPTION>");
        sbBuffer.append("<LOW>" + sapCode + "</LOW>");
        sbBuffer.append("<HIGH/>");
        sbBuffer.append("</item>");
        sbBuffer.append("</IR_LIFNR>");
        return sbBuffer.toString();
    }
}

