/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.finance.command;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.bill.entity.BillItem;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.finance.command.AbstractCommand;
import com.els.base.finance.command.ComandInvoker;
import com.els.base.finance.sap.ZSRMRFCRET;
import com.els.base.finance.sap.ZSRMRFCRKFPResponse;
import com.els.base.finance.service.impl.SapBillServiceImpl;
import com.els.base.finance.util.SapException;
import com.els.base.finance.util.SoapServiceRequestText;
import com.els.base.invoice.entity.BillInvoice;
import com.els.base.util.BillSapConfUtils;
import com.qqt.service.vo.HttpCallbackResultVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteBackSapBillCommand
extends AbstractCommand<ZSRMRFCRKFPResponse> {
    private static Logger log = LoggerFactory.getLogger(SapBillServiceImpl.class);
    private static String username = BillSapConfUtils.getServiceUsername();
    private static String password = BillSapConfUtils.getServicePassword();
    private static String serviceUrl = BillSapConfUtils.getBillWriteBackUrl();
    private static String serviceNameSpace = BillSapConfUtils.getBillWriteNameSpace();
    private static String serviceMethod = BillSapConfUtils.getBillWriteServiceMethod();
    private BillInvoice invoice;
    private String payConditionsCode;
    private User user;
    private BigDecimal rng;

    public WriteBackSapBillCommand(BillInvoice invoice, String payConditionsCode, User user, BigDecimal rng) {
        this.invoice = invoice;
        this.payConditionsCode = payConditionsCode;
        this.user = user;
        this.rng = rng;
    }

    @Override
    public ZSRMRFCRKFPResponse execute(ComandInvoker context) {
        log.debug("\u3010\u5bf9\u8d26\u56de\u5199sap\u3011serviceUrl\u4e3a[{}]", (Object)serviceUrl);
        SoapServiceRequestText request = new SoapServiceRequestText();
        request.setUrl(serviceUrl);
        if (StringUtils.isNotBlank((String)serviceNameSpace)) {
            request.setNamespace(serviceNameSpace);
        }
        if (!StringUtils.isEmpty((String)username)) {
            String src = username.trim() + ":" + password.trim();
            String encoding = new String(Base64.encodeBase64((byte[])src.getBytes()));
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Basic " + encoding);
            request.addHeaders(headers);
        }
        request.setMethodName(serviceMethod);
        request.setConnectTimeout(600000);
        request.setConnectionRequestTimeout(600000);
        request.setSocketTimeout(600000);
        String xmlParams = this.getXmlParams(this.invoice, context, this.user, this.rng);
        request.setXmlParams(xmlParams);
        log.debug("\u3010\u5bf9\u8d26\u56de\u5199sap\u3011\u8bf7\u6c42\u53c2\u6570\u4e3a[{}]", (Object)xmlParams);
        log.debug("\u3010\u5bf9\u8d26\u56de\u5199sap\u3011\u5f00\u59cb\u8c03\u7528sap\u63a5\u53e3");
        long startTime = System.currentTimeMillis();
        HttpCallbackResultVO vo = request.execute(ZSRMRFCRKFPResponse.class);
        long endTime = System.currentTimeMillis();
        log.debug("\u3010\u5bf9\u8d26\u56de\u5199sap\u3011\u7ed3\u675f\u8c03\u7528sap\u63a5\u53e3,\u7528\u65f6\u4e3a[{}]", (Object)(endTime - startTime));
        if (vo.getStatus() < 200 || vo.getStatus() > 299) {
            log.error("--> http status {}", (Object)vo.getStatus());
            log.error("--> ReasonPhrase {}", (Object)vo.getReasonPhrase());
            log.error("--> error {}", (Object)vo.getError());
            throw new SapException("sap\u4e1a\u52a1\u5f02\u5e38,\u56de\u5199sap\u5931\u8d25");
        }
        log.debug("\u3010\u5bf9\u8d26\u56de\u5199sap\u3011\u8fd4\u56de\u7ed3\u679c\u4e3a", vo.getResult());
        ZSRMRFCRKFPResponse respone = (ZSRMRFCRKFPResponse)vo.getResult();
        if (respone == null) {
            throw new SapException("\u5bf9\u8d26\u56de\u5199sap,\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
        }
        ZSRMRFCRET outData = respone.getESINFO();
        Assert.isNotNull((Object)outData, (String)"\u5bf9\u8d26\u56de\u5199sap,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        log.info("\u3010\u5bf9\u8d26\u56de\u5199sap\u30111\u3001\u83b7\u53d6\u5230\u6570\u636e");
        return respone;
    }

    private String getXmlParams(BillInvoice invoice, ComandInvoker context, User user, BigDecimal rng) {
        StringBuffer sbBuffer = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sbBuffer.append("<IS_DATA>");
        List<BillItem> list = invoice.getBillVoucherList();
        BillItem billItem = list.get(0);
        BillExample example = new BillExample();
        example.createCriteria().andIdEqualTo(billItem.getBillId());
        List bills = this.context.getBillService().queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)bills, (String)"\u672a\u627e\u5230\u8be5\u5bf9\u8d26\u5355");
        Bill bill = (Bill)bills.get(0);
        BigDecimal setScale = invoice.getNotIncludeTaxAmount().subtract(invoice.getVoucherTaxAmount()).add(rng).setScale(2, 4);
        sbBuffer.append("<BUKRS>" + billItem.getCompany() + "</BUKRS>");
        String invoiceNo = invoice.getInvoiceNo();
        if (invoiceNo.length() >= 16) {
            sbBuffer.append("<XBLNR>" + invoiceNo.substring(0, 16) + "</XBLNR>");
        } else {
            sbBuffer.append("<XBLNR>" + invoice.getInvoiceNo() + "</XBLNR>");
        }
        sbBuffer.append("<BLDAT>" + sdf.format(invoice.getInvoiceTime()) + "</BLDAT>");
        sbBuffer.append("<BUDAT>" + sdf.format(invoice.getPostingTime()) + "</BUDAT>");
        if (invoice.getIncludeTaxAmount().compareTo(new BigDecimal(0)) != 1) {
            sbBuffer.append("<RMWWR>" + invoice.getIncludeTaxAmount().multiply(new BigDecimal(-1)) + "</RMWWR>");
        } else {
            sbBuffer.append("<RMWWR>" + invoice.getIncludeTaxAmount() + "</RMWWR>");
        }
        sbBuffer.append("<WMWST1>" + setScale + "</WMWST1>");
        if (StringUtils.isEmpty((String)invoice.getTaxCode())) {
            sbBuffer.append("<MWSKZ1></MWSKZ1>");
        } else {
            sbBuffer.append("<MWSKZ1>" + invoice.getTaxCode() + "</MWSKZ1>");
        }
        sbBuffer.append("<BKTXT>" + invoice.getInvoiceTitle() + "</BKTXT>");
        sbBuffer.append("<WAERS>" + billItem.getCurrencyType() + "</WAERS>");
        sbBuffer.append("<ZFBDT>" + sdf.format(invoice.getStandardDate()) + "</ZFBDT>");
        sbBuffer.append("<NETDT></NETDT>");
        sbBuffer.append("<ZTERM>" + this.payConditionsCode + "</ZTERM>");
        sbBuffer.append("<LIFNR></LIFNR>");
        sbBuffer.append("<GSBER>" + invoice.getInvoiceText().substring(0, 4) + "</GSBER>");
        sbBuffer.append("<ZUONR></ZUONR>");
        sbBuffer.append("<KIDNO>" + invoice.getBillNo() + "</KIDNO>");
        sbBuffer.append("<HKONT>14040209</HKONT>");
        if (invoice.getTaxAmount().compareTo(new BigDecimal(0)) != -1) {
            sbBuffer.append("<XRECH>X</XRECH>");
            sbBuffer.append("<TAX_AMOUNT>" + invoice.getTaxAmount() + "</TAX_AMOUNT>");
        } else {
            sbBuffer.append("<XRECH></XRECH>");
            sbBuffer.append("<TAX_AMOUNT>" + invoice.getTaxAmount().multiply(new BigDecimal(-1)) + "</TAX_AMOUNT>");
        }
        sbBuffer.append("<ERNAME>" + user.getWorkNum() + "</ERNAME>");
        sbBuffer.append("<PPNAM>" + user.getWorkNum() + "</PPNAM>");
        sbBuffer.append("<ITEMS>");
        for (BillItem item : list) {
            sbBuffer.append("<item>");
            sbBuffer.append("<EBELN>" + item.getPurchaseOrderNo() + "</EBELN>");
            sbBuffer.append("<EBELP>" + item.getPurchaseOrderItemNo() + "</EBELP>");
            sbBuffer.append("<LFBNR>" + item.getVoucherNo() + "</LFBNR>");
            sbBuffer.append("<LFPOS>" + item.getVoucherProject() + "</LFPOS>");
            sbBuffer.append("<LFGJA>" + item.getAccountingYear() + "</LFGJA>");
            if (StringUtils.isEmpty((String)item.getTaxCode())) {
                sbBuffer.append("<MWSKZ></MWSKZ>");
            } else {
                sbBuffer.append("<MWSKZ>" + item.getTaxCode() + "</MWSKZ>");
            }
            sbBuffer.append("<MENGE>" + item.getMaterialQuantity() + "</MENGE>");
            sbBuffer.append("<BSTME>" + item.getMaterialUnit() + "</BSTME>");
            BigDecimal scale = item.getNotIncludeTaxAmount().setScale(2, 4);
            if ("-".equals(item.getMark())) {
                sbBuffer.append("<WRBTR>" + scale.multiply(new BigDecimal(-1)) + "</WRBTR>");
            } else {
                sbBuffer.append("<WRBTR>" + scale + "</WRBTR>");
            }
            sbBuffer.append("</item>");
        }
        sbBuffer.append("</ITEMS>");
        sbBuffer.append("</IS_DATA>");
        return sbBuffer.toString();
    }
}

