/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.finance.command;

import com.els.base.core.utils.Assert;
import com.els.base.finance.command.AbstractCommand;
import com.els.base.finance.command.ComandInvoker;
import com.els.base.finance.sap.ZSRMRFCRET;
import com.els.base.finance.service.impl.SapBillServiceImpl;
import com.els.base.finance.soap.ZSRMRFCSHTZDResponse;
import com.els.base.finance.util.SapException;
import com.els.base.finance.util.SoapServiceRequestText;
import com.els.base.plan.entity.DeliveryPlan;
import com.els.base.util.BillSapConfUtils;
import com.qqt.service.vo.HttpCallbackResultVO;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteBackSapGoodsCommand
extends AbstractCommand<ZSRMRFCSHTZDResponse> {
    private static Logger log = LoggerFactory.getLogger(SapBillServiceImpl.class);
    private static String username = BillSapConfUtils.getServiceUsername();
    private static String password = BillSapConfUtils.getServicePassword();
    private static String serviceUrl = BillSapConfUtils.getWriteGoodsUrl();
    private static String serviceNameSpace = BillSapConfUtils.getWriteGoodsNameSpace();
    private static String serviceMethod = BillSapConfUtils.getWriteGoodsServiceMethod();
    private List<DeliveryPlan> deliveryPlans;

    public WriteBackSapGoodsCommand(List<DeliveryPlan> deliveryPlans) {
        this.deliveryPlans = deliveryPlans;
    }

    @Override
    public ZSRMRFCSHTZDResponse execute(ComandInvoker context) {
        log.debug("\u3010\u9001\u8d27\u901a\u77e5\u5355\u56de\u5199sap\u3011serviceUrl\u4e3a[{}]", (Object)serviceUrl);
        SoapServiceRequestText request = new SoapServiceRequestText();
        request.setUrl(serviceUrl);
        if (StringUtils.isNotBlank((String)serviceNameSpace)) {
            request.setNamespace(serviceNameSpace);
        }
        if (!StringUtils.isEmpty((String)username)) {
            String src = username.trim() + ":" + password.trim();
            String encoding = new String(Base64.encodeBase64((byte[])src.getBytes()));
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Basic " + encoding);
            request.addHeaders(headers);
        }
        request.setMethodName(serviceMethod);
        String xmlParams = this.getXmlParams(this.deliveryPlans);
        request.setXmlParams(xmlParams);
        log.debug("\u3010\u9001\u8d27\u901a\u77e5\u5355\u56de\u5199sap\u3011\u8bf7\u6c42\u53c2\u6570\u4e3a[{}]", (Object)xmlParams);
        log.debug("\u3010\u9001\u8d27\u901a\u77e5\u5355\u56de\u5199sap\u3011\u5f00\u59cb\u8c03\u7528sap\u63a5\u53e3");
        long startTime = System.currentTimeMillis();
        HttpCallbackResultVO vo = request.execute(ZSRMRFCSHTZDResponse.class);
        long endTime = System.currentTimeMillis();
        log.debug("\u3010\u9001\u8d27\u901a\u77e5\u5355\u56de\u5199sap\u3011\u7ed3\u675f\u8c03\u7528sap\u63a5\u53e3,\u7528\u65f6\u4e3a[{}]", (Object)(endTime - startTime));
        if (vo.getStatus() < 200 || vo.getStatus() > 299) {
            log.error("--> http status {}", (Object)vo.getStatus());
            log.error("--> ReasonPhrase {}", (Object)vo.getReasonPhrase());
            log.error("--> error {}", (Object)vo.getError());
            throw new SapException("sap\u4e1a\u52a1\u5f02\u5e38,\u56de\u5199sap\u5931\u8d25");
        }
        log.debug("\u3010\u9001\u8d27\u901a\u77e5\u5355\u56de\u5199sap\u3011\u8fd4\u56de\u7ed3\u679c\u4e3a", vo.getResult());
        ZSRMRFCSHTZDResponse respone = (ZSRMRFCSHTZDResponse)vo.getResult();
        if (respone == null) {
            throw new SapException("\u9001\u8d27\u901a\u77e5\u5355\u56de\u5199sap,\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
        }
        ZSRMRFCRET outData = respone.getESINFO();
        Assert.isNotNull((Object)outData, (String)"\u9001\u8d27\u901a\u77e5\u5355\u56de\u5199sap,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        log.info("\u3010\u9001\u8d27\u901a\u77e5\u5355\u56de\u5199sap\u30111\u3001\u83b7\u53d6\u5230\u6570\u636e");
        return respone;
    }

    private String getXmlParams(List<DeliveryPlan> deliveryPlans) {
        StringBuilder sbBuffer = new StringBuilder();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat format2 = new SimpleDateFormat("HH:mm:ss");
        int i = 0;
        int j = 1;
        sbBuffer.append("<IT_SHTZD>");
        for (DeliveryPlan deliveryPlan : deliveryPlans) {
            sbBuffer.append("<item>");
            sbBuffer.append("<MANDT></MANDT>");
            sbBuffer.append("<SHTZD>" + ++i + "</SHTZD>");
            sbBuffer.append("<SHTZH>" + ++j + "</SHTZH>");
            sbBuffer.append("<WERKS>" + deliveryPlan.getFactoryCode() + "</WERKS>");
            sbBuffer.append("<NAME1>" + deliveryPlan.getFactoryName() + "</NAME1>");
            if (StringUtils.isEmpty((String)deliveryPlan.getMaterialCode())) {
                sbBuffer.append("<MATNR></MATNR>");
            } else {
                sbBuffer.append("<MATNR>" + deliveryPlan.getMaterialCode() + "</MATNR>");
            }
            sbBuffer.append("<MAKTX></MAKTX>");
            if (StringUtils.isEmpty((String)deliveryPlan.getIsLock())) {
                sbBuffer.append("<ZSDBS></ZSDBS>");
            } else {
                sbBuffer.append("<ZSDBS>" + deliveryPlan.getIsLock() + "</ZSDBS>");
            }
            if (StringUtils.isEmpty((String)deliveryPlan.getJitItem())) {
                sbBuffer.append("<FABKZ></FABKZ>");
            } else {
                sbBuffer.append("<FABKZ>" + deliveryPlan.getJitItem() + "</FABKZ>");
            }
            sbBuffer.append("<ZSDRQ>" + format.format(deliveryPlan.getArryvalTime()) + "</ZSDRQ>");
            sbBuffer.append("<ZSDSJ>" + format2.format(deliveryPlan.getArryvalTime()) + "</ZSDSJ>");
            sbBuffer.append("<ZJHSL>" + deliveryPlan.getConsumeMunber() + "</ZJHSL>");
            if (StringUtils.isEmpty((String)deliveryPlan.getUnit())) {
                sbBuffer.append("<MEINS></MEINS>");
            } else {
                sbBuffer.append("<MEINS>" + deliveryPlan.getUnit() + "</MEINS>");
            }
            sbBuffer.append("</item>");
        }
        sbBuffer.append("</IT_SHTZD>");
        return sbBuffer.toString();
    }
}

