/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bill.entity.BillItem;
import com.els.base.bill.entity.BillItemExample;
import com.els.base.bill.service.BillItemService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u5f00\u7968\u6e05\u5355\u884c\u5165\u9000\u5e93\u51ed\u8bc1,\u6298\u8ba9\u5355"})
@Controller
@RequestMapping(value={"billItem"})
public class BillItemController {
    @Resource
    protected BillItemService billItemService;

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91SAP\u5bf9\u8d26\u660e\u7ec6-\u5e94\u5f00\u7968\u6e05\u5355(\u91c7\u8d2d\u65b9)")
    @RequestMapping(value={"service/modify"})
    @ResponseBody
    public ResponseResult<String> modify(@RequestBody BillItem billItem) {
        Assert.isNotBlank((String)billItem.getId(), (String)"id\u4e3a\u7a7a,\u4fdd\u5b58\u5931\u8d25");
        this.billItemService.modify(billItem, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u5f00\u7968\u6e05\u5355\u884c\u5165\u9000\u5e93\u51ed\u8bc1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BillItem", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/voucher/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BillItem>> findForVoucherByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BillItemExample example = new BillItemExample();
        example.setPageView((PageView<BillItem>)new PageView(pageNo, pageSize));
        BillItemExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.billItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u5f00\u7968\u6e05\u5355\u884c\u5165\u9000\u5e93\u51ed\u8bc1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BillItem", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/voucher/findByPageForPur"})
    @ResponseBody
    public ResponseResult<PageView<BillItem>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BillItemExample example = new BillItemExample();
        example.setPageView((PageView<BillItem>)new PageView(pageNo, pageSize));
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andProjectTypesEqualTo("0");
        example.or().andIsEnableEqualTo(Constant.YES_INT).andProjectTypesIsNull();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.billItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

