/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.service.impl;

import com.els.base.bill.dao.BillMapper;
import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.bill.entity.BillItem;
import com.els.base.bill.entity.BillItemExample;
import com.els.base.bill.service.BillItemService;
import com.els.base.bill.service.BillService;
import com.els.base.bill.utils.BillPrintUtils;
import com.els.base.bill.utils.BillSendStatus;
import com.els.base.bill.utils.BillStatus;
import com.els.base.bill.utils.BillStatusConfirmEnum;
import com.els.base.bill.utils.CalculateBillUtil;
import com.els.base.bill.vo.BillInvoiceExportExcelVo;
import com.els.base.bill.vo.BillVo;
import com.els.base.bill.vo.CheckBillPrintVo;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.conditions.entity.Conditions;
import com.els.base.conditions.entity.ConditionsExample;
import com.els.base.conditions.service.ConditionsService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.deduction.entity.Deduction;
import com.els.base.deduction.entity.DeductionExample;
import com.els.base.deduction.service.DeductionService;
import com.els.base.file.entity.FileData;
import com.els.base.finance.service.SapBillService;
import com.els.base.invoice.entity.BillInvoice;
import com.els.base.invoice.entity.BillInvoiceExample;
import com.els.base.invoice.service.BillInvoiceService;
import com.els.base.letter.entity.Letter;
import com.els.base.letter.entity.LetterExample;
import com.els.base.letter.service.LetterService;
import com.els.base.letter.util.LetterStatus;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.purVoucher.service.BillPurVoucherService;
import com.els.base.taxclassify.entity.TaxClassify;
import com.els.base.taxclassify.entity.TaxClassifyExample;
import com.els.base.taxclassify.service.TaxClassifyService;
import com.els.base.util.BillBusinessTypeEnum;
import com.els.base.voucher.entity.BillVoucher;
import com.els.base.voucher.entity.BillVoucherExample;
import com.els.base.voucher.service.BillVoucherService;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBillService")
public class BillServiceImpl
implements BillService {
    Logger logger = LoggerFactory.getLogger(BillServiceImpl.class);
    private static Gson json = new Gson();
    @Resource
    protected BillMapper billMapper;
    @Resource
    protected BillVoucherService billVoucherService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected BillItemService billItemService;
    @Resource
    protected BillInvoiceService billInvoiceService;
    @Resource
    private SapBillService sapBillService;
    @Resource
    private TaxClassifyService taxClassifyService;
    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private ConditionsService conditionsService;
    @Resource
    private DeductionService deductionService;
    @Resource
    private BillPurVoucherService billPurVoucherService;
    @Resource
    private LetterService letterService;

    @Override
    @CacheEvict(value={"bill"}, allEntries=true)
    @Transactional
    public void abolishForPur(Project project, Company company, final User loginUser, List<Bill> billList) {
        Assert.isNotEmpty(billList, (String)"\u5f00\u7968\u6e05\u5355ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<String> ids = billList.stream().map(bill -> bill.getId()).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn((List)ids);
        List<Bill> bills = this.billMapper.selectByExample(billExample);
        for (Bill bill2 : bills) {
            if (bill2.getAbolishStatus().equals(BillStatus.YES_WRITEBACK.getCode()) || bill2.getAbolishStatus().equals(BillStatus.ABOLISH.getCode())) {
                throw new CommonException("\u9009\u62e9\u7684\u5bf9\u8d26\u5355\u53f7:" + bill2.getBillNo() + "\u5df2\u56de\u5199\u6216\u5df2\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u518d\u4f5c\u5e9f!");
            }
            bill2.setId(bill2.getId());
            bill2.setAbolishStatus(BillStatus.ABOLISH.getCode());
            bill2.setAbolishUserId(loginUser.getId());
            bill2.setAbolishUserName(loginUser.getNickName());
            bill2.setAbolishTime(new Date());
            this.modifyObj(bill2);
            String dnos = bill2.getApproveResult();
            if (StringUtils.isNotEmpty((String)dnos)) {
                String[] strings;
                for (String dno : strings = dnos.split(",")) {
                    DeductionExample example = new DeductionExample();
                    example.createCriteria().andDeductionNoEqualTo(dno).andIsEnableEqualTo(Constant.YES_INT);
                    List deductions = this.deductionService.queryAllObjByExample((IExample)example);
                    if (!CollectionUtils.isNotEmpty((Collection)deductions)) continue;
                    for (Deduction deduction : deductions) {
                        deduction.setId(deduction.getId());
                        deduction.setBillFlag(Constant.NO_INT);
                        this.deductionService.modifyObj(deduction);
                    }
                }
            }
            this.sapBillService.deductionBackSap(bill2);
        }
        this.deleteVoucherByBillIds(ids);
        List<Bill> list = this.queryAllObjByExample(billExample);
        for (final Bill bill2 : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    BillServiceImpl.this.sendMessagesToSup(loginUser, bill2, BillBusinessTypeEnum.BILL_ABOLISH.getCode());
                }
            });
        }
    }

    private void deleteVoucherByBillIds(List<String> ids) {
        BillItemExample billItemExample = new BillItemExample();
        billItemExample.createCriteria().andBillIdIn((List)ids);
        List billItems = this.billItemService.queryAllObjByExample((IExample)billItemExample);
        billItems.forEach(i -> {
            this.billItemService.deleteObjById(i.getId());
            this.billVoucherService.deleteObjById(i.getVoucherId());
        });
        BillInvoiceExample example = new BillInvoiceExample();
        example.createCriteria().andBillIdIn((List)ids);
        List invoices = this.billInvoiceService.queryAllObjByExample((IExample)example);
        for (BillInvoice billInvoice : invoices) {
            this.billInvoiceService.deleteObjById(billInvoice.getId());
        }
    }

    @Override
    @CacheEvict(value={"bill"}, allEntries=true)
    @Transactional
    public void rejectForSup(Project project, Company company, User loginUser, List<Bill> billList) {
        Assert.isNotEmpty(billList, (String)"\u5f00\u7968\u6e05\u5355ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<String> ids = billList.stream().map(bill -> bill.getId()).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn((List)ids);
        Bill bill2 = new Bill();
        bill2.setSupConfirmStatus(BillStatusConfirmEnum.STATUS_REJECT.getConfirmStatus());
        this.billMapper.updateByExampleSelective(bill2, billExample);
        this.updateVoucherByBillIds(ids, Constant.NO_INT);
    }

    @Override
    @CacheEvict(value={"bill"}, allEntries=true)
    @Transactional
    public void signForPur(Project project, Company company, final User loginUser, List<Bill> billList) {
        Assert.isNotEmpty(billList, (String)"\u5f00\u7968\u6e05\u5355ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List ids = billList.stream().map(bill -> bill.getId()).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn(ids);
        Bill bill2 = new Bill();
        bill2.setApproveNo(loginUser.getId());
        bill2.setApproveTime(new Date());
        bill2.setApproveUserName(loginUser.getNickName());
        bill2.setPurConfirmBillStatus(BillSendStatus.YES_INT);
        this.billMapper.updateByExampleSelective(bill2, billExample);
        List<Bill> list = this.queryAllObjByExample(billExample);
        for (final Bill bill22 : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    BillServiceImpl.this.sendMessagesToSup(loginUser, bill22, BillBusinessTypeEnum.BILL_CONFIRM_INVOICE.getCode());
                }
            });
        }
    }

    @Override
    @CacheEvict(value={"bill"}, allEntries=true)
    @Transactional
    public void confirmForSup(Project project, Company company, final User loginUser, List<Bill> billList) {
        Assert.isNotEmpty(billList, (String)"\u5f00\u7968\u6e05\u5355ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<String> ids = billList.stream().map(bill -> bill.getId()).collect(Collectors.toList());
        this.filterForSupConfirm(ids);
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn((List)ids);
        List<Bill> bills = this.billMapper.selectByExample(billExample);
        for (Bill bill2 : bills) {
            if (BillStatusConfirmEnum.STATUS_CONFIRM.getConfirmStatus().equals(bill2.getSupConfirmStatus())) {
                throw new CommonException("\u4f9b\u65b9\u5df2\u786e\u8ba4,\u4e0d\u5141\u8bb8\u518d\u786e\u8ba4");
            }
            bill2.setId(bill2.getId());
            bill2.setPurSendStatus(BillSendStatus.YES_INT);
            bill2.setSupConfirmStatus(BillStatusConfirmEnum.STATUS_CONFIRM.getConfirmStatus());
            bill2.setSupConfirmBillStatus(Constant.NO_INT);
            bill2.setSupUserId(loginUser.getId());
            bill2.setSupUserName(loginUser.getNickName());
            this.modifyObj(bill2);
        }
        List<Bill> list = this.queryAllObjByExample(billExample);
        for (final Bill bill2 : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    BillServiceImpl.this.sendMessagesToPur(loginUser, bill2, BillBusinessTypeEnum.BILL_CONFIRM.getCode());
                }
            });
        }
    }

    @Override
    @CacheEvict(value={"bill"}, allEntries=true)
    @Transactional
    public void rejectInvoice(Project project, Company currentCompany, final User loginUser, List<Bill> billList) {
        Assert.isNotEmpty(billList, (String)"\u5f00\u7968\u6e05\u5355ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List ids = billList.stream().map(bill -> bill.getId()).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn(ids).andSupConfirmBillStatusEqualTo(Constant.NO_INT);
        if (this.billMapper.countByExample(billExample) > 0) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25,\u5355\u636e\u4e2d\u5305\u542b\u4e86\u4f9b\u5e94\u5546\u53d1\u7968\u72b6\u6001\u4e3a\u672a\u786e\u8ba4\u7684\u5355\u636e,\u8bf7\u91cd\u65b0\u9009\u62e9!");
        }
        billExample.clear();
        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
        billStatusList.add(BillStatusConfirmEnum.STATUS_CONFIRM.getConfirmStatus());
        billStatusList.add(BillStatusConfirmEnum.STATUS_BACK.getConfirmStatus());
        billExample.createCriteria().andIdIn(ids).andPurConfirmBillStatusIn(billStatusList);
        if (this.billMapper.countByExample(billExample) > 0) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25,\u5355\u636e\u4e2d\u5305\u542b\u4e86\u91c7\u8d2d\u5546\u53d1\u7968\u72b6\u6001\u4e3a\u5df2\u786e\u8ba4\u6216\u5df2\u9000\u56de\u7684\u5355\u636e,\u8bf7\u91cd\u65b0\u9009\u62e9!");
        }
        billExample.clear();
        billExample.createCriteria().andIdIn(ids);
        Bill bill2 = new Bill();
        bill2.setPurConfirmBillStatus(BillStatusConfirmEnum.STATUS_BACK.getConfirmStatus());
        bill2.setSupConfirmBillStatus(Constant.NO_INT);
        this.billMapper.updateByExampleSelective(bill2, billExample);
        List<Bill> bills = this.billMapper.selectByExample(billExample);
        for (Bill b : bills) {
            BillInvoiceExample invoiceExample = new BillInvoiceExample();
            invoiceExample.createCriteria().andBillNoEqualTo(b.getBillNo());
            List BillInvoices = this.billInvoiceService.queryAllObjByExample((IExample)invoiceExample);
            for (BillInvoice billInvoice : BillInvoices) {
                if (StringUtils.isNotEmpty((String)billInvoice.getInvoiceDistribution()) || "1".equals(billInvoice.getInvoiceDistribution())) {
                    throw new CommonException("\u64cd\u4f5c\u5931\u8d25,\u5355\u636e\u4e2d\u5305\u542b\u4e86\u91c7\u8d2d\u5546\u65b0\u5efa\u7684\u53d1\u7968\u6216\u5df2\u5220\u9664\u4f9b\u5e94\u5546\u65b0\u5efa\u7684\u53d1\u7968,\u8bf7\u91cd\u65b0\u9009\u62e9!");
                }
                invoiceExample.clear();
                invoiceExample.createCriteria().andIdEqualTo(billInvoice.getId());
                BillInvoice invoice = new BillInvoice();
                invoice.setIsBack(Constant.YES_INT);
                this.billInvoiceService.updateByExampleSelective(invoice, invoiceExample);
            }
        }
        List<Bill> list = this.queryAllObjByExample(billExample);
        for (final Bill bill22 : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    BillServiceImpl.this.sendMessagesToSup(loginUser, bill22, BillBusinessTypeEnum.BILL_BACK_INVOICE.getCode());
                }
            });
        }
    }

    private void filterForSupConfirm(List<String> ids) {
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn((List)ids).andSupSendStatusEqualTo(Constant.NO_INT);
        int count = this.billMapper.countByExample(billExample);
        if (count > 0) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e\u4e2d\u5305\u542b\u4e86\u672a\u53d1\u9001\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
        }
    }

    @Override
    @CacheEvict(value={"bill"}, allEntries=true)
    @Transactional
    public void signForSup(Project project, Company company, final User loginUser, List<Bill> billList) {
        Assert.isNotEmpty(billList, (String)"\u5f00\u7968\u6e05\u5355ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List ids = billList.stream().map(bill -> bill.getId()).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn(ids);
        List<Bill> bills = this.billMapper.selectByExample(billExample);
        for (Bill bill2 : bills) {
            if (Constant.YES_INT.equals(bill2.getSupConfirmBillStatus())) {
                throw new CommonException("\u4f9b\u5e94\u5546\u53d1\u7968\u72b6\u6001\u5df2\u786e\u8ba4,\u4e0d\u5141\u8bb8\u518d\u786e\u8ba4\uff01");
            }
            LetterExample example = new LetterExample();
            example.setOrderByClause("CREATE_TIME DESC");
            example.createCriteria().andSupCompanySapCodeEqualTo(bill2.getSupCompanySapCode()).andCompanyCodeEqualTo(bill2.getCompanyCode()).andIsEnableEqualTo(Constant.YES_INT);
            List list = this.letterService.queryAllObjByExample((IExample)example);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                Letter letter = (Letter)list.get(0);
                if (LetterStatus.NO_CONFIRM.getCode().equals(letter.getConfirmStatus()) || LetterStatus.PUR_BACK.getCode().equals(letter.getConfirmStatus())) {
                    throw new CommonException("\u4f9b\u5e94\u5546\uff1a" + bill2.getSupCompanyFullName() + ",\u516c\u53f8\u4ee3\u7801\uff1a" + bill2.getCompanyCode() + "\u5b58\u5728\u672a\u786e\u8ba4\u7684\u5bf9\u8d26\u51fd\u51fd\u636e,\u8bf7\u5148\u786e\u8ba4\u51fd\u636e\uff01");
                }
            }
            bill2.setId(bill2.getId());
            bill2.setSupConfirmBillStatus(Constant.YES_INT);
            bill2.setPurConfirmBillStatus(BillSendStatus.NO_INT);
            bill2.setSupUserId(loginUser.getId());
            bill2.setSupUserName(loginUser.getNickName());
            this.modifyObj(bill2);
            BillInvoiceExample invoiceExample = new BillInvoiceExample();
            invoiceExample.createCriteria().andBillNoEqualTo(bill2.getBillNo());
            BillInvoice invoice = new BillInvoice();
            invoice.setIsBack(Constant.NO_INT);
            this.billInvoiceService.updateByExampleSelective(invoice, invoiceExample);
        }
        List<Bill> list = this.queryAllObjByExample(billExample);
        for (final Bill bill2 : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    BillServiceImpl.this.sendMessagesToPur(loginUser, bill2, BillBusinessTypeEnum.BILL_SIGN.getCode());
                }
            });
        }
    }

    @Override
    @CacheEvict(value={"bill"}, allEntries=true)
    @Transactional
    public void sendForPur(Project project, Company company, final User loginUser, List<Bill> billList) {
        Assert.isNotEmpty(billList, (String)"\u5f00\u7968\u6e05\u5355ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<String> ids = billList.stream().map(bill -> bill.getId()).collect(Collectors.toList());
        this.filterForPurSend(ids);
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn((List)ids);
        Bill bill2 = new Bill();
        bill2.setPurSendStatus(BillSendStatus.YES_INT);
        this.billMapper.updateByExampleSelective(bill2, billExample);
        List<Bill> list = this.queryAllObjByExample(billExample);
        for (final Bill bill22 : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    BillServiceImpl.this.sendMessagesToSup(loginUser, bill22, BillBusinessTypeEnum.BILL_SEND.getCode());
                }
            });
        }
    }

    protected void sendMessagesToSup(User loginUser, Bill data, String businessType) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getSupCompanyId());
        String supUserId = null;
        supUserId = StringUtils.isEmpty((String)data.getSupUserId()) ? supUser.getId() : data.getSupUserId();
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUserId);
        MessageSendUtils.sendMessage((Message)message);
    }

    protected void sendMessagesToPur(User loginUser, Bill data, String businessType) {
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(data.getPurUserId());
        MessageSendUtils.sendMessage((Message)message);
    }

    private void filterForPurSend(List<String> ids) {
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT).andPurSendStatusNotEqualTo(Constant.NO_INT);
        int count = this.billMapper.countByExample(billExample);
        if (count > 0) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e\u4e2d\u5305\u542b\u5df2\u53d1\u9001\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
        }
    }

    @Override
    @CacheEvict(value={"bill"}, allEntries=true)
    @Transactional
    public void deleteObjByIds(Project project, Company company, User loginUser, List<Bill> billList) {
        this.filterDeleteObjByIds(billList);
        List<String> ids = this.deleteBillByIds(billList);
        this.deleteVoucherByBillIds(ids);
    }

    private List<String> deleteBillByIds(List<Bill> billList) {
        List<String> ids = billList.stream().map(bill -> bill.getId()).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn((List)ids).andPurSendStatusEqualTo(Constant.YES_INT);
        if (this.billMapper.countByExample(billExample) > 0) {
            throw new CommonException("\u9009\u62e9\u7684\u5355\u636e\u4e2d\u542b\u6709\u5df2\u53d1\u9001\u7684\u5355\u636e,\u65e0\u6cd5\u5220\u9664\u5bf9\u8d26\u5355!");
        }
        billExample.clear();
        billExample.createCriteria().andIdIn((List)ids);
        List<Bill> bills = this.queryAllObjByExample(billExample);
        for (Bill bill2 : bills) {
            bill2.setId(bill2.getId());
            bill2.setIsEnable(Constant.NO_INT);
            this.modifyObj(bill2);
            String dnos = bill2.getApproveResult();
            if (StringUtils.isNotEmpty((String)dnos)) {
                String[] strings;
                for (String dno : strings = dnos.split(",")) {
                    DeductionExample example = new DeductionExample();
                    example.createCriteria().andDeductionNoEqualTo(dno).andIsEnableEqualTo(Constant.YES_INT);
                    List deductions = this.deductionService.queryAllObjByExample((IExample)example);
                    if (!CollectionUtils.isNotEmpty((Collection)deductions)) continue;
                    for (Deduction deduction : deductions) {
                        deduction.setId(deduction.getId());
                        deduction.setBillFlag(Constant.NO_INT);
                        this.deductionService.modifyObj(deduction);
                    }
                }
            }
            this.sapBillService.deductionBackSap(bill2);
        }
        return ids;
    }

    private void filterDeleteObjByIds(List<Bill> billList) {
        Assert.isNotEmpty(billList, (String)"\u5f00\u7968\u6e05\u5355ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (Bill bill : billList) {
            Assert.isNotNull((Object)bill.getId(), (String)"\u5f00\u7968\u6e05\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void updateVoucherByBillIds(List<String> ids, int billFlag) {
        BillItemExample billItemExample = new BillItemExample();
        billItemExample.createCriteria().andBillIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT);
        List billItems = this.billItemService.queryAllObjByExample((IExample)billItemExample);
        if (CollectionUtils.isEmpty((Collection)billItems)) {
            return;
        }
        ArrayList<String> voucherIds = new ArrayList<String>();
        for (BillItem billItem : billItems) {
            voucherIds.add(billItem.getVoucherId());
        }
        if (CollectionUtils.isEmpty(voucherIds)) {
            return;
        }
        BillItem item = new BillItem();
        item.setBillFlag(billFlag);
        item.setBillInvoiceFlag(billFlag);
        this.billItemService.updateByExampleSelective(item, billItemExample);
        BillVoucherExample billVoucherExample = new BillVoucherExample();
        billVoucherExample.createCriteria().andIdIn(voucherIds);
        BillVoucher billVoucher = new BillVoucher();
        billVoucher.setBillFlag(billFlag);
        this.billVoucherService.updateByExampleSelective(billVoucher, billVoucherExample);
    }

    @Override
    @CacheEvict(value={"bill"}, allEntries=true)
    @Transactional
    public void createBill(Project project, User loginUser, Company company, BillVo bill) {
        this.updateDecution(bill);
        this.billMapper.insertSelective(bill);
        List<BillVoucher> voucherList = this.insertVoucherList(bill, bill.getPostingStartTime(), bill.getPostingEndTime());
        CalculateBillUtil.calculateAmount(bill, voucherList);
        this.billMapper.updateByPrimaryKeySelective(bill);
        this.sapBillService.deductionBackSap(bill);
    }

    @Override
    @CacheEvict(value={"bill"}, allEntries=true)
    @Transactional
    public void createBill1(Project project, User loginUser, Company company, BillVo bill) {
        this.createBillInfo(bill);
        this.updateBillVoucher(bill.getBillVoucherList(), Constant.YES_INT);
        CalculateBillUtil.calculateAmount(bill, bill.getBillVoucherList());
        this.billMapper.updateByPrimaryKeySelective(bill);
    }

    private void createBillInfo(BillVo bill) {
        this.billMapper.insertSelective(bill);
        List<BillVoucher> voucherList = bill.getBillVoucherList();
        if (CollectionUtils.isEmpty(voucherList)) {
            throw new CommonException("\u884c\u8bb0\u5f55\u6ca1\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        voucherList.forEach(voucher -> {
            BillItem billItem = new BillItem();
            billItem.setPurCompanyId(bill.getPurCompanyId());
            billItem.setPurCompanySrmCode(bill.getPurCompanySrmCode());
            billItem.setPurCompanyName(bill.getPurCompanyName());
            billItem.setPurCompanyFullName(bill.getPurCompanyFullName());
            billItem.setSupCompanyId(bill.getSupCompanyId());
            billItem.setSupCompanyName(bill.getSupCompanyName());
            billItem.setSupCompanyFullName(bill.getSupCompanyFullName());
            billItem.setSupCompanySrmCode(bill.getSupCompanySrmCode());
            billItem.setDeliveryOrderNo(voucher.getDeliveryOrderNo());
            billItem.setDeliveryOrderItemNo(voucher.getDeliveryOrderItemNo());
            billItem.setPurchaseOrderNo(voucher.getPurchaseOrderNo());
            billItem.setPurchaseOrderItemNo(voucher.getPurchaseOrderItemNo());
            billItem.setMaterialId(voucher.getMaterialId());
            billItem.setMaterialNo(voucher.getMaterialNo());
            billItem.setMaterialDesc(voucher.getMaterialDesc());
            billItem.setMaterialQuantity(voucher.getMaterialQuantity());
            billItem.setMaterialVoucherNo(voucher.getMaterialVoucherNo());
            billItem.setMaterialVoucherItemNo(voucher.getMaterialVoucherItemNo());
            billItem.setBillFlag(Constant.YES_INT);
            billItem.setIsEnable(Constant.YES_INT);
            billItem.setTaxRate(voucher.getTaxRate());
            billItem.setNotIncludeTaxAmount(voucher.getNotIncludeTaxAmount());
            billItem.setIncludeTaxAmount(voucher.getIncludeTaxAmount());
            billItem.setTaxAmount(voucher.getTaxAmount());
            billItem.setLatestPrice(voucher.getLatestPrice());
            billItem.setOrderPrice(voucher.getOrderPrice());
            billItem.setOrderAmount(voucher.getOrderAmount());
            billItem.setBillId(bill.getId());
            billItem.setBillNo(bill.getBillNo());
            billItem.setBillInvoiceFlag(Constant.NO_INT);
            billItem.setTaxCode(voucher.getTaxCode());
            billItem.setMaterialUnit(voucher.getMaterialUnit());
            billItem.setInputDate(voucher.getInputDate());
            billItem.setStockSpaceCode(voucher.getStockSpaceCode());
            billItem.setStockSpaceRemark(voucher.getStockSpaceRemark());
            billItem.setCompany(voucher.getCompany());
            billItem.setQuantity(voucher.getQuantity());
            billItem.setUserName(voucher.getUserName());
            billItem.setPaymentWay(voucher.getPaymentWay());
            billItem.setMark(voucher.getMark());
            billItem.setPriceEntity(voucher.getPriceEntity());
            this.billItemService.addObj(billItem);
        });
    }

    private void updateDecution(BillVo bill) {
        DeductionExample example = new DeductionExample();
        example.createCriteria().andCompanyCodeEqualTo(bill.getCompanyCode()).andSupCompanyIdEqualTo(bill.getSupCompanyId()).andIsEnableEqualTo(Constant.YES_INT).andBillFlagEqualTo(Constant.NO_INT);
        List deductions = this.deductionService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)deductions)) {
            bill.setDeductionAmount(new BigDecimal(0));
        } else {
            BigDecimal big = new BigDecimal(0);
            StringBuilder stringBuilder = new StringBuilder();
            for (Deduction deduction : deductions) {
                big = big.add(deduction.getDeductionAmount());
                stringBuilder.append(deduction.getDeductionNo()).append(",");
                Deduction de = new Deduction();
                de.setId(deduction.getId());
                de.setBillFlag(Constant.YES_INT);
                this.deductionService.modifyObj(de);
            }
            String substring = stringBuilder.substring(0, stringBuilder.length() - 1);
            bill.setDeductionAmount(big);
            bill.setApproveResult(substring);
        }
    }

    private List<BillVoucher> insertVoucherList(BillVo bill, Date startTime, Date endTime) {
        List<String> ids = bill.getBillVoucherList().stream().map(b -> b.getId()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            for (String id : ids) {
                this.billVoucherService.deleteObjById(id);
            }
        }
        List<BillVoucher> myList = this.billVoucherService.queryAllBillVoucher(bill.getCompanyCode(), bill.getSupCompanySapCode(), startTime, endTime, ids);
        Assert.isNotEmpty(myList, (String)"\u8bf7\u9009\u62e9\u4e00\u6761\u4ee5\u4e0a\u7684\u5165\u9000\u5e93\u51ed\u8bc1\u5355\u636e\uff0c\u8c22\u8c22\uff01");
        Set billVoucherTaxCodeSet = myList.stream().map(voucher -> voucher.getTaxCode()).collect(Collectors.toSet());
        if (billVoucherTaxCodeSet.size() != 1) {
            throw new CommonException("\u51ed\u8bc1\u7a0e\u7801\u4e0d\u540c\uff0c\u4e0d\u80fd\u751f\u6210\u4e00\u5f20\u5bf9\u8d26\u5355");
        }
        List group = Lists.partition(myList, (int)999);
        for (List list : group) {
            this.updateBillVoucher(list, Constant.YES_INT);
        }
        this.insertVoucher(bill, myList);
        return myList;
    }

    private void updateBillVoucher(List<BillVoucher> voucherList, int billFlag) {
        if (CollectionUtils.isNotEmpty(voucherList)) {
            List ids = voucherList.stream().map(billVoucher -> billVoucher.getId()).collect(Collectors.toList());
            BillVoucherExample billVoucherExample = new BillVoucherExample();
            billVoucherExample.createCriteria().andIdIn(ids);
            BillVoucher billVoucher2 = new BillVoucher();
            billVoucher2.setBillFlag(billFlag);
            this.billVoucherService.updateByExampleSelective(billVoucher2, billVoucherExample);
        }
    }

    private void insertVoucher(BillVo bill, List<BillVoucher> billVoucherList) {
        Assert.isNotEmpty(billVoucherList, (String)"\u5f00\u7968\u6e05\u5355\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (BillVoucher billVoucher : billVoucherList) {
            BillItem billItem = new BillItem();
            BeanUtils.copyProperties((Object)billVoucher, (Object)billItem);
            billItem.setId(null);
            billItem.setBillId(bill.getId());
            billItem.setBillNo(bill.getBillNo());
            billItem.setBillFlag(Constant.YES_INT);
            billItem.setIsEnable(Constant.YES_INT);
            billItem.setVoucherId(billVoucher.getId());
            billItem.setBillInvoiceFlag(Constant.NO_INT);
            this.billItemService.addObj(billItem);
        }
    }

    private void setPurCompanyInfo(Project project, Bill bill) {
        Company purCompany = (Company)this.companyService.queryObjById((Object)project.getCompanyId());
        Assert.isNotNull((Object)purCompany, (String)"\u91c7\u8d2d\u57fa\u672c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        bill.setPurCompanyId(purCompany.getId());
        bill.setPurCompanySrmCode(purCompany.getCompanyCode());
        bill.setPurCompanySapCode(purCompany.getCompanySapCode());
        bill.setPurCompanyName(purCompany.getCompanyName());
        bill.setPurCompanyFullName(purCompany.getCompanyFullName());
    }

    @Override
    @Transactional
    @Cacheable(value={"bill"}, keyGenerator="redisKeyGenerator")
    public Bill prepareForPur(Project project, User loginUser, Company company, String companyCode, String supCompanySapCode, Date startTime, Date endTime) throws ParseException {
        String startTimeStr = DateFormatUtils.format((Date)startTime, (String)"yyyy-MM-dd");
        String endTimeStr = DateFormatUtils.format((Date)endTime, (String)"yyyy-MM-dd");
        this.sapBillService.importByVoucherDate(companyCode, supCompanySapCode, startTimeStr, endTimeStr);
        this.logger.info(String.format("EVENT=\u5f00\u7968\u6e05\u5355\u5165\u53e3", new Object[0]));
        List<BillVoucher> billVoucherList = this.billVoucherService.queryAllBillVoucher(companyCode, supCompanySapCode, startTime, endTime, null);
        this.logger.info(String.format("EVENT=\u5f00\u7968\u6e05\u5355\u51fa\u53e3", new Object[0]));
        Assert.isNotEmpty(billVoucherList, (String)"\u6682\u65f6\u8fd8\u6ca1\u6709\u5b58\u5728\u9700\u8981\u5bf9\u8d26\u7684\u5165\u9000\u5e93\u51ed\u8bc1\uff01");
        Bill bill = null;
        return bill;
    }

    @Override
    public Bill prepareForPur(Project project, User loginUser, Company company, List<BillVoucher> billVouchers, Date startTime, Date endTime) throws ParseException {
        Bill bill = new Bill();
        this.setPurCompanyInfo(project, bill);
        this.setSupCompanyInfo(company, bill);
        bill.setProjectId(project.getId());
        bill.setPurUserId(loginUser.getId());
        bill.setPurUserName(loginUser.getNickName());
        bill.setCreateTime(new Date());
        this.getNo(bill, "PO");
        bill = this.assembleForPur(bill, billVouchers, startTime, endTime);
        this.setBillItenInfo(billVouchers, bill);
        return bill;
    }

    private Bill assembleForPur(Bill bill, List<BillVoucher> billVoucherList, Date postingStartTime, Date postingEndTime) {
        bill.setPostingStartTime(postingStartTime);
        bill.setPostingEndTime(postingEndTime);
        bill.setIsEnable(Constant.YES_INT);
        bill.setPurSendStatus(BillSendStatus.NO_INT);
        bill.setSupConfirmStatus(BillStatusConfirmEnum.STATUS_UNCONFIRM.getConfirmStatus());
        bill.setSupConfirmBillStatus(Constant.NO_INT);
        bill.setSupSendStatus(BillSendStatus.NO);
        bill.setPurConfirmStatus(BillStatusConfirmEnum.STATUS_CONFIRM.getConfirmStatus());
        bill.setPurConfirmBillStatus(BillSendStatus.NO_INT);
        bill.setAbolishStatus(Constant.NO_INT);
        bill.setTaxCode(billVoucherList.get(0).getTaxCode());
        return bill;
    }

    private void setBillItenInfo(List<BillVoucher> voucherList, Bill bill) {
        ArrayList<BillItem> billItems = new ArrayList<BillItem>();
        voucherList.forEach(voucher -> {
            BillItem billItem = new BillItem();
            billItem.setPurCompanyId(bill.getPurCompanyId());
            billItem.setPurCompanySrmCode(bill.getPurCompanySrmCode());
            billItem.setPurCompanyName(bill.getPurCompanyName());
            billItem.setPurCompanyFullName(bill.getPurCompanyFullName());
            billItem.setSupCompanyId(bill.getSupCompanyId());
            billItem.setSupCompanyName(bill.getSupCompanyName());
            billItem.setSupCompanyFullName(bill.getSupCompanyFullName());
            billItem.setSupCompanySrmCode(bill.getSupCompanySrmCode());
            billItem.setDeliveryOrderNo(voucher.getDeliveryOrderNo());
            billItem.setDeliveryOrderItemNo(voucher.getDeliveryOrderItemNo());
            billItem.setPurchaseOrderNo(voucher.getPurchaseOrderNo());
            billItem.setPurchaseOrderItemNo(voucher.getPurchaseOrderItemNo());
            billItem.setMaterialId(voucher.getMaterialId());
            billItem.setMaterialNo(voucher.getMaterialNo());
            billItem.setMaterialDesc(voucher.getMaterialDesc());
            billItem.setMaterialQuantity(voucher.getMaterialQuantity());
            billItem.setMaterialVoucherNo(voucher.getMaterialVoucherNo());
            billItem.setMaterialVoucherItemNo(voucher.getMaterialVoucherItemNo());
            billItem.setBillFlag(Constant.YES_INT);
            billItem.setIsEnable(Constant.YES_INT);
            billItem.setTaxRate(voucher.getTaxRate());
            billItem.setNotIncludeTaxAmount(voucher.getNotIncludeTaxAmount());
            billItem.setIncludeTaxAmount(voucher.getIncludeTaxAmount());
            billItem.setTaxAmount(voucher.getTaxAmount());
            billItem.setLatestPrice(voucher.getLatestPrice());
            billItem.setOrderPrice(voucher.getOrderPrice());
            billItem.setOrderAmount(voucher.getOrderAmount());
            billItem.setBillInvoiceFlag(Constant.NO_INT);
            billItem.setTaxCode(voucher.getTaxCode());
            billItem.setMaterialUnit(voucher.getMaterialUnit());
            billItem.setInputDate(voucher.getInputDate());
            billItem.setStockSpaceCode(voucher.getStockSpaceCode());
            billItem.setStockSpaceRemark(voucher.getStockSpaceRemark());
            billItem.setCompany(voucher.getCompany());
            billItem.setQuantity(voucher.getQuantity());
            billItem.setUserName(voucher.getUserName());
            billItem.setPaymentWay(voucher.getPaymentWay());
            billItem.setMark(voucher.getMark());
            billItem.setPriceEntity(voucher.getPriceEntity());
            billItems.add(billItem);
        });
        bill.setBillItems(billItems);
    }

    private void getNo(Bill bill, String code) {
        String dateTime = DateFormatUtils.format((Date)bill.getCreateTime(), (String)"yyyyMM");
        int num = (int)((Math.random() * 9.0 + 1.0) * 100000.0);
        bill.setBillNo(String.format("%s%s%s", code, dateTime, num));
    }

    private String getNo(Bill bill, String comp, String supCompanySapCode) {
        String dateTime = DateFormatUtils.format((Date)bill.getCreateTime(), (String)"yyyyMM");
        String li = supCompanySapCode.substring(supCompanySapCode.length() - 4, supCompanySapCode.length());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andBillNoLike(dateTime + comp + li + "%");
        int i = this.billMapper.countByExample(billExample);
        return String.format("%s%s%s%02d", dateTime, comp, li, i + 1);
    }

    private void setSupCompanyInfo(Company supCompany, Bill bill) {
        bill.setSupCompanyId(supCompany.getId());
        bill.setSupCompanySrmCode(supCompany.getCompanyCode());
        bill.setSupCompanyName(supCompany.getCompanyName());
        bill.setSupCompanyFullName(supCompany.getCompanyFullName());
        bill.setSupComtactTelephone(supCompany.getTelephone());
        bill.setSupComtactUserName(supCompany.getContacts());
        bill.setSupCompanyAddress(supCompany.getAddress());
        bill.setPayConditionsCode(supCompany.getPayConditionsCode());
        bill.setPayConditionsDesc(supCompany.getPayConditionsDesc());
        bill.setAccountCode(supCompany.getInstitutionCode());
        bill.setAccountSetName(supCompany.getInstitutionName());
    }

    @Override
    public void prepareFilter(Bill bill) {
        Assert.isNotNull((Object)bill, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Date postingStartTime = bill.getPostingStartTime();
        Date postingEndTime = bill.getPostingEndTime();
        String companyCode = bill.getCompanyCode();
        Assert.isNotBlank((String)companyCode, (String)"\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)postingStartTime, (String)"\u51ed\u8bc1\u5f00\u59cb\u65e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)postingEndTime, (String)"\u51ed\u8bc1\u7ed3\u675f\u65e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    @CacheEvict(value={"bill"}, allEntries=true)
    public void addObj(Bill t) {
        this.billMapper.insertSelective(t);
    }

    @CacheEvict(value={"bill"}, allEntries=true)
    public void deleteObjById(String id) {
        this.billMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"bill"}, allEntries=true)
    public void modifyObj(Bill t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.billMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"bill"}, keyGenerator="redisKeyGenerator")
    public Bill queryObjById(String id) {
        return this.billMapper.selectByPrimaryKey(id);
    }

    public List<Bill> queryAllObjByExample(BillExample example) {
        return this.billMapper.selectByExample(example);
    }

    public PageView<Bill> queryObjByPage(BillExample example) {
        PageView<Bill> pageView = example.getPageView();
        pageView.setQueryResult(this.billMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"bill"}, allEntries=true)
    @Transactional
    public int updateByExampleSelective(Bill record, BillExample example) {
        return this.billMapper.updateByExampleSelective(record, example);
    }

    @Override
    public void updateByPrimaryKeySelective(Bill bill) {
        this.billMapper.updateByPrimaryKeySelective(bill);
    }

    @Override
    @CacheEvict(value={"bill"}, allEntries=true)
    public void modifyRemark(Bill bill) {
        Bill bi = new Bill();
        bi.setId(bill.getId());
        bi.setUpdateTime(new Date());
        bi.setPurRemark(bill.getPurRemark());
        bi.setSupRemark(bill.getSupRemark());
        bi.setPayConditionsCode(bill.getPayConditionsCode());
        bi.setPayConditionsDesc(bill.getPayConditionsDesc());
        this.billMapper.updateByPrimaryKeySelective(bi);
    }

    @Override
    public FileData print(String projectId, Company company, List<String> ids, String fontPathStr) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("id\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "id_is_blank");
        }
        BillExample example = new BillExample();
        example.createCriteria().andIdIn((List)ids).andSupConfirmStatusNotEqualTo(BillStatusConfirmEnum.STATUS_CONFIRM.getConfirmStatus());
        if (this.billMapper.countByExample(example) > 0) {
            throw new CommonException("\u53ea\u6709\u5df2\u786e\u8ba4\u7684\u5bf9\u8d26\u5355\u624d\u53ef\u4ee5\u6253\u5370!");
        }
        example.clear();
        example.createCriteria().andIdIn((List)ids);
        List<Bill> bills = this.billMapper.selectByExample(example);
        Assert.isNotEmpty(bills, (String)"\u6839\u636eid\u67e5\u8be2\u7684\u6253\u5370\u6570\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u6253\u5370!");
        ArrayList<CheckBillPrintVo> voList = new ArrayList<CheckBillPrintVo>();
        for (Bill bill : bills) {
            CheckBillPrintVo vo = new CheckBillPrintVo();
            this.logger.info("copy\u5bf9\u8d26\u5355\u5230checkBillPrintVo\u4e2d");
            BeanUtils.copyProperties((Object)bill, (Object)vo);
            BillItemExample itemExample = new BillItemExample();
            itemExample.createCriteria().andBillIdEqualTo(bill.getId()).andIsEnableEqualTo(Constant.YES_INT);
            List itemList = this.billItemService.queryAllObjByExample((IExample)itemExample);
            for (BillItem billItem : itemList) {
                billItem.setMaterialNo(billItem.getMaterialNo().replaceAll("^0+", ""));
                billItem.setOrderPrice(billItem.getOrderPrice().setScale(2, 4));
                billItem.setIncludeTaxAmount(billItem.getIncludeTaxAmount().setScale(2, 4));
            }
            vo.setBillItems(itemList);
            vo.setIncludeTaxAmount(vo.getIncludeTaxAmount().setScale(2, 4));
            Company com = this.companyService.queryCompanyBySapCode(bill.getSupCompanySapCode());
            String bankAccount = com.getBankAccount();
            String bankReferenceField = com.getBankReferenceField();
            if (StringUtils.isEmpty((String)bankReferenceField)) {
                com.setBankAccount(bankAccount);
            } else {
                com.setBankAccount(bankAccount + bankReferenceField);
            }
            vo.setCompany(com);
            if (vo.getDeductionAmount() == null) {
                vo.setDeductionAmount(new BigDecimal(0));
            }
            if (StringUtils.isEmpty((String)vo.getPayConditionsCode())) {
                throw new CommonException("\u4ed8\u6b3e\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5148\u7ef4\u62a4\u4ed8\u6b3e\u6761\u4ef6!");
            }
            ConditionsExample conditionsExample = new ConditionsExample();
            conditionsExample.createCriteria().andPayConditionsCodeEqualTo(vo.getPayConditionsCode());
            List conditions = this.conditionsService.queryAllObjByExample((IExample)conditionsExample);
            Assert.isNotEmpty((Collection)conditions, (String)"\u4ed8\u6b3e\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            vo.setPayConditionsDesc(((Conditions)conditions.get(0)).getPayConditionsDesc());
            BigDecimal scale = vo.getTotalAmount().subtract(vo.getDeductionAmount()).setScale(2, 4);
            NumberFormat form = NumberFormat.getNumberInstance();
            vo.setActAmount(form.format(scale));
            vo.setAmountInclude(form.format(vo.getIncludeTaxAmount()));
            vo.setAmountDecution(form.format(vo.getDeductionAmount()));
            vo.setBillNo(bill.getBillNo());
            voList.add(vo);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("company", ((CheckBillPrintVo)voList.get(0)).getCompany());
        params.put("vo", voList.get(0));
        params.put("fontPathStr", fontPathStr);
        this.logger.info("\u4f9b\u5e94\u5546\u53c2\u6570\u4e3a\uff1a", (Object)((CheckBillPrintVo)voList.get(0)).getCompany().toString());
        this.logger.info("\u5bf9\u8d26\u5355\u6253\u5370\u53c2\u6570\u4e3a[{}]", (Object)((Object)params).toString());
        FileData fileData = null;
        try {
            fileData = BillPrintUtils.generatePdf(projectId, ((CheckBillPrintVo)voList.get(0)).getCompany().getId(), params, "A4");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileData;
    }

    @Override
    public List<BillInvoiceExportExcelVo> getInvoiceList(String id) {
        ArrayList<BillInvoiceExportExcelVo> vos = new ArrayList<BillInvoiceExportExcelVo>();
        BillItemExample example = new BillItemExample();
        example.createCriteria().andBillIdEqualTo(id);
        List items = this.billItemService.queryAllObjByExample((IExample)example);
        this.logger.info(String.format("EVNET=\u5bf9\u8d26\u5355\u884c\u6570\u636e|RESULT=%s", json.toJson((Object)items)));
        Stream<BillInvoiceExportExcelVo> voStrem = items.stream().map(item -> {
            BillInvoiceExportExcelVo vo = new BillInvoiceExportExcelVo();
            vo.setMaterialUnit(item.getMaterialUnit());
            vo.setMaterialDesc(item.getMaterialDesc());
            vo.setMaterialQuantity(item.getMaterialQuantity());
            vo.setIncludeTaxAmount(item.getIncludeTaxAmount());
            vo.setTaxRate(item.getTaxRate());
            vo.setTaxAmount(item.getTaxAmount());
            TaxClassifyExample taxClassifyExample = new TaxClassifyExample();
            taxClassifyExample.createCriteria().andCustomerMaterialNoEqualTo(item.getMaterialNo());
            List list = this.taxClassifyService.queryAllObjByExample((IExample)taxClassifyExample);
            if (CollectionUtils.isEmpty((Collection)list)) {
                throw new CommonException("\u7269\u6599" + item.getMaterialNo() + "\u65e0\u7a0e\u52a1\u5206\u7c7b\u7801\uff0c\u8bf7\u5148\u7ef4\u62a4\u7a0e\u52a1\u5206\u7c7b\u7801\u518d\u5bfc\u51fa\u6a21\u677f\u3002");
            }
            TaxClassify taxClassify = (TaxClassify)list.get(0);
            Assert.isNotBlank((String)taxClassify.getCombinedTaxCode(), (String)("\u7269\u6599" + item.getMaterialNo() + "\u65e0\u7a0e\u52a1\u5206\u7c7b\u7801\uff0c\u8bf7\u5148\u7ef4\u62a4\u7a0e\u52a1\u5206\u7c7b\u7801\u518d\u5bfc\u51fa\u6a21\u677f\u3002"));
            vo.setGoodsandlaborName(taxClassify.getGoodsandlaborName());
            vo.setTaxCode(((TaxClassify)list.get(0)).getCombinedTaxCode());
            vo.setProductCode(item.getMaterialNo().replaceAll("^(0+)", ""));
            return vo;
        });
        Map<String, List<BillInvoiceExportExcelVo>> groupMap = voStrem.collect(Collectors.groupingBy(BillInvoiceExportExcelVo::getProductCode));
        Set<String> set = groupMap.keySet();
        for (String key : set) {
            List<BillInvoiceExportExcelVo> voList = groupMap.get(key);
            if (CollectionUtils.isEmpty(voList)) continue;
            if (voList.size() > 1) {
                BigDecimal materialQuantity = voList.stream().map(vo -> vo.getMaterialQuantity()).reduce((x, y) -> x.add((BigDecimal)y)).orElse(BigDecimal.ZERO);
                BigDecimal includeTaxAmount = voList.stream().map(vo -> vo.getIncludeTaxAmount()).reduce((x, y) -> x.add((BigDecimal)y)).orElse(BigDecimal.ZERO);
                BigDecimal taxAmount = voList.stream().map(vo -> vo.getTaxAmount()).reduce((x, y) -> x.add((BigDecimal)y)).orElse(BigDecimal.ZERO);
                BillInvoiceExportExcelVo vo2 = new BillInvoiceExportExcelVo();
                vo2.setMaterialQuantity(materialQuantity);
                vo2.setIncludeTaxAmount(includeTaxAmount);
                vo2.setTaxAmount(taxAmount);
                BillInvoiceExportExcelVo ivo = voList.get(0);
                vo2.setGoodsandlaborName(ivo.getGoodsandlaborName());
                vo2.setMaterialUnit(ivo.getMaterialUnit());
                vo2.setMaterialDesc(ivo.getMaterialDesc());
                vo2.setTaxRate(ivo.getTaxRate());
                vo2.setTaxCode(ivo.getTaxCode());
                vo2.setProductCode(ivo.getProductCode());
                vos.add(vo2);
                continue;
            }
            vos.add(voList.get(0));
        }
        return vos;
    }

    @CacheEvict(value={"bill"}, allEntries=true)
    public void deleteByExample(BillExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.billMapper.deleteByExample(example);
    }

    @CacheEvict(value={"bill"}, allEntries=true)
    @Transactional
    public void addAll(List<Bill> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.billMapper.insertSelective((Bill)record));
    }

    @Override
    @Cacheable(value={"bill"}, keyGenerator="redisKeyGenerator")
    public int countByExample(BillExample billExample) {
        return this.billMapper.countByExample(billExample);
    }

    @Override
    public PageView<Bill> findByPageForDistinct(BillExample example) {
        PageView<Bill> pageView = example.getPageView();
        pageView.setQueryResult(this.billMapper.selectByExtByPage(example));
        return pageView;
    }

    @Override
    public BillVo findBillById(String id) {
        Bill bill = this.queryObjById(id);
        List<BillItem> billItems = this.billItemService.queryBillVoucherList(id);
        return null;
    }

    @Override
    @CacheEvict(value={"bill"}, allEntries=true)
    @Transactional
    public void editBillInfo(BillVo billVo) {
        Bill bill = this.queryObjById(billVo.getId());
        if (null == bill) {
            throw new CommonException("\u5c1a\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5bf9\u8d26\u5355\u4fe1\u606f");
        }
        if (bill.getCreateBillType().equals(2)) {
            if ("1".equals(bill.getSupSendStatus())) {
                throw new CommonException("\u5355\u636e\u5df2\u53d1\u9001\uff0c\u4fee\u6539\u5931\u8d25");
            }
            if ("1".equals(bill.getSupConfirmBillStatus())) {
                throw new CommonException("\u5355\u636e\u5df2\u786e\u8ba4\u3002\u4fee\u6539\u5931\u8d25");
            }
            this.updateBillInfo(billVo);
        }
    }

    @Override
    public void confirmBill(String id, String type) {
        Bill bill = this.queryObjById(id);
        if ("pur".equals(type)) {
            if (null == bill) {
                throw new CommonException("\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!"1".equals(bill.getPurConfirmBillStatus())) {
                throw new CommonException("\u5355\u636e\u5c1a\u672a\u786e\u8ba4\u3002\u4fee\u6539\u5931\u8d25");
            }
            Bill b = new Bill();
            bill.setId(bill.getId());
            bill.setPurConfirmBillStatus(1);
            this.modifyObj(b);
        } else {
            if (null == bill) {
                throw new CommonException("\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!"1".equals(bill.getSupConfirmBillStatus())) {
                throw new CommonException("\u5355\u636e\u5c1a\u672a\u786e\u8ba4\u3002\u4fee\u6539\u5931\u8d25");
            }
            Bill b = new Bill();
            bill.setId(bill.getId());
            bill.setSupConfirmBillStatus(1);
            this.modifyObj(b);
        }
    }

    @Override
    public void sendBill(String id, String type) {
        if ("pur".equals(type)) {
            Bill bill = this.queryObjById(id);
            if (null == bill) {
                throw new CommonException("\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!"1".equals(bill.getPurConfirmBillStatus())) {
                throw new CommonException("\u5355\u636e\u5c1a\u672a\u786e\u8ba4\u3002\u4fee\u6539\u5931\u8d25");
            }
            if (!"1".equals(bill.getPurSendStatus())) {
                throw new CommonException("\u5355\u636e\u5df2\u53d1\u9001,\u64cd\u4f5c\u5931\u8d25");
            }
            Bill b = new Bill();
            bill.setId(bill.getId());
            bill.setPurSendStatus(1);
            this.modifyObj(b);
        } else {
            Bill bill = this.queryObjById(id);
            if (null == bill) {
                throw new CommonException("\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!"1".equals(bill.getSupConfirmBillStatus())) {
                throw new CommonException("\u5355\u636e\u5c1a\u672a\u786e\u8ba4\u3002\u4fee\u6539\u5931\u8d25");
            }
            if (!"1".equals(bill.getSupSendStatus())) {
                throw new CommonException("\u5355\u636e\u5df2\u53d1\u9001,\u64cd\u4f5c\u5931\u8d25");
            }
            Bill b = new Bill();
            bill.setId(bill.getId());
            bill.setSupSendStatus(1);
            this.modifyObj(b);
        }
    }

    private void updateBillInfo(BillVo billVo) {
        Bill b = new Bill();
        b.setId(billVo.getId());
        List ids = billVo.getBillVoucherList().stream().map(item -> item.getId()).collect(Collectors.toList());
        BillItemExample billItemExample = new BillItemExample();
        billItemExample.createCriteria().andIdIn(ids);
        this.billItemService.deleteByExample((IExample)billItemExample);
        this.billItemService.addAll(billVo.getBillItems());
        CalculateBillUtil.calculateAmount(b, billVo.getBillVoucherList());
        this.billMapper.updateByPrimaryKeySelective(b);
    }
}

