/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.utils;

import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.utils.pdf.HtmlToPdfParam;
import com.els.base.utils.pdf.HtmlToPdfUtils;
import com.els.base.utils.template.BeetlTemplateUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BillPrintUtils {
    private static final Logger log = LoggerFactory.getLogger(BillPrintUtils.class);

    public static FileData generatePdf(String projectId, String companyId, Map<String, Object> params, String printType) throws Exception {
        log.debug("\u3010\u5bf9\u8d26\u5355\u6253\u53701\u3011");
        String headerPath = BeetlTemplateUtils.renderFromFile((String)"checkedBillHeader.html", params);
        String html = BeetlTemplateUtils.renderFromFile((String)"checkedBillContent.html", params);
        log.debug("\u3010\u5bf9\u8d26\u5355\u6253\u53702\u3011");
        log.info(headerPath);
        log.info(html);
        String filename = String.format("\u8d22\u52a1\u5bf9\u8d26\u5355\u6253\u5370_%s_%s", "A4", DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd-HH-mm"));
        FileData pdfFile = BillPrintUtils.createEmptyPDF(projectId, companyId, filename);
        log.debug("\u3010\u5bf9\u8d26\u5355\u6253\u53703\u3011");
        HtmlToPdfParam param = new HtmlToPdfParam();
        param.setHeaderHtml(headerPath);
        param.setMarginTop("40mm");
        param.setMarginLeft("10mm");
        param.setMarginRight("10mm");
        param.setTitle(filename);
        param.setPageSize("A4");
        param.setVertical(false);
        param.setHeaderSpacing("2");
        HtmlToPdfUtils.generatePdf((String)html, (File)pdfFile.toFile(), (HtmlToPdfParam)param);
        log.debug("\u3010\u5bf9\u8d26\u5355\u6253\u53704\u3011");
        return pdfFile;
    }

    private static FileData createEmptyPDF(String projectId, String companyId, String fileName) throws IOException {
        FileData pdfFile = new FileData();
        pdfFile.setProjectId(projectId);
        pdfFile.setCompanyId(companyId);
        pdfFile.setFileName(fileName + ".pdf");
        pdfFile.setFileSuffix("pdf");
        pdfFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
        pdfFile.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
        pdfFile = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), pdfFile);
        return pdfFile;
    }
}

