/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.dealings.controller;

import com.els.base.common.ExcelFileData;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.dealings.entity.BillDealings;
import com.els.base.dealings.entity.BillDealingsExample;
import com.els.base.dealings.service.BillDealingsService;
import com.els.base.file.entity.FileData;
import com.els.base.finance.service.SapBillService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.json.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u5f80\u6765\u8d26"})
@Controller
@RequestMapping(value={"billDealings"})
public class BillDealingsController {
    @Resource
    protected BillDealingsService billDealingsService;
    @Resource
    protected SapBillService sapBillService;

    @ApiOperation(httpMethod="POST", value="\u83b7\u53d6\u5f80\u6765\u8d26")
    @RequestMapping(value={"service/importByDealings"})
    @ResponseBody
    public ResponseResult<String> importByDealings(String startTime, String endTime) throws ParseException {
        this.sapBillService.importByDealings(DateUtils.parseDate((String)startTime, (String[])new String[]{"yyyy-MM-dd"}), DateUtils.parseDate((String)endTime, (String[])new String[]{"yyyy-MM-dd"}));
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5bfc\u51faExcel", httpMethod="POST")
    @RequestMapping(value={"service/downloadExcelForSupCompanyVer"})
    @ResponseBody
    public ResponseResult<FileData> exportForPurCompanyVerDownload(@RequestBody(required=false) List<String> ids, String queryParams) throws Exception {
        BillDealingsExample example = new BillDealingsExample();
        BillDealingsExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotEmpty((String)queryParams)) {
            QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParamWapper);
        }
        List details = null;
        if (CollectionUtils.isNotEmpty(ids)) {
            criteria.andIdIn((List)ids);
            details = this.billDealingsService.queryAllObjByExample((IExample)example);
        } else {
            if (CompanyUtils.isSupCompany()) {
                criteria.andSupCompanySapCodeIn(CompanyUtils.currentCompany().getCompanySapCodeList());
            }
            details = this.billDealingsService.queryAllObjByExample((IExample)example);
        }
        for (BillDealings billDealings : details) {
            if (StringUtils.isEmpty((String)billDealings.getClearingMark())) {
                billDealings.setProjectId("\u672a\u6e05\u8d26");
                continue;
            }
            billDealings.setProjectId("\u5df2\u6e05\u8d26");
        }
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeaderColumn();
        FileData fileData = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, details, "\u5f80\u6765\u8d26\u660e\u7ec6", "\u5f80\u6765\u8d26\u660e\u7ec6", 0);
        return ResponseResult.success((Object)fileData);
    }

    private List<TitleAndModelKey> createExcelHeaderColumn() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6e05\u8d26\u6807\u8bc6", (String)"projectId"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u516c\u53f8\u4ee3\u7801", (String)"companyCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u516c\u53f8\u540d\u79f0", (String)"companyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546sap\u7f16\u7801", (String)"supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanySapName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8fc7\u8d26\u65e5\u671f", (String)"postingDate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u51ed\u8bc1\u7c7b\u578b", (String)"voucherType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f1a\u8ba1\u79d1\u76ee", (String)"subject"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f1a\u8ba1\u79d1\u76ee\u63cf\u8ff0", (String)"subjectRemark"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u51ed\u8bc1\u7f16\u53f7", (String)"voucherNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u501f\u8d37\u65b9\u5411", (String)"direction"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u672c\u5e01\u91d1\u989d", (String)"localCurrencyPrice"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u672c\u5e01", (String)"localCurrency"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"remark"));
        return titleAndModelKeys;
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5f80\u6765\u8d26")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BillDealings", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BillDealings>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BillDealingsExample example = new BillDealingsExample();
        example.setPageView((PageView<BillDealings>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        BillDealingsExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andPurCompanyIdEqualTo(ProjectUtils.getCompanyId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.billDealingsService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5f80\u6765\u8d26")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BillDealings", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BillDealings>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BillDealingsExample example = new BillDealingsExample();
        example.setPageView((PageView<BillDealings>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        BillDealingsExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.billDealingsService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

