/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.deduction.service.impl;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.DepartmentService;
import com.els.base.company.web.vo.DepartmentExcelVO;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.deduction.dao.DeductionMapper;
import com.els.base.deduction.entity.Deduction;
import com.els.base.deduction.entity.DeductionExample;
import com.els.base.deduction.enums.DeductionBillTypeEnum;
import com.els.base.deduction.service.DeductionService;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultDeductionService")
public class DeductionServiceImpl
implements DeductionService {
    @Resource
    protected DeductionMapper deductionMapper;
    @Resource
    protected GenerateCodeService codeService;
    @Resource
    private DepartmentService departmentService;
    @Resource
    protected CompanyService companyService;

    @CacheEvict(value={"deduction"}, allEntries=true)
    public void addObj(Deduction t) {
        this.deductionMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"deduction"}, allEntries=true)
    public void addAll(List<Deduction> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.deductionMapper.insertBatch(list);
    }

    @CacheEvict(value={"deduction"}, allEntries=true)
    public void deleteObjById(String id) {
        this.deductionMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"deduction"}, allEntries=true)
    public void deleteByExample(DeductionExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.deductionMapper.deleteByExample(example);
    }

    @CacheEvict(value={"deduction"}, allEntries=true)
    public void modifyObj(Deduction t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.deductionMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"deduction"}, keyGenerator="redisKeyGenerator")
    public Deduction queryObjById(String id) {
        return this.deductionMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"deduction"}, keyGenerator="redisKeyGenerator")
    public List<Deduction> queryAllObjByExample(DeductionExample example) {
        return this.deductionMapper.selectByExample(example);
    }

    @Cacheable(value={"deduction"}, keyGenerator="redisKeyGenerator")
    public PageView<Deduction> queryObjByPage(DeductionExample example) {
        PageView<Deduction> pageView = example.getPageView();
        pageView.setQueryResult(this.deductionMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"deduction"}, allEntries=true)
    public void insert(Deduction deduction, Company company, User user) {
        this.valid(deduction);
        this.complete(deduction, company, user);
        this.addObj(deduction);
    }

    @Deprecated
    private void complete(Deduction deduction, Company company, User user) {
    }

    @Deprecated
    private void valid(Deduction deduction) {
        Assert.isNotBlank((String)deduction.getCompanyCode(), (String)"\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)deduction.getCompanyName(), (String)"\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)deduction.getSupCompanyFullName(), (String)"\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)deduction.getDeductionDate(), (String)"\u6263\u6b3e\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)deduction.getDeductionAmount(), (String)"\u6263\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    @CacheEvict(value={"deduction"}, allEntries=true)
    public void modify(Deduction deduction, User user) {
        this.valid(deduction);
        this.complete(deduction, user);
        this.modifyObj(deduction);
    }

    @Override
    public Deduction addObj(DeliveryOrder deliveryOrder, DeliveryOrderItem deliveryOrderItem, String userName) {
        Deduction deduction = new Deduction();
        this.setDeliveryOrderInfo(deliveryOrder, deduction);
        this.setDepartmentInfo(deduction);
        this.setDeliveryOrderItemInfo(deliveryOrderItem, deduction);
        deduction.setIsEnable(Constant.YES_INT);
        deduction.setOperateUser(userName);
        deduction.setOperateDate(new Date());
        deduction.setCreateTime(new Date());
        deduction.setCreateUserName(userName);
        deduction.setDeductionNo(this.codeService.getNextCode("DEDUCTION_NO_CODE"));
        this.addObj(deduction);
        return deduction;
    }

    private void setDepartmentInfo(Deduction deduction) {
        if (StringUtils.isBlank((String)deduction.getDepartId())) {
            throw new CommonException("\u90e8\u95e8id\u80fd\u4e3a\u7a7a\uff0c\u6263\u6b3e\u9879\u8bbe\u7f6e\u5931\u8d25");
        }
        DepartmentExcelVO excelVO = this.departmentService.getDepartmentExcelVO(deduction.getDepartId());
        deduction.setTotalGroupId(excelVO.getTotalGroupId());
        deduction.setTotalGroupName(excelVO.getTotalGroupName());
        deduction.setAccountSetId(excelVO.getAccountSetId());
        deduction.setAccountSetName(excelVO.getAccountSetName());
        deduction.setAccountCode(excelVO.getAccountCode());
        deduction.setInstitutionsId(excelVO.getInstitutionsId());
        deduction.setInstitutionsName(excelVO.getInstitutionsName());
        deduction.setInTheOrganizationId(excelVO.getInTheOrganizationId());
        deduction.setInTheOrganizationName(excelVO.getInTheOrganizationName());
    }

    private void setDeliveryOrderInfo(DeliveryOrder deliveryOrder, Deduction deduction) {
        if (deliveryOrder == null) {
            throw new CommonException("\u6536\u8d27\u6570\u636e\u5934\u4fe1\u606f\u4e3a\u7a7a\u3002\u64cd\u4f5c\u5931\u8d25");
        }
        deduction.setProjectId(deliveryOrder.getProjectId());
        deduction.setPurCompanyId(deliveryOrder.getPurCompanyId());
        deduction.setPurCompanySrmCode("");
        deduction.setPurCompanyFullName("");
        deduction.setPurCompanyName(deliveryOrder.getPurCompanyName());
        deduction.setSupCompanyId("");
        deduction.setSupCompanySrmCode("");
        deduction.setBillFlag(Constant.NO_INT);
        deduction.setCompanyCode(deliveryOrder.getCompanyCode());
        deduction.setCompanyName(deliveryOrder.getCompanyName());
        deduction.setDepartId(deliveryOrder.getDepartId());
        deduction.setDepartName(deliveryOrder.getDepartName());
    }

    private void setDeliveryOrderItemInfo(DeliveryOrderItem deliveryOrderItem, Deduction deduction) {
        if (deliveryOrderItem == null) {
            throw new CommonException("\u6536\u8d27\u6570\u636e\u884c\u4fe1\u606f\u4e3a\u7a7a\u3002\u64cd\u4f5c\u5931\u8d25");
        }
        deduction.setDeductionAmount(deliveryOrderItem.getReceivedAmount());
        deduction.setCurrencyType(deliveryOrderItem.getCurrency());
        deduction.setBillType(DeductionBillTypeEnum.PO.getCode());
        deduction.setDeliveryOrderId(deliveryOrderItem.getDeliveryOrderId());
        deduction.setDeliveryOrderItemId(deliveryOrderItem.getId());
    }

    @Deprecated
    private void complete(Deduction deduction, User user) {
    }
}

