/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.info.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.info.dao.UserInfoMapper;
import com.els.base.info.entity.UserInfo;
import com.els.base.info.entity.UserInfoExample;
import com.els.base.info.service.UserInfoService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultUserInfoService")
public class UserInfoServiceImpl
implements UserInfoService {
    @Resource
    protected UserInfoMapper userInfoMapper;

    @CacheEvict(value={"userInfo"}, allEntries=true)
    public void addObj(UserInfo t) {
        this.userInfoMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"userInfo"}, allEntries=true)
    public void addAll(List<UserInfo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.userInfoMapper.insertBatch(list);
    }

    @CacheEvict(value={"userInfo"}, allEntries=true)
    public void deleteObjById(String id) {
        this.userInfoMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"userInfo"}, allEntries=true)
    public void deleteByExample(UserInfoExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.userInfoMapper.deleteByExample(example);
    }

    @CacheEvict(value={"userInfo"}, allEntries=true)
    public void modifyObj(UserInfo t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.userInfoMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"userInfo"}, keyGenerator="redisKeyGenerator")
    public UserInfo queryObjById(String id) {
        return this.userInfoMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"userInfo"}, keyGenerator="redisKeyGenerator")
    public List<UserInfo> queryAllObjByExample(UserInfoExample example) {
        return this.userInfoMapper.selectByExample(example);
    }

    @Cacheable(value={"userInfo"}, keyGenerator="redisKeyGenerator")
    public PageView<UserInfo> queryObjByPage(UserInfoExample example) {
        PageView<UserInfo> pageView = example.getPageView();
        pageView.setQueryResult(this.userInfoMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"userInfo"}, allEntries=true)
    public void insert(UserInfo userInfo, User loginUser) {
        this.info(userInfo);
        this.exist(userInfo);
        userInfo.setCreateTime(new Date());
        userInfo.setCreateUser(loginUser.getNickName());
        userInfo.setIsEnable(Constant.YES_INT);
        this.addObj(userInfo);
    }

    private void exist(UserInfo userInfo) {
        UserInfoExample example = new UserInfoExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
        List<UserInfo> list = this.userInfoMapper.selectByExample(example);
        List userInfos = list.stream().filter(i -> userInfo.getBillContact().equals(i.getBillContact()) && userInfo.getCompanyCode().equals(i.getCompanyCode()) && userInfo.getReceiveUser().equals(i.getReceiveUser())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(userInfos)) {
            throw new CommonException("\u5bf9\u8d26\u8054\u7cfb\u4eba:" + userInfo.getBillContact() + "\u3001\u516c\u53f8\u4ee3\u7801:" + userInfo.getCompanyCode() + "\u3001\u90ae\u5bc4\u6536\u4ef6\u4eba:" + userInfo.getReceiveUser() + "\u5df2\u5b58\u5728,\u4fdd\u5b58\u5931\u8d25\uff01");
        }
    }

    private void info(UserInfo userInfo) {
        Assert.isNotBlank((String)userInfo.getBillContact(), (String)"\u5bf9\u8d26\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)userInfo.getBillContactTel(), (String)"\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)userInfo.getBusinessType(), (String)"\u4e1a\u52a1\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)userInfo.getInvoiceAddress(), (String)"\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)userInfo.getReceiveUser(), (String)"\u90ae\u4ef6\u6536\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)userInfo.getReceiveUserTel(), (String)"\u6536\u4ef6\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)userInfo.getCompanyCode(), (String)"\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    @Override
    @CacheEvict(value={"userInfo"}, allEntries=true)
    public void modify(UserInfo userInfo, User loginUser) {
        this.deleteObjById(userInfo.getId());
        this.exist(userInfo);
        this.info(userInfo);
        userInfo.setUpdateTime(new Date());
        userInfo.setUpdateUser(loginUser.getNickName());
        userInfo.setIsEnable(Constant.YES_INT);
        this.addObj(userInfo);
    }

    @Override
    @CacheEvict(value={"userInfo"}, allEntries=true)
    public void delete(List<String> ids) {
        UserInfoExample example = new UserInfoExample();
        example.createCriteria().andIdIn((List)ids);
        UserInfo userInfo = new UserInfo();
        userInfo.setIsEnable(Constant.NO_INT);
        this.userInfoMapper.updateByExampleSelective(userInfo, example);
    }
}

