/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.invoice.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bill.entity.BillItem;
import com.els.base.bill.service.BillItemService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParam;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.invoice.entity.BillInvoice;
import com.els.base.invoice.entity.BillInvoiceExample;
import com.els.base.invoice.service.BillInvoiceService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u9884\u5236\u53d1\u7968"})
@Controller
@RequestMapping(value={"billInvoice"})
public class BillInvoiceController {
    @Resource
    protected BillInvoiceService billInvoiceService;
    @Resource
    protected BillItemService billItemService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u9884\u5236\u53d1\u7968")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BillInvoice billInvoice) {
        this.billInvoiceService.create(ProjectUtils.getProject(), CompanyUtils.currentCompany(), CompanyUtils.isPurCompany(), SpringSecurityUtils.getLoginUser(), billInvoice);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u9884\u5236\u53d1\u7968")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BillInvoice billInvoice) {
        Assert.isNotBlank((String)billInvoice.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.billInvoiceService.edit(ProjectUtils.getProject(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), billInvoice);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u9884\u5236\u53d1\u7968")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.billInvoiceService.deleteObjByIds(Arrays.asList(id), CompanyUtils.isPurCompany());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u9884\u5236\u53d1\u7968")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.billInvoiceService.deleteObjByIds(ids, CompanyUtils.isPurCompany());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u9884\u5236\u53d1\u7968(\u91c7\u8d2d\u5546\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BillInvoice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForPur"})
    @ResponseBody
    public ResponseResult<PageView<BillInvoice>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BillInvoiceExample example = new BillInvoiceExample();
        example.setPageView((PageView<BillInvoice>)new PageView(pageNo, pageSize));
        example.createCriteria().andIsBackEqualTo(Constant.NO_INT).andInvoiceDistributionIsNull();
        example.or().andIsBackEqualTo(Constant.NO_INT).andInvoiceDistributionEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.billInvoiceService.queryObjByPage((IExample)example);
        pageData.setQueryResult(this.queryList(pageData.getQueryResult()));
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u9884\u5236\u53d1\u7968(\u4f9b\u5e94\u5546\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BillInvoice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForSup"})
    @ResponseBody
    public ResponseResult<PageView<BillInvoice>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BillInvoiceExample example = new BillInvoiceExample();
        example.setPageView((PageView<BillInvoice>)new PageView(pageNo, pageSize));
        example.createCriteria().andInvoiceDistributionIsNull();
        example.or().andInvoiceDistributionEqualTo("0");
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.billInvoiceService.queryObjByPage((IExample)example);
        pageData.setQueryResult(this.queryList(pageData.getQueryResult()));
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u67e5\u8be2\u5168\u90e8\u9884\u5236\u53d1\u7968")
    @ApiImplicitParams(value={@ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BillInvoice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findAll"})
    @ResponseBody
    public ResponseResult<List<BillInvoice>> findAll(@RequestBody(required=false) QueryParamWapper wapper) {
        BillInvoiceExample example = new BillInvoiceExample();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        List billInvoices = this.billInvoiceService.queryAllObjByExample((IExample)example);
        return ResponseResult.success(this.queryList(billInvoices));
    }

    private List<BillInvoice> queryList(List<BillInvoice> billInvoices) {
        ArrayList<BillInvoice> billInvoicesTemp = new ArrayList<BillInvoice>();
        if (CollectionUtils.isEmpty(billInvoices)) {
            return billInvoicesTemp;
        }
        for (BillInvoice billInvoice : billInvoices) {
            List<BillItem> billItems = this.billItemService.queryBillVoucherList(billInvoice.getId());
            billInvoice.setBillVoucherList(billItems);
            billInvoicesTemp.add(billInvoice);
        }
        return billInvoicesTemp;
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u5bf9\u8d26\u5355\u53d1\u7968\u4e1a\u52a1\u8303\u56f4")
    @RequestMapping(value={"service/findbusiness"})
    @ResponseBody
    public ResponseResult<List<String>> findbusiness(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) List<QueryParam> queryParams) {
        ArrayList businessList = Lists.newArrayList();
        businessList.add("C001-\u539f\u6750\u6599");
        businessList.add("C002-\u5305\u6750");
        businessList.add("C003-OEM");
        businessList.add("C004-\u5176\u4ed6");
        businessList.add("C005-\u8d44\u4ea7\u8d2d\u7f6e\u3001 \u4f4e\u503c\u6613\u8017\u54c1");
        businessList.add("C006-\u5e7f\u5ba3\u7269\u6599");
        businessList.add("C007-\u8fd0\u8f93\u8d39\u7528");
        return ResponseResult.success((Object)businessList);
    }
}

