/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.invoice.service.impl;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.bill.entity.BillItem;
import com.els.base.bill.entity.BillItemExample;
import com.els.base.bill.service.BillItemService;
import com.els.base.bill.service.BillService;
import com.els.base.bill.utils.CalculateBillUtil;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.invoice.dao.BillInvoiceMapper;
import com.els.base.invoice.entity.BillInvoice;
import com.els.base.invoice.entity.BillInvoiceExample;
import com.els.base.invoice.service.BillInvoiceService;
import com.els.base.supGroup.entity.SupGroupRef;
import com.els.base.supGroup.entity.SupGroupRefExample;
import com.els.base.supGroup.service.SupGroupRefService;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBillInvoiceService")
public class BillInvoiceServiceImpl
implements BillInvoiceService {
    Logger logger = LoggerFactory.getLogger(BillInvoiceServiceImpl.class);
    @Resource
    protected BillInvoiceMapper billInvoiceMapper;
    @Resource
    protected BillItemService billItemService;
    @Resource
    protected BillService billServie;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected SupGroupRefService supGroupRefService;

    @Override
    @Cacheable(value={"billInvoice"}, keyGenerator="redisKeyGenerator")
    @Transactional
    public List<BillInvoice> queryByBillId(String billId) {
        Assert.isNotBlank((String)billId, (String)"\u53d1\u7968ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BillInvoiceExample billInvoiceExample = new BillInvoiceExample();
        billInvoiceExample.createCriteria().andBillIdEqualTo(billId);
        return this.billInvoiceMapper.selectByExample(billInvoiceExample);
    }

    @Override
    @CacheEvict(value={"billInvoice"}, allEntries=true)
    @Transactional
    public void edit(Project project, Company company, User loginUser, BillInvoice billInvoice) {
        this.editBillInvoiceFilter(billInvoice);
        this.billInvoiceMapper.updateByPrimaryKeySelective(billInvoice);
    }

    private void editBillInvoiceFilter(BillInvoice billInvoice) {
        Assert.isNotNull((Object)billInvoice, (String)"\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)billInvoice.getId(), (String)"\u53d1\u7968ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)billInvoice.getBillId(), (String)"\u5f00\u7968\u6e05\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)billInvoice.getInvoiceNo(), (String)"\u53d1\u7968\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BillInvoiceExample billInvoiceExample = new BillInvoiceExample();
        billInvoiceExample.createCriteria().andInvoiceNoEqualTo(billInvoice.getInvoiceNo()).andIdNotEqualTo(billInvoice.getId());
        int i = this.billInvoiceMapper.countByExample(billInvoiceExample);
        if (i > 0) {
            throw new CommonException("\u53d1\u7968\u53f7\u5df2\u7ecf\u5b58\u5728\u4e86\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }

    @Override
    @CacheEvict(value={"billInvoice"}, allEntries=true)
    @Transactional
    public void create(Project project, Company company, boolean purCompany, User loginUser, BillInvoice billInvoice) {
        if (purCompany) {
            billInvoice.setInvoiceDistribution("1");
        }
        this.createBillInvoiceFilter(billInvoice);
        this.initBillInvoice(billInvoice, purCompany);
        this.billInvoiceMapper.insertSelective(billInvoice);
        this.updateBillItemForInvoiceCreate(billInvoice, Constant.YES_INT, purCompany);
    }

    private void initBillInvoice(BillInvoice billInvoice, boolean purCompany) {
        if (CollectionUtils.isEmpty(billInvoice.getBillVoucherList())) {
            BillItemExample example = new BillItemExample();
            example.createCriteria().andBillIdEqualTo(billInvoice.getBillId()).andIsEnableEqualTo(Constant.YES_INT);
            List items = this.billItemService.queryAllObjByExample((IExample)example);
            billInvoice.setBillVoucherList(items);
        }
        List<BillItem> billVoucherList = billInvoice.getBillVoucherList();
        this.exist(billVoucherList);
        BillItem billItem1 = billVoucherList.get(0);
        billInvoice.setTaxRate(billItem1.getTaxRate());
        billInvoice.setTaxCode(billItem1.getTaxCode());
        billInvoice.setCurrencyType(billItem1.getCurrencyType());
        billInvoice.setCreateTime(new Date());
        if (purCompany) {
            billInvoice.setIsBack(Constant.NO_INT);
        } else {
            billInvoice.setIsBack(Constant.YES_INT);
        }
        CalculateBillUtil.calculateInvoiceAmount(billInvoice, billVoucherList);
    }

    private void exist(List<BillItem> billVoucherList) {
        for (BillItem billItem : billVoucherList) {
            List list2;
            List list;
            if ("122".equals(billItem.getBillType()) || "102".equals(billItem.getBillType())) {
                list = billVoucherList.stream().filter(i -> i.getVoucherNo().equals(billItem.getVoucherNo()) && i.getVoucherProject().equals(billItem.getVoucherProject())).collect(Collectors.toList());
                list2 = list.stream().filter(i -> "101".equals(i.getBillType())).collect(Collectors.toList());
                Assert.isNotEmpty(list2, (String)(billItem.getVoucherNo() + "\uff08\u53c2\u8003\u51ed\u8bc1\u53f7\uff09" + billItem.getVoucherProject() + "(\u884c\u53f7),\u51b2\u9500\u51ed\u8bc1\u4e0e\u539f\u51ed\u8bc1\u4e0d\u80fd\u62c6\u5206\u8fc7\u8d26"));
            }
            if ("162".equals(billItem.getBillType())) {
                list = billVoucherList.stream().filter(i -> i.getVoucherNo().equals(billItem.getVoucherNo()) && i.getVoucherProject().equals(billItem.getVoucherProject())).collect(Collectors.toList());
                list2 = list.stream().filter(i -> "161".equals(i.getBillType())).collect(Collectors.toList());
                Assert.isNotEmpty(list2, (String)(billItem.getVoucherNo() + "\uff08\u53c2\u8003\u51ed\u8bc1\u53f7\uff09" + billItem.getVoucherProject() + "(\u884c\u53f7),\u51b2\u9500\u51ed\u8bc1\u4e0e\u539f\u51ed\u8bc1\u4e0d\u80fd\u62c6\u5206\u8fc7\u8d26"));
            }
            if (!"123".equals(billItem.getBillType())) continue;
            List items = billVoucherList.stream().filter(i -> i.getVoucherNo().equals(billItem.getVoucherNo()) && i.getVoucherProject().equals(billItem.getVoucherProject())).collect(Collectors.toList());
            Assert.isNotEmpty(items, (String)(billItem.getVoucherNo() + "\uff08\u53c2\u8003\u51ed\u8bc1\u53f7\uff09" + billItem.getVoucherProject() + "(\u884c\u53f7),\u51b2\u9500\u51ed\u8bc1\u4e0e\u539f\u51ed\u8bc1\u4e0d\u80fd\u62c6\u5206\u8fc7\u8d26"));
            List itemss = items.stream().filter(i -> "122".equals(i.getBillType())).collect(Collectors.toList());
            Assert.isNotEmpty(itemss, (String)(billItem.getVoucherNo() + "\uff08\u53c2\u8003\u51ed\u8bc1\u53f7\uff09" + billItem.getVoucherProject() + "(\u884c\u53f7),\u51b2\u9500\u51ed\u8bc1\u4e0e\u539f\u51ed\u8bc1\u4e0d\u80fd\u62c6\u5206\u8fc7\u8d26"));
        }
    }

    private void createBillInvoiceFilter(BillInvoice billInvoice) {
        Assert.isNotNull((Object)billInvoice, (String)"\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)billInvoice.getBillId(), (String)"\u5f00\u7968\u6e05\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)billInvoice.getInvoiceNo(), (String)"\u53d1\u7968\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)billInvoice.getInvoiceTime(), (String)"\u53d1\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BillInvoiceExample billInvoiceExample = new BillInvoiceExample();
        billInvoiceExample.createCriteria().andInvoiceNoEqualTo(billInvoice.getInvoiceNo());
        int i = this.billInvoiceMapper.countByExample(billInvoiceExample);
        if (i > 0) {
            throw new CommonException("\u53d1\u7968\u53f7\u5df2\u7ecf\u5b58\u5728\u4e86\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        BillExample example = new BillExample();
        example.createCriteria().andBillNoEqualTo(billInvoice.getBillNo());
        Bill bill = (Bill)this.billServie.queryAllObjByExample((IExample)example).get(0);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(bill.getPostingEndTime());
        calendar.set(2, calendar.get(2));
        String sr = format.format(calendar.getTime());
        Company company = (Company)this.companyService.queryObjById((Object)bill.getSupCompanyId());
        String invoiceNo = billInvoice.getInvoiceNo();
        String substring = null;
        substring = invoiceNo.length() < 8 ? invoiceNo : invoiceNo.substring(0, 8);
        String tinvoice = "\u6536\u53d1\u7968";
        String supAccountGroup = company.getSupAccountGroup();
        SupGroupRefExample refExample = new SupGroupRefExample();
        refExample.createCriteria().andAccountGroupEqualTo(supAccountGroup);
        List refs = this.supGroupRefService.queryAllObjByExample((IExample)refExample);
        String comref = null;
        comref = CollectionUtils.isEmpty((Collection)refs) ? "-" : "-" + ((SupGroupRef)refs.get(0)).getAccountGroupDesc();
        billInvoice.setInvoiceTitle(tinvoice + sr + bill.getSupCompanyName() + comref + substring);
    }

    private void updateBillItemForInvoiceCreate(BillInvoice billInvoice, Integer flag, boolean purCompany) {
        this.logger.info("\u4e00\u3001\u4fee\u6539\u5165\u9000\u5e93\u72b6\u6001");
        List<BillItem> billVoucherList = billInvoice.getBillVoucherList();
        Assert.isNotEmpty(billVoucherList, (String)"\u5165\u9000\u5e93\u51ed\u8bc1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (BillItem billItem : billVoucherList) {
            billItem.setBillInvoiceId(billInvoice.getId());
            billItem.setBillInvoiceFlag(flag);
            this.billItemService.modifyObj(billItem);
            BillItemExample itemExample = new BillItemExample();
            itemExample.createCriteria().andIdEqualTo(billItem.getId());
            BillItem item = new BillItem();
            item.setBillInvoiceFlag(Constant.YES_INT);
            if (purCompany) {
                item.setProjectTypes("1");
            }
            this.billItemService.updateByExampleSelective(item, itemExample);
        }
    }

    @Override
    @CacheEvict(value={"billInvoice"}, allEntries=true)
    @Transactional
    public void deleteObjByIds(List<String> ids, boolean purCompany) {
        BillInvoiceExample billInvoiceExample = new BillInvoiceExample();
        billInvoiceExample.createCriteria().andIdIn((List)ids);
        List<BillInvoice> billInvoices = this.billInvoiceMapper.selectByExample(billInvoiceExample);
        Assert.isNotEmpty(billInvoices, (String)"\u53d1\u7968\u4fe1\u606f\u4e0d\u5b58\u5728");
        for (BillInvoice billInvoice : billInvoices) {
            if (purCompany) {
                if (StringUtils.isEmpty((String)billInvoice.getInvoiceDistribution())) {
                    BillInvoice invoice = new BillInvoice();
                    invoice.setInvoiceDistribution("0");
                    this.billInvoiceMapper.updateByExampleSelective(invoice, billInvoiceExample);
                    this.InvoiceDeleteForPur(billInvoice);
                    continue;
                }
                this.InvoiceDeleteForPur(billInvoice);
                this.billInvoiceMapper.deleteByExample(billInvoiceExample);
                continue;
            }
            this.updateBillItemForInvoiceDelete(billInvoice, Constant.NO_INT);
            this.billInvoiceMapper.deleteByExample(billInvoiceExample);
        }
    }

    private void InvoiceDeleteForPur(BillInvoice billInvoice) {
        Assert.isNotBlank((String)billInvoice.getId(), (String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BillItemExample billItemExample = new BillItemExample();
        billItemExample.createCriteria().andBillInvoiceIdEqualTo(billInvoice.getId()).andIsEnableEqualTo(Constant.YES_INT);
        List billItems = this.billItemService.queryAllObjByExample((IExample)billItemExample);
        if (CollectionUtils.isNotEmpty((Collection)billItems)) {
            for (BillItem billItem : billItems) {
                billItem.setBillInvoiceId(billInvoice.getId());
                billItem.setProjectTypes("");
                this.billItemService.modifyObj(billItem);
            }
        }
    }

    private void updateBillItemForInvoiceDelete(BillInvoice billInvoice, Integer flag) {
        Assert.isNotBlank((String)billInvoice.getId(), (String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BillItemExample billItemExample = new BillItemExample();
        billItemExample.createCriteria().andBillInvoiceIdEqualTo(billInvoice.getId()).andIsEnableEqualTo(Constant.YES_INT);
        List billItems = this.billItemService.queryAllObjByExample((IExample)billItemExample);
        if (CollectionUtils.isNotEmpty((Collection)billItems)) {
            for (BillItem billItem : billItems) {
                billItem.setBillInvoiceId(billInvoice.getId());
                billItem.setBillInvoiceFlag(flag);
                this.billItemService.modifyObj(billItem);
            }
        }
    }

    @CacheEvict(value={"billInvoice"}, allEntries=true)
    public void addObj(BillInvoice t) {
        this.billInvoiceMapper.insertSelective(t);
    }

    @CacheEvict(value={"billInvoice"}, allEntries=true)
    public void deleteObjById(String id) {
        this.billInvoiceMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"billInvoice"}, allEntries=true)
    public void modifyObj(BillInvoice t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.billInvoiceMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"billInvoice"}, keyGenerator="redisKeyGenerator")
    public BillInvoice queryObjById(String id) {
        return this.billInvoiceMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"billInvoice"}, keyGenerator="redisKeyGenerator")
    public List<BillInvoice> queryAllObjByExample(BillInvoiceExample example) {
        return this.billInvoiceMapper.selectByExample(example);
    }

    @Cacheable(value={"billInvoice"}, keyGenerator="redisKeyGenerator")
    public PageView<BillInvoice> queryObjByPage(BillInvoiceExample example) {
        PageView<BillInvoice> pageView = example.getPageView();
        pageView.setQueryResult(this.billInvoiceMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"billInvoice"}, allEntries=true)
    @Transactional
    public int updateByExampleSelective(BillInvoice record, BillInvoiceExample example) {
        return this.billInvoiceMapper.updateByExampleSelective(record, example);
    }

    @Override
    @CacheEvict(value={"billInvoice"}, allEntries=true)
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void updateDeductionAmount(BillInvoice invoice) {
        BillInvoice invoice2 = new BillInvoice();
        invoice2.setId(invoice.getId());
        invoice2.setDeductionAmount(invoice.getDeductionAmount());
        this.billInvoiceMapper.updateByPrimaryKeySelective(invoice2);
    }

    @CacheEvict(value={"billInvoice"}, allEntries=true)
    public void deleteByExample(BillInvoiceExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.billInvoiceMapper.deleteByExample(example);
    }

    @CacheEvict(value={"billInvoice"}, allEntries=true)
    @Transactional
    public void addAll(List<BillInvoice> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.billInvoiceMapper.insertSelective((BillInvoice)record));
    }
}

