/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.letter.service.impl;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.letter.dao.LetterMapper;
import com.els.base.letter.entity.Letter;
import com.els.base.letter.entity.LetterExample;
import com.els.base.letter.service.LetterService;
import com.els.base.letter.util.LetterBusinessTypeEnum;
import com.els.base.letter.util.LetterPrintUtils;
import com.els.base.letter.util.LetterStatus;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultLetterService")
public class LetterServiceImpl
implements LetterService {
    Logger logger = LoggerFactory.getLogger(LetterServiceImpl.class);
    @Resource
    protected CompanyUserRefService companyUserRefService;
    @Resource
    protected LetterMapper letterMapper;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected GenerateCodeService generateCodeService;

    @CacheEvict(value={"letter"}, allEntries=true)
    public void addObj(Letter t) {
        this.letterMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"letter"}, allEntries=true)
    public void addAll(List<Letter> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.letterMapper.insertBatch(list);
    }

    @CacheEvict(value={"letter"}, allEntries=true)
    public void deleteObjById(String id) {
        this.letterMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"letter"}, allEntries=true)
    public void deleteByExample(LetterExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.letterMapper.deleteByExample(example);
    }

    @CacheEvict(value={"letter"}, allEntries=true)
    public void modifyObj(Letter t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.letterMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"letter"}, keyGenerator="redisKeyGenerator")
    public Letter queryObjById(String id) {
        return this.letterMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"letter"}, keyGenerator="redisKeyGenerator")
    public List<Letter> queryAllObjByExample(LetterExample example) {
        return this.letterMapper.selectByExample(example);
    }

    @Cacheable(value={"letter"}, keyGenerator="redisKeyGenerator")
    public PageView<Letter> queryObjByPage(LetterExample example) {
        PageView<Letter> pageView = example.getPageView();
        pageView.setQueryResult(this.letterMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"letter"}, allEntries=true)
    public void deleteByIds(List<String> ids, User user) {
        LetterExample letterExample = new LetterExample();
        letterExample.createCriteria().andIdIn((List)ids);
        List<Letter> list = this.letterMapper.selectByExample(letterExample);
        List collect = list.stream().filter(i -> !Constant.NO_INT.equals(i.getConfirmStatus())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            throw new CommonException("\u542b\u6709\u5df2\u786e\u8ba4\u6216\u5df2\u9000\u56de\u7684\u5355\u636e\uff0c\u5220\u9664\u5931\u8d25\uff01");
        }
        Letter letter = new Letter();
        letter.setIsEnable(Constant.NO_INT);
        letter.setUpdateUser(user.getNickName());
        letter.setUpdateTime(new Date());
        this.letterMapper.updateByExampleSelective(letter, letterExample);
    }

    @Override
    @CacheEvict(value={"letter"}, allEntries=true)
    public void confirmBySup(List<String> ids, User loginUser) {
        LetterExample letterExample = new LetterExample();
        letterExample.createCriteria().andIdIn((List)ids);
        List<Letter> list = this.letterMapper.selectByExample(letterExample);
        List list2 = list.stream().filter(i -> StringUtils.isEmpty((String)i.getAttachment())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list2)) {
            throw new CommonException("\u542b\u6709\u672a\u4e0a\u4f20\u9644\u4ef6\u7684\u5355\u636e\uff0c\u786e\u8ba4\u5931\u8d25");
        }
        List collect = list.stream().filter(i -> LetterStatus.PUR_CONFIRM.getCode().equals(i.getConfirmStatus()) || LetterStatus.SUP_CONFIRM.getCode().equals(i.getConfirmStatus())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            throw new CommonException("\u542b\u6709\u5df2\u786e\u8ba4\u7684\u5355\u636e\uff0c\u786e\u8ba4\u5931\u8d25\uff01");
        }
        Letter letter = new Letter();
        letter.setConfirmStatus(LetterStatus.SUP_CONFIRM.getCode());
        this.letterMapper.updateByExampleSelective(letter, letterExample);
        for (Letter let : list) {
            this.sendMessagesToPur(loginUser, let, LetterBusinessTypeEnum.SUP_CONFIRM_LETTER.getCode());
        }
    }

    @Override
    @CacheEvict(value={"letter"}, allEntries=true)
    public void confirmByPur(List<String> ids, User loginUser) {
        LetterExample letterExample = new LetterExample();
        letterExample.createCriteria().andIdIn((List)ids);
        List<Letter> list = this.letterMapper.selectByExample(letterExample);
        List collect = list.stream().filter(i -> !LetterStatus.SUP_CONFIRM.getCode().equals(i.getConfirmStatus())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            throw new CommonException("\u53ea\u6709\u786e\u8ba4\u72b6\u6001\u4e3a\u4f9b\u5e94\u5546\u5df2\u786e\u8ba4\u7684\u5355\u636e\u624d\u80fd\u786e\u8ba4,\u786e\u8ba4\u5931\u8d25\uff01");
        }
        Letter letter = new Letter();
        letter.setConfirmStatus(LetterStatus.PUR_CONFIRM.getCode());
        this.letterMapper.updateByExampleSelective(letter, letterExample);
        for (Letter let : list) {
            this.sendMessagesToSup(loginUser, let, LetterBusinessTypeEnum.PUR_CONFIRM_LETTER.getCode());
        }
    }

    @Override
    @CacheEvict(value={"letter"}, allEntries=true)
    public void backByPur(List<String> ids, User loginUser) {
        LetterExample letterExample = new LetterExample();
        letterExample.createCriteria().andIdIn((List)ids);
        List<Letter> list = this.letterMapper.selectByExample(letterExample);
        List collect = list.stream().filter(i -> !LetterStatus.SUP_CONFIRM.getCode().equals(i.getConfirmStatus())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            throw new CommonException("\u53ea\u6709\u786e\u8ba4\u72b6\u6001\u4e3a\u4f9b\u5e94\u5546\u5df2\u786e\u8ba4\u7684\u5355\u636e\u624d\u80fd\u9000\u56de,\u9000\u56de\u5931\u8d25\uff01");
        }
        Letter letter = new Letter();
        letter.setConfirmStatus(LetterStatus.PUR_BACK.getCode());
        this.letterMapper.updateByExampleSelective(letter, letterExample);
        for (Letter let : list) {
            this.sendMessagesToSup(loginUser, let, LetterBusinessTypeEnum.PUR_BACK_LETTER.getCode());
        }
    }

    @Override
    @CacheEvict(value={"letter"}, allEntries=true)
    public void modify(Letter letter, User user) {
        Letter let = new Letter();
        let.setId(letter.getId());
        let.setAttachment(letter.getAttachment());
        let.setAttachmentType(letter.getAttachmentType());
        let.setRemark(letter.getRemark());
        let.setUpdateTime(new Date());
        let.setUpdateUser(user.getNickName());
        this.letterMapper.updateByPrimaryKeySelective(let);
    }

    @Override
    public FileData print(String projectId, Company currentCompany, List<String> ids, String fontPathStr) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("id\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "id_is_blank");
        }
        LetterExample example = new LetterExample();
        example.createCriteria().andIdIn((List)ids);
        List<Letter> letters = this.letterMapper.selectByExample(example);
        for (Letter letter : letters) {
            String companyFullName = letter.getSupCompanyFullName();
            String a = "\u5e7f\u5dde\u5b9d\u51ef\u9053\u878d\u5546\u4e1a\u4fdd\u7406\u6709\u9650\u516c\u53f8";
            String b = "\u4e0a\u6d77\u5b9d\u51ef\u9053\u878d\u5546\u4e1a\u4fdd\u7406\u6709\u9650\u516c\u53f8";
            if (companyFullName.contains(a)) {
                companyFullName = companyFullName.replace(a, "");
                companyFullName = companyFullName.substring(0, companyFullName.length() - 2);
            }
            if (companyFullName.contains(b)) {
                companyFullName = companyFullName.replace(b, "");
                companyFullName = companyFullName.substring(0, companyFullName.length() - 2);
            }
            letter.setSupCompanyFullName(companyFullName);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("vo", letters.get(0));
        params.put("fontPathStr", fontPathStr);
        this.logger.info("\u5bf9\u8d26\u51fd\u6253\u5370\u53c2\u6570\u4e3a[{}]", (Object)((Object)params).toString());
        FileData fileData = null;
        try {
            fileData = LetterPrintUtils.generatePdf(projectId, currentCompany.getId(), params, "A4", letters.get(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileData;
    }

    protected void sendMessagesToPur(User loginUser, Letter data, String businessType) {
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(data.getCreateUserId());
        MessageSendUtils.sendMessage((Message)message);
    }

    protected void sendMessagesToSup(User loginUser, Letter data, String businessType) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getSupCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    @Override
    @Transactional
    @CacheEvict(value={"letter"}, allEntries=true)
    public void createLetter(Letter letter, User user, Company company) {
        String sapCode = letter.getSupCompanySapCode();
        String companyCode = letter.getCompanyCode();
        String endTime = DateFormatUtils.format((Date)letter.getEndTime(), (String)"yyyy-MM-dd");
        LetterExample example = new LetterExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andSupCompanySapCodeEqualTo(sapCode).andCompanyCodeEqualTo(companyCode).andEndTimeEqualTo(letter.getEndTime());
        List<Letter> list = this.letterMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new CommonException("\u6682\u65f6\u8fd8\u6ca1\u6709\u9700\u8981\u751f\u6210\u5bf9\u8d26\u51fd\u7684\u51fd\u636e\uff01");
        }
        Object timeWork = null;
        this.addObj(letter);
        this.sendMessagesToSup(user, letter, LetterBusinessTypeEnum.LETTER_SEND.getCode());
    }

    private void completePurAndSup(Letter letter, Company company) {
        letter.setPurCompanyFullName(company.getCompanyFullName());
        letter.setPurCompanyId(company.getId());
        letter.setPurCompanyName(company.getCompanyName());
        letter.setPurCompanySapCode(company.getCompanySapCode());
        letter.setPurCompanySrmCode(company.getCompanyCode());
        Company supCompany = this.companyService.queryCompanyBySapCode(letter.getSupCompanySapCode());
        letter.setSupCompanyFullName(supCompany.getCompanyFullName());
        letter.setSupCompanyId(supCompany.getId());
        letter.setSupCompanyName(supCompany.getCompanyName());
        letter.setSupCompanySrmCode(supCompany.getCompanyCode());
    }
}

