/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purVoucher.controller;

import com.els.base.bill.utils.ExcelFileData;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.purVoucher.entity.BillPurVoucher;
import com.els.base.purVoucher.entity.BillPurVoucherExample;
import com.els.base.purVoucher.service.BillPurVoucherService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.json.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u6536\u8d27\u51ed\u8bc1\u8868"})
@Controller
@RequestMapping(value={"billPurVoucher"})
public class BillPurVoucherController {
    @Resource
    protected BillPurVoucherService billPurVoucherService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u6536\u8d27\u51ed\u8bc1\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BillPurVoucher billPurVoucher) {
        this.billPurVoucherService.addObj(billPurVoucher);
        return ResponseResult.success((Object)billPurVoucher.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u6536\u8d27\u51ed\u8bc1\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BillPurVoucher billPurVoucher) {
        Assert.isNotBlank((String)billPurVoucher.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.billPurVoucherService.modifyObj(billPurVoucher);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u6536\u8d27\u51ed\u8bc1\u8868")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        BillPurVoucherExample example = new BillPurVoucherExample();
        example.createCriteria().andIdIn((List)ids);
        this.billPurVoucherService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u67e5\u8be2\u6536\u8d27\u51ed\u8bc1\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BillPurVoucher", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForPur"})
    @ResponseBody
    public ResponseResult<PageView<BillPurVoucher>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BillPurVoucherExample example = new BillPurVoucherExample();
        example.setPageView((PageView<BillPurVoucher>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        BillPurVoucherExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andBillFlagEqualTo(Constant.NO_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.billPurVoucherService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u67e5\u8be2\u6536\u8d27\u51ed\u8bc1\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BillPurVoucher", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForSup"})
    @ResponseBody
    public ResponseResult<PageView<BillPurVoucher>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BillPurVoucherExample example = new BillPurVoucherExample();
        example.setPageView((PageView<BillPurVoucher>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        BillPurVoucherExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andBillFlagEqualTo(Constant.NO_INT).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.billPurVoucherService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u5bfc\u51faExcel", httpMethod="POST")
    @RequestMapping(value={"service/downloadExcelForSup"})
    @ResponseBody
    public ResponseResult<FileData> exportForSupCompanyVerDownload(@RequestBody(required=false) List<String> ids, String queryParams) throws Exception {
        Company company = CompanyUtils.currentCompany();
        BillPurVoucherExample example = new BillPurVoucherExample();
        example.setOrderByClause("CREATE_TIME DESC");
        BillPurVoucherExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andSupCompanyIdEqualTo(company.getId());
        if (StringUtils.isNotEmpty((String)queryParams)) {
            QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)queryParamWapper);
        }
        List vouchers = null;
        if (CollectionUtils.isEmpty(ids)) {
            vouchers = this.billPurVoucherService.queryAllObjByExample((IExample)example);
            Assert.isNotEmpty((Collection)vouchers, (String)"\u5bfc\u51fa\u7684\u6570\u636e\u4e3a\u7a7a");
        } else {
            criteria.andIdIn((List)ids);
            vouchers = this.billPurVoucherService.queryAllObjByExample((IExample)example);
        }
        for (BillPurVoucher voucher : vouchers) {
            if (voucher.getPriceEntity() == 0) {
                voucher.setPurCompanyId("\u5426");
                continue;
            }
            voucher.setPurCompanyId("\u662f");
        }
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelColumnDown();
        FileData fileData = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, vouchers, "\u672a\u5bf9\u8d26\u660e\u7ec6", "\u672a\u5bf9\u8d26\u660e\u7ec6", 0);
        return ResponseResult.success((Object)fileData);
    }

    @ApiOperation(value="\u91c7\u8d2d\u5546\u5bfc\u51faExcel", httpMethod="POST")
    @RequestMapping(value={"service/downloadExcelForPur"})
    @ResponseBody
    public ResponseResult<FileData> exportForPurCompanyVerDownload(@RequestBody(required=false) List<String> ids, String queryParams) throws Exception {
        BillPurVoucherExample example = new BillPurVoucherExample();
        example.setOrderByClause("CREATE_TIME DESC");
        BillPurVoucherExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (StringUtils.isNotEmpty((String)queryParams)) {
            QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)queryParamWapper);
        }
        List vouchers = null;
        if (CollectionUtils.isEmpty(ids)) {
            vouchers = this.billPurVoucherService.queryAllObjByExample((IExample)example);
            Assert.isNotEmpty((Collection)vouchers, (String)"\u5bfc\u51fa\u7684\u6570\u636e\u4e3a\u7a7a");
        } else {
            criteria.andIdIn((List)ids);
            vouchers = this.billPurVoucherService.queryAllObjByExample((IExample)example);
        }
        for (BillPurVoucher voucher : vouchers) {
            if (voucher.getPriceEntity() == 0) {
                voucher.setPurCompanyId("\u5426");
                continue;
            }
            voucher.setPurCompanyId("\u662f");
        }
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelColumnDown();
        FileData fileData = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, vouchers, "\u672a\u5bf9\u8d26\u660e\u7ec6", "\u672a\u5bf9\u8d26\u660e\u7ec6", 0);
        return ResponseResult.success((Object)fileData);
    }

    private List<TitleAndModelKey> createExcelColumnDown() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f1a\u8ba1\u5e74\u5ea6", (String)"accountingYear"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u51ed\u8bc1", (String)"materialVoucherNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u51ed\u8bc1\u9879\u76ee", (String)"voucherProject"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u51ed\u8bc1\u65e5\u671f", (String)"voucherTime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8fc7\u8d26\u65e5\u671f", (String)"postingTime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u8ba2\u5355", (String)"purchaseOrderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u9879\u76ee", (String)"purchaseOrderItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e93\u5b58\u5730\u70b9", (String)"stockSpaceCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7f16\u7801", (String)"supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u516c\u53f8", (String)"company"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5de5\u5382", (String)"factory"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u79fb\u52a8\u7c7b\u578b", (String)"billType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6570\u91cf", (String)"materialQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u57fa\u672c\u5355\u4f4d", (String)"elementaryEntity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u53d1\u8d27\u5355\u53f7", (String)"deliveryOrderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u53d1\u8d27\u5355\u884c\u53f7", (String)"deliveryOrderItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7b26\u53f7", (String)"mark"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u53c2\u8003\u51ed\u8bc1\u53f7", (String)"voucherNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6682\u4f30\u4ef7\u6807\u8bc6", (String)"purCompanyId"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7a0e\u7387", (String)"taxRate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ef7\u683c\u5355\u4f4d", (String)"priceUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u4ef7", (String)"orderPrice"));
        return titleAndModelKeys;
    }
}

