
-- ----------------------------
-- 对账单
-- ----------------------------
-- DROP TABLE "T_BILL";
CREATE TABLE "T_BILL" (
  "ID" VARCHAR2(32 CHAR) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 CHAR) ,
  "BILL_NO" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) ,
  "PUR_COMPANY_NAME" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "PUR_USER_ID" VARCHAR2(32 CHAR) ,
  "PUR_USER_NAME" VARCHAR2(255 CHAR) ,
  "PUR_REMARK" VARCHAR2(255 CHAR) ,
  "PUR_SEND_STATUS" NUMBER(11) ,
  "PUR_CONFIRM_STATUS" NUMBER(11) ,
  "PUR_CONFIRM_BILL_STATUS" NUMBER(11) ,
  "SUP_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_ADDRESS" VARCHAR2(255 CHAR) ,
  "SUP_USER_ID" VARCHAR2(32 CHAR) ,
  "SUP_USER_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMTACT_USER_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMTACT_TELEPHONE" VARCHAR2(255 CHAR) ,
  "SUP_REMARK" VARCHAR2(255 CHAR) ,
  "SUP_SEND_STATUS" NUMBER(11) ,
  "SUP_CONFIRM_STATUS" NUMBER(11) ,
  "SUP_CONFIRM_BILL_STATUS" NUMBER(11) ,
  "START_TIME" NUMBER(11) ,
  "END_TIME" NUMBER(11) ,
  "CURRENCY_TYPE" VARCHAR2(32 CHAR) ,
  "IS_ENABLE" NUMBER(11) ,
  "CREATE_TIME" DATE ,
  "UPDATE_TIME" DATE ,
  "APPROVE_NO" VARCHAR2(32 CHAR) ,
  "APPROVE_RESULT" VARCHAR2(2048 CHAR) ,
  "APPROVE_USER_NAME" VARCHAR2(2048 CHAR) ,
  "APPROVE_STATUS" NUMBER(11) ,
  "APPROVE_TIME" DATE ,
  "PAY_CONDITIONS_CODE" VARCHAR2(255 CHAR) ,
  "PAY_CONDITIONS_DESC" VARCHAR2(255 CHAR) ,
  "TAX_RATE" NUMBER(11,2) ,
  "NET_PRICE" NUMBER(11,2) ,
  "INCLUDE_TAX_AMOUNT" NUMBER(13,4) ,
  "NOT_INCLUDE_TAX_AMOUNT" NUMBER(13,4) ,
  "TAX_AMOUNT" NUMBER(13,4) ,
  "TOTAL_AMOUNT" NUMBER(13,4) ,
  "DEDUCTION_AMOUNT" NUMBER(13,4) ,
  "POSTING_START_TIME" DATE ,
  "POSTING_END_TIME" DATE ,
  "CREATE_BILL_TYPE" NUMBER(11) ,
  "TAX_CODE" VARCHAR2(255 CHAR) ,
  "COMPANY_CODE" VARCHAR2(255 CHAR) ,
  "ABOLISH_STATUS" NUMBER(11) DEFAULT 0   ,
  "COMPANY_NAME" VARCHAR2(255 CHAR) ,
  "ABOLISH_USER_ID" VARCHAR2(32 BYTE) ,
  "ABOLISH_USER_NAME" VARCHAR2(255 BYTE) ,
  "ABOLISH_TIME" DATE,
  "TOTAL_GROUP_ID" VARCHAR2(50),
  "TOTAL_GROUP_NAME" VARCHAR2(50),
  "ACCOUNT_SET_ID" VARCHAR2(50),
  "ACCOUNT_SET_NAME" VARCHAR2(50),
  "ACCOUNT_CODE" VARCHAR2(50),
  "INSTITUTIONS_ID" VARCHAR2(50),
  "INSTITUTIONS_NAME" VARCHAR2(50),
  "IN_THE_ORGANIZATION_ID" VARCHAR2(50),
  "IN_THE_ORGANIZATION_NAME" VARCHAR2(50),
  "DEPART_ID" VARCHAR2(50),
  "DEPART_NAME" VARCHAR2(50)
);

COMMENT ON COLUMN "T_BILL"."ID" IS '主键ID';
COMMENT ON COLUMN "T_BILL"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BILL"."BILL_NO" IS '对账清单号';
COMMENT ON COLUMN "T_BILL"."PUR_COMPANY_ID" IS '采购商公司ID';
COMMENT ON COLUMN "T_BILL"."PUR_COMPANY_SRM_CODE" IS '采购商公司SRM编码';
COMMENT ON COLUMN "T_BILL"."PUR_COMPANY_SAP_CODE" IS '采购商公司SAP编码';
COMMENT ON COLUMN "T_BILL"."PUR_COMPANY_NAME" IS '采购商公司名称';
COMMENT ON COLUMN "T_BILL"."PUR_COMPANY_FULL_NAME" IS '采购商公司全称';
COMMENT ON COLUMN "T_BILL"."PUR_USER_ID" IS '采购员制单人用户ID';
COMMENT ON COLUMN "T_BILL"."PUR_USER_NAME" IS '采购员制单人用户名称';
COMMENT ON COLUMN "T_BILL"."PUR_REMARK" IS '采购员备注';
COMMENT ON COLUMN "T_BILL"."PUR_SEND_STATUS" IS '采购员发送对账清单的状态（已发送=1，未发送=0）';
COMMENT ON COLUMN "T_BILL"."PUR_CONFIRM_STATUS" IS '采购员确认发送对账清单的状态（未确认=0，已确认=1，已拒绝=2,已作废=3）';
COMMENT ON COLUMN "T_BILL"."PUR_CONFIRM_BILL_STATUS" IS '采购员确认对账发票信息无误（未确认=0，已确认=1）';
COMMENT ON COLUMN "T_BILL"."SUP_COMPANY_ID" IS '供应商公司ID';
COMMENT ON COLUMN "T_BILL"."SUP_COMPANY_NAME" IS '供应商公司名称';
COMMENT ON COLUMN "T_BILL"."SUP_COMPANY_FULL_NAME" IS '供应商公司全称';
COMMENT ON COLUMN "T_BILL"."SUP_COMPANY_SRM_CODE" IS '供应商公司SRM编码';
COMMENT ON COLUMN "T_BILL"."SUP_COMPANY_SAP_CODE" IS '供应商公司SAP编码';
COMMENT ON COLUMN "T_BILL"."SUP_COMPANY_ADDRESS" IS '供应商地址';
COMMENT ON COLUMN "T_BILL"."SUP_USER_ID" IS '供应商制单人用户ID';
COMMENT ON COLUMN "T_BILL"."SUP_USER_NAME" IS '供应商制单人用户名称';
COMMENT ON COLUMN "T_BILL"."SUP_COMTACT_USER_NAME" IS '供应商联系人';
COMMENT ON COLUMN "T_BILL"."SUP_COMTACT_TELEPHONE" IS '供应商联系人电话';
COMMENT ON COLUMN "T_BILL"."SUP_REMARK" IS '供应商备注';
COMMENT ON COLUMN "T_BILL"."SUP_SEND_STATUS" IS '供应商发送对账清单的状态（已发送=1，未发送=0）';
COMMENT ON COLUMN "T_BILL"."SUP_CONFIRM_STATUS" IS '供应商确认发送对账清单的状态（未确认=0，已确认=1，已拒绝=2,已作废=3）';
COMMENT ON COLUMN "T_BILL"."SUP_CONFIRM_BILL_STATUS" IS '供应商确认对账发票信息无误（未确认=0，已确认=1）';
COMMENT ON COLUMN "T_BILL"."START_TIME" IS '对账开票开始时间';
COMMENT ON COLUMN "T_BILL"."END_TIME" IS '对账开票结束时间';
COMMENT ON COLUMN "T_BILL"."CURRENCY_TYPE" IS '货币类型';
COMMENT ON COLUMN "T_BILL"."IS_ENABLE" IS '记录是否可用(可用=1，不可用=0)';
COMMENT ON COLUMN "T_BILL"."CREATE_TIME" IS '表创建时间';
COMMENT ON COLUMN "T_BILL"."UPDATE_TIME" IS '表更新时间';
COMMENT ON COLUMN "T_BILL"."APPROVE_NO" IS '审核批号';
COMMENT ON COLUMN "T_BILL"."APPROVE_RESULT" IS '审批结果';
COMMENT ON COLUMN "T_BILL"."APPROVE_USER_NAME" IS '审批人';
COMMENT ON COLUMN "T_BILL"."APPROVE_STATUS" IS '审批状态(0=未审核，1=待审核，2已审核，3已驳回)';
COMMENT ON COLUMN "T_BILL"."APPROVE_TIME" IS '审批时间';
COMMENT ON COLUMN "T_BILL"."PAY_CONDITIONS_CODE" IS '付款条件code';
COMMENT ON COLUMN "T_BILL"."PAY_CONDITIONS_DESC" IS '付款条件描述';
COMMENT ON COLUMN "T_BILL"."TAX_RATE" IS '税率';
COMMENT ON COLUMN "T_BILL"."NET_PRICE" IS '净价';
COMMENT ON COLUMN "T_BILL"."INCLUDE_TAX_AMOUNT" IS '开票含税税额';
COMMENT ON COLUMN "T_BILL"."NOT_INCLUDE_TAX_AMOUNT" IS '开票未税金额';
COMMENT ON COLUMN "T_BILL"."TAX_AMOUNT" IS '开票税额';
COMMENT ON COLUMN "T_BILL"."TOTAL_AMOUNT" IS '对账总金额';
COMMENT ON COLUMN "T_BILL"."DEDUCTION_AMOUNT" IS '扣款总金额';
COMMENT ON COLUMN "T_BILL"."POSTING_START_TIME" IS '凭证开始日期';
COMMENT ON COLUMN "T_BILL"."POSTING_END_TIME" IS '凭证结束日期';
COMMENT ON COLUMN "T_BILL"."CREATE_BILL_TYPE" IS '创建单据属于哪一方（1=采购方，2=供应商）';
COMMENT ON COLUMN "T_BILL"."TAX_CODE" IS '税码';
COMMENT ON COLUMN "T_BILL"."COMPANY_CODE" IS '公司代码';
COMMENT ON COLUMN "T_BILL"."ABOLISH_STATUS" IS '单据状态(0=未回写,1=已作废,2=已回写)';
COMMENT ON COLUMN "T_BILL"."COMPANY_NAME" IS '公司名称';
COMMENT ON COLUMN "T_BILL"."ABOLISH_USER_ID" IS '作废人id';
COMMENT ON COLUMN "T_BILL"."ABOLISH_USER_NAME" IS '作废人名称';
COMMENT ON COLUMN "T_BILL"."ABOLISH_TIME" IS '作废时间';
COMMENT ON COLUMN "T_BILL"."TOTAL_GROUP_ID" IS '总集团id';
COMMENT ON COLUMN "T_BILL"."TOTAL_GROUP_NAME" IS '总集团名称';
COMMENT ON COLUMN "T_BILL"."ACCOUNT_SET_ID" IS '账套id';
COMMENT ON COLUMN "T_BILL"."ACCOUNT_SET_NAME" IS '账套名称';
COMMENT ON COLUMN "T_BILL"."ACCOUNT_CODE" IS '账套编码';
COMMENT ON COLUMN "T_BILL"."INSTITUTIONS_ID" IS '机构id';
COMMENT ON COLUMN "T_BILL"."INSTITUTIONS_NAME" IS '机构名称';
COMMENT ON COLUMN "T_BILL"."IN_THE_ORGANIZATION_ID" IS '中支机构id';
COMMENT ON COLUMN "T_BILL"."IN_THE_ORGANIZATION_NAME" IS '中支机构名称';
COMMENT ON COLUMN "T_BILL"."DEPART_ID" IS '部门id';
COMMENT ON COLUMN "T_BILL"."DEPART_NAME" IS '部门名称';
COMMENT ON TABLE "T_BILL" IS '对账单';

-- ----------------------------
-- 对账单开关
-- ----------------------------
-- DROP TABLE "T_BILL_CATEGORY_SWITCH";
CREATE TABLE "T_BILL_CATEGORY_SWITCH" (
  "ID" VARCHAR2(32 CHAR) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) ,
  "PUR_COMPANY_NAME" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "PUR_USER_ID" VARCHAR2(32 CHAR) ,
  "PUR_USER_NAME" VARCHAR2(255 CHAR) ,
  "IS_ENABLE" NUMBER(11) ,
  "SWITCH_FLAG" NUMBER(11) ,
  "CREATE_TIME" DATE ,
  "UPDATE_TIME" DATE ,
  "START_TIME" NUMBER(11) ,
  "END_TIME" NUMBER(11) ,
  "CATEGORY_NO" VARCHAR2(32 CHAR) ,
  "CATEGORY_NAME" VARCHAR2(255 CHAR) ,
  "VOUCHER_START_TIME" DATE ,
  "VOUCHER_END_TIME" DATE
);

COMMENT ON COLUMN "T_BILL_CATEGORY_SWITCH"."ID" IS '主键ID';
COMMENT ON COLUMN "T_BILL_CATEGORY_SWITCH"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BILL_CATEGORY_SWITCH"."PUR_COMPANY_ID" IS '采购商公司ID';
COMMENT ON COLUMN "T_BILL_CATEGORY_SWITCH"."PUR_COMPANY_SRM_CODE" IS '采购商公司SRM编码';
COMMENT ON COLUMN "T_BILL_CATEGORY_SWITCH"."PUR_COMPANY_SAP_CODE" IS '采购商公司SAP编码';
COMMENT ON COLUMN "T_BILL_CATEGORY_SWITCH"."PUR_COMPANY_NAME" IS '采购商公司名称';
COMMENT ON COLUMN "T_BILL_CATEGORY_SWITCH"."PUR_COMPANY_FULL_NAME" IS '采购商公司全称';
COMMENT ON COLUMN "T_BILL_CATEGORY_SWITCH"."PUR_USER_ID" IS '采购用户ID';
COMMENT ON COLUMN "T_BILL_CATEGORY_SWITCH"."PUR_USER_NAME" IS '采购用户名称';
COMMENT ON COLUMN "T_BILL_CATEGORY_SWITCH"."IS_ENABLE" IS '记录是否可用(可用=1，不可用=0)';
COMMENT ON COLUMN "T_BILL_CATEGORY_SWITCH"."SWITCH_FLAG" IS '开账开关（0=不开启，1=开启）';
COMMENT ON COLUMN "T_BILL_CATEGORY_SWITCH"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BILL_CATEGORY_SWITCH"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BILL_CATEGORY_SWITCH"."START_TIME" IS '供应商开账开始时间（每月多少号）';
COMMENT ON COLUMN "T_BILL_CATEGORY_SWITCH"."END_TIME" IS '供应商开账结束时间（每月多少号）';
COMMENT ON COLUMN "T_BILL_CATEGORY_SWITCH"."CATEGORY_NO" IS '供应商分组编码';
COMMENT ON COLUMN "T_BILL_CATEGORY_SWITCH"."CATEGORY_NAME" IS '供应商分组名称';
COMMENT ON COLUMN "T_BILL_CATEGORY_SWITCH"."VOUCHER_START_TIME" IS '限制凭证开始时间';
COMMENT ON COLUMN "T_BILL_CATEGORY_SWITCH"."VOUCHER_END_TIME" IS '限制凭证结束日期';
COMMENT ON TABLE "T_BILL_CATEGORY_SWITCH" IS '对账单开关';

-- ----------------------------
-- 付款条件维护
-- ----------------------------
-- DROP TABLE "T_BILL_CONDITIONS";
CREATE TABLE "T_BILL_CONDITIONS" (
  "ID" VARCHAR2(32 CHAR) NOT NULL ,
  "PAY_CONDITIONS_CODE" VARCHAR2(255 CHAR) ,
  "PAY_CONDITIONS_DESC" VARCHAR2(255 CHAR)
);

COMMENT ON COLUMN "T_BILL_CONDITIONS"."ID" IS '主键';
COMMENT ON COLUMN "T_BILL_CONDITIONS"."PAY_CONDITIONS_CODE" IS '付款条件code';
COMMENT ON COLUMN "T_BILL_CONDITIONS"."PAY_CONDITIONS_DESC" IS '付款条件描述';
COMMENT ON TABLE "T_BILL_CONDITIONS" IS '付款条件维护';

-- ----------------------------
-- 往来账
-- ----------------------------
-- DROP TABLE "T_BILL_DEALINGS";
CREATE TABLE "T_BILL_DEALINGS" (
  "ID" VARCHAR2(32 CHAR) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(255 CHAR) ,
  "PUR_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "PUR_COMPANY_NAME" VARCHAR2(255 CHAR) ,
  "CLEARING_MARK" VARCHAR2(255 CHAR) ,
  "COMPANY_CODE" VARCHAR2(255 CHAR) ,
  "COMPANY_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_SAP_NAME" VARCHAR2(255 CHAR) ,
  "VOUCHER_TYPE" VARCHAR2(255 CHAR) ,
  "SUBJECT" VARCHAR2(255 CHAR) ,
  "SUBJECT_REMARK" VARCHAR2(255 BYTE) ,
  "VOUCHER_NO" VARCHAR2(32 CHAR) ,
  "LOCAL_CURRENCY_PRICE" NUMBER(11,2) ,
  "LOCAL_CURRENCY" VARCHAR2(255 CHAR) ,
  "REMARK" VARCHAR2(255 CHAR) ,
  "CREATE_TIME" DATE ,
  "UPDATE_TIME" DATE ,
  "IS_ENABLE" NUMBER(11) ,
  "DIRECTION" VARCHAR2(255 CHAR) ,
  "VOUCHER_BILL_NO" VARCHAR2(255 CHAR) ,
  "POSTING_DATE" DATE
);

COMMENT ON COLUMN "T_BILL_DEALINGS"."ID" IS '主键';
COMMENT ON COLUMN "T_BILL_DEALINGS"."PROJECT_ID" IS '表的项目id';
COMMENT ON COLUMN "T_BILL_DEALINGS"."PUR_COMPANY_ID" IS '采购商ID';
COMMENT ON COLUMN "T_BILL_DEALINGS"."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN "T_BILL_DEALINGS"."PUR_COMPANY_FULL_NAME" IS '采购商全称';
COMMENT ON COLUMN "T_BILL_DEALINGS"."PUR_COMPANY_NAME" IS '采购商简称';
COMMENT ON COLUMN "T_BILL_DEALINGS"."CLEARING_MARK" IS '清账标识';
COMMENT ON COLUMN "T_BILL_DEALINGS"."COMPANY_CODE" IS '公司代码';
COMMENT ON COLUMN "T_BILL_DEALINGS"."COMPANY_NAME" IS '公司名称';
COMMENT ON COLUMN "T_BILL_DEALINGS"."SUP_COMPANY_SAP_CODE" IS '供应商sap编码';
COMMENT ON COLUMN "T_BILL_DEALINGS"."SUP_COMPANY_SAP_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_BILL_DEALINGS"."VOUCHER_TYPE" IS '凭证类型';
COMMENT ON COLUMN "T_BILL_DEALINGS"."SUBJECT" IS '会计科目';
COMMENT ON COLUMN "T_BILL_DEALINGS"."SUBJECT_REMARK" IS '会计科目描述';
COMMENT ON COLUMN "T_BILL_DEALINGS"."VOUCHER_NO" IS '凭证编号';
COMMENT ON COLUMN "T_BILL_DEALINGS"."LOCAL_CURRENCY_PRICE" IS '本币金额';
COMMENT ON COLUMN "T_BILL_DEALINGS"."LOCAL_CURRENCY" IS '本币';
COMMENT ON COLUMN "T_BILL_DEALINGS"."REMARK" IS '(备注)文本';
COMMENT ON COLUMN "T_BILL_DEALINGS"."CREATE_TIME" IS '建单时间';
COMMENT ON COLUMN "T_BILL_DEALINGS"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "T_BILL_DEALINGS"."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN "T_BILL_DEALINGS"."DIRECTION" IS '借贷方向';
COMMENT ON COLUMN "T_BILL_DEALINGS"."VOUCHER_BILL_NO" IS '清账凭证号';
COMMENT ON COLUMN "T_BILL_DEALINGS"."POSTING_DATE" IS '过账日期';
COMMENT ON TABLE "T_BILL_DEALINGS" IS '往来账';

-- ----------------------------
-- 对账单-扣款管理
-- ----------------------------
-- DROP TABLE "T_BILL_DEDUCTION";
CREATE TABLE "T_BILL_DEDUCTION" (
  "ID" VARCHAR2(32 CHAR) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(255 CHAR) ,
  "PUR_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "PUR_COMPANY_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 CHAR) ,
  "BILL_FLAG" NUMBER(11) ,
  "COMPANY_CODE" VARCHAR2(255 CHAR) ,
  "COMPANY_NAME" VARCHAR2(255 CHAR) ,
  "TOTAL_GROUP_ID" VARCHAR2(50),
  "TOTAL_GROUP_NAME" VARCHAR2(50),
  "ACCOUNT_SET_ID" VARCHAR2(50),
  "ACCOUNT_SET_NAME" VARCHAR2(50),
  "ACCOUNT_CODE" VARCHAR2(50),
  "INSTITUTIONS_ID" VARCHAR2(50),
  "INSTITUTIONS_NAME" VARCHAR2(50),
  "IN_THE_ORGANIZATION_ID" VARCHAR2(50),
  "IN_THE_ORGANIZATION_NAME" VARCHAR2(50),
  "DEPART_ID" VARCHAR2(50),
  "DEPART_NAME" VARCHAR2(50),
  "DEDUCTION_DATE" DATE ,
  "DEDUCTION_AMOUNT" NUMBER(13,4) ,
  "CURRENCY_TYPE" VARCHAR2(255 CHAR) ,
  "BILL_TYPE" VARCHAR2(255 CHAR) ,
  "DELIVERY_ORDER_ID" VARCHAR2(255 CHAR) ,
  "DELIVERY_ORDER_ITEM_ID" VARCHAR2(255 CHAR) ,
  "INFORMATION" VARCHAR2(255 CHAR) ,
  "IS_ENABLE" NUMBER(11) ,
  "OPERATE_USER" VARCHAR2(255 CHAR) ,
  "OPERATE_DATE" DATE ,
  "CREATE_TIME" DATE ,
  "CREATE_USER_NAME" VARCHAR2(255 CHAR) ,
  "DEDUCTION_NO" VARCHAR2(255 CHAR)
);

COMMENT ON COLUMN "T_BILL_DEDUCTION"."ID" IS '主键';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."PROJECT_ID" IS '表的项目ID';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."PUR_COMPANY_ID" IS '采购商ID';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."PUR_COMPANY_FULL_NAME" IS '采购商全称';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."PUR_COMPANY_NAME" IS '采购商简称';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."SUP_COMPANY_FULL_NAME" IS '供应商全称';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."SUP_COMPANY_NAME" IS '供应商简称';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."BILL_FLAG" IS '是否对账(已对账=1，未对账=0)';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."COMPANY_CODE" IS '公司代码';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."COMPANY_NAME" IS '公司名称';
COMMENT ON COLUMN "T_BASE_CONSUMING"."TOTAL_GROUP_ID" IS '总集团id';
COMMENT ON COLUMN "T_BASE_CONSUMING"."TOTAL_GROUP_NAME" IS '总集团名称';
COMMENT ON COLUMN "T_BASE_CONSUMING"."ACCOUNT_SET_ID" IS '账套id';
COMMENT ON COLUMN "T_BASE_CONSUMING"."ACCOUNT_SET_NAME" IS '账套名称';
COMMENT ON COLUMN "T_BASE_CONSUMING"."ACCOUNT_CODE" IS '账套编码';
COMMENT ON COLUMN "T_BASE_CONSUMING"."INSTITUTIONS_ID" IS '机构id';
COMMENT ON COLUMN "T_BASE_CONSUMING"."INSTITUTIONS_NAME" IS '机构名称';
COMMENT ON COLUMN "T_BASE_CONSUMING"."IN_THE_ORGANIZATION_ID" IS '中支机构id';
COMMENT ON COLUMN "T_BASE_CONSUMING"."IN_THE_ORGANIZATION_NAME" IS '中支机构名称';
COMMENT ON COLUMN "T_BASE_CONSUMING"."DEPART_ID" IS '部门id';
COMMENT ON COLUMN "T_BASE_CONSUMING"."DEPART_NAME" IS '部门名称';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."DEDUCTION_DATE" IS '扣款时间';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."DEDUCTION_AMOUNT" IS '扣款金额';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."CURRENCY_TYPE" IS '币种（默认RMB）';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."BILL_TYPE" IS '对账类型（1:PO基于采购订单对账；2.JD京东慧采对对账单；3.QX齐心商城对账单）';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."DELIVERY_ORDER_ID" IS '收货凭证头id';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."DELIVERY_ORDER_ITEM_ID" IS '收货凭证行id';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."INFORMATION" IS '说明';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."IS_ENABLE" IS '删除标识 （1=未删除，0=已删除）';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."OPERATE_USER" IS '操作人';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."OPERATE_DATE" IS '时间戳';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."CREATE_USER_NAME" IS '创建人';
COMMENT ON COLUMN "T_BILL_DEDUCTION"."DEDUCTION_NO" IS '扣款单号';
COMMENT ON TABLE "T_BILL_DEDUCTION" IS '对账单-扣款管理';

-- ----------------------------
-- 财务管理-预制发票
-- ----------------------------
-- DROP TABLE "T_BILL_INVOICE";
CREATE TABLE "T_BILL_INVOICE" (
  "ID" VARCHAR2(32 CHAR) NOT NULL ,
  "BILL_ID" VARCHAR2(32 CHAR) ,
  "BILL_NO" VARCHAR2(32 CHAR) ,
  "CURRENCY_TYPE" VARCHAR2(32 CHAR) ,
  "CREATE_TIME" DATE ,
  "UPDATE_TIME" DATE ,
  "INVOICE_DISTRIBUTION" VARCHAR2(2048 CHAR) ,
  "INVOICE_NO" VARCHAR2(2048 CHAR) ,
  "INVOICE_TIME" DATE ,
  "INVOICE_TITLE" VARCHAR2(2048 CHAR) ,
  "INVOICE_TEXT" VARCHAR2(2048 CHAR) ,
  "INVOICE_IMG" VARCHAR2(2048 CHAR) ,
  "INCLUDE_TAX_AMOUNT" NUMBER(13,4) ,
  "NOT_INCLUDE_TAX_AMOUNT" NUMBER(13,4) ,
  "TAX_AMOUNT" NUMBER(13,4) ,
  "TOTAL_AMOUNT" NUMBER(13,4) ,
  "DEDUCTION_AMOUNT" NUMBER(13,4) ,
  "POSTING_TIME" DATE ,
  "SAP_INVOICE_NO" VARCHAR2(255 CHAR) ,
  "TAX_CODE" VARCHAR2(255 CHAR) ,
  "TAX_RATE" NUMBER(11,2) ,
  "IS_BACK" NUMBER(11) ,
  "STANDARD_DATE" DATE ,
  "VOUCHER_TAX_AMOUNT" NUMBER(13,4) ,
  "VOUCHER" VARCHAR2(255 CHAR) ,
  "PROJECT" VARCHAR2(255 CHAR)
);

COMMENT ON COLUMN "T_BILL_INVOICE"."ID" IS '主键ID';
COMMENT ON COLUMN "T_BILL_INVOICE"."BILL_ID" IS '对账清ID';
COMMENT ON COLUMN "T_BILL_INVOICE"."BILL_NO" IS '对账清单号';
COMMENT ON COLUMN "T_BILL_INVOICE"."CURRENCY_TYPE" IS '货币类型';
COMMENT ON COLUMN "T_BILL_INVOICE"."CREATE_TIME" IS '表创建时间';
COMMENT ON COLUMN "T_BILL_INVOICE"."UPDATE_TIME" IS '表更新时间';
COMMENT ON COLUMN "T_BILL_INVOICE"."INVOICE_DISTRIBUTION" IS '分配';
COMMENT ON COLUMN "T_BILL_INVOICE"."INVOICE_NO" IS '发票号';
COMMENT ON COLUMN "T_BILL_INVOICE"."INVOICE_TIME" IS '发票日期';
COMMENT ON COLUMN "T_BILL_INVOICE"."INVOICE_TITLE" IS '抬头文本';
COMMENT ON COLUMN "T_BILL_INVOICE"."INVOICE_TEXT" IS '文本';
COMMENT ON COLUMN "T_BILL_INVOICE"."INVOICE_IMG" IS '发票图片';
COMMENT ON COLUMN "T_BILL_INVOICE"."INCLUDE_TAX_AMOUNT" IS '开票含税税额';
COMMENT ON COLUMN "T_BILL_INVOICE"."NOT_INCLUDE_TAX_AMOUNT" IS '开票未税金额';
COMMENT ON COLUMN "T_BILL_INVOICE"."TAX_AMOUNT" IS '开票税额';
COMMENT ON COLUMN "T_BILL_INVOICE"."TOTAL_AMOUNT" IS '对账总金额';
COMMENT ON COLUMN "T_BILL_INVOICE"."DEDUCTION_AMOUNT" IS '扣款总金额';
COMMENT ON COLUMN "T_BILL_INVOICE"."POSTING_TIME" IS '过账日期';
COMMENT ON COLUMN "T_BILL_INVOICE"."SAP_INVOICE_NO" IS 'SAP系统传过来的发票流水号（用于开票有问题的时候方便对应查询）';
COMMENT ON COLUMN "T_BILL_INVOICE"."TAX_CODE" IS '税码';
COMMENT ON COLUMN "T_BILL_INVOICE"."TAX_RATE" IS '税率';
COMMENT ON COLUMN "T_BILL_INVOICE"."IS_BACK" IS '是否退回(0=否,1=是)';
COMMENT ON COLUMN "T_BILL_INVOICE"."STANDARD_DATE" IS '基准日期';
COMMENT ON COLUMN "T_BILL_INVOICE"."VOUCHER_TAX_AMOUNT" IS '凭证不含税金额';
COMMENT ON COLUMN "T_BILL_INVOICE"."VOUCHER" IS '会计凭证';
COMMENT ON COLUMN "T_BILL_INVOICE"."PROJECT" IS '总账科目';
COMMENT ON TABLE "T_BILL_INVOICE" IS '财务管理-预制发票';

-- ----------------------------
-- Table structure for T_BILL_INVOICE_REBATE
-- ----------------------------
-- DROP TABLE "T_BILL_INVOICE_REBATE";
CREATE TABLE "T_BILL_INVOICE_REBATE" (
  "ID" VARCHAR2(32 CHAR) NOT NULL ,
  "PUR_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) ,
  "PUR_COMPANY_NAME" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) ,
  "MATERIAL_NO" VARCHAR2(32 CHAR) ,
  "MATERIAL_DESC" VARCHAR2(32 CHAR) ,
  "MATERIAL_QUANTITY" NUMBER(11) ,
  "FACTORY" VARCHAR2(255 CHAR) ,
  "NOT_INCLUDE_TAX_AMOUNT" NUMBER ,
  "INCLUDE_TAX_AMOUNT" NUMBER ,
  "TAX_AMOUNT" NUMBER ,
  "BILL_ID" VARCHAR2(32 CHAR) ,
  "BILL_NO" VARCHAR2(32 CHAR) ,
  "BILL_INVOICE_ID" VARCHAR2(32 CHAR) ,
  "TAX_CODE" VARCHAR2(255 CHAR) ,
  "TAX_RATE" NUMBER ,
  "DB_CR_IND" VARCHAR2(255 CHAR) ,
  "CURRENCY_TYPE" VARCHAR2(255 CHAR) ,
  "MATERIAL_UNIT" VARCHAR2(255 CHAR)
);

COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."ID" IS '主键ID';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."PUR_COMPANY_ID" IS '采购商公司ID';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."PUR_COMPANY_SRM_CODE" IS '采购商公司SRM编码';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."PUR_COMPANY_SAP_CODE" IS '采购商公司SAP编码';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."PUR_COMPANY_NAME" IS '采购商公司简称';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."PUR_COMPANY_FULL_NAME" IS '采购商公司全称';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."SUP_COMPANY_ID" IS '供应商公司ID';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."SUP_COMPANY_NAME" IS '供应商公司名称';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."SUP_COMPANY_FULL_NAME" IS '供应商公司全称';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."SUP_COMPANY_SRM_CODE" IS '供应商公司SRM编码';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."SUP_COMPANY_SAP_CODE" IS '供应商公司SAP编码';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."MATERIAL_NO" IS '物料编码';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."MATERIAL_QUANTITY" IS '物料数量';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."FACTORY" IS '工厂';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."NOT_INCLUDE_TAX_AMOUNT" IS '开票未税金额';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."INCLUDE_TAX_AMOUNT" IS '开票含税金额';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."TAX_AMOUNT" IS '开票税额';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."BILL_ID" IS '对账清单ID';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."BILL_NO" IS '对账清单号';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."BILL_INVOICE_ID" IS '发票ID';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."TAX_CODE" IS '税码';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."TAX_RATE" IS '税率';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."DB_CR_IND" IS '借方/贷方标识(折让单默认为H)';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."CURRENCY_TYPE" IS '单位';
COMMENT ON COLUMN "T_BILL_INVOICE_REBATE"."MATERIAL_UNIT" IS '物料单位';

-- ----------------------------
-- Table structure for T_BILL_ITEM
-- ----------------------------
-- DROP TABLE "T_BILL_ITEM";
CREATE TABLE "T_BILL_ITEM" (
  "ID" VARCHAR2(32 CHAR) NOT NULL ,
  "PUR_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) ,
  "PUR_COMPANY_NAME" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) ,
  "DELIVERY_ORDER_NO" VARCHAR2(32 CHAR) ,
  "DELIVERY_ORDER_ITEM_NO" VARCHAR2(32 CHAR) ,
  "PURCHASE_ORDER_NO" VARCHAR2(32 CHAR) ,
  "PURCHASE_ORDER_ITEM_NO" VARCHAR2(32 CHAR) ,
  "MATERIAL_ID" VARCHAR2(32 CHAR) ,
  "MATERIAL_NO" VARCHAR2(32 CHAR) ,
  "MATERIAL_DESC" VARCHAR2(255 CHAR) ,
  "MATERIAL_QUANTITY" NUMBER(13,3) ,
  "MATERIAL_VOUCHER_NO" VARCHAR2(32 CHAR) ,
  "MATERIAL_VOUCHER_ITEM_NO" VARCHAR2(32 CHAR) ,
  "POSTING_TIME" DATE ,
  "CURRENCY_TYPE" VARCHAR2(32 CHAR) ,
  "BILL_TYPE" VARCHAR2(32 CHAR) ,
  "BILL_FLAG" NUMBER(11) ,
  "IS_ENABLE" NUMBER(11) ,
  "FACTORY" VARCHAR2(255 CHAR) ,
  "PROJECT_TYPES" VARCHAR2(255 CHAR) ,
  "TAX_RATE" NUMBER(8,2) ,
  "NOT_INCLUDE_TAX_AMOUNT" NUMBER(13,4) ,
  "INCLUDE_TAX_AMOUNT" NUMBER(13,4) ,
  "TAX_AMOUNT" NUMBER(13,4) ,
  "LATEST_PRICE" NUMBER(13,4) ,
  "ORDER_PRICE" NUMBER(13,4) ,
  "ORDER_AMOUNT" NUMBER(7,1) ,
  "BILL_ID" VARCHAR2(32 CHAR) ,
  "BILL_NO" VARCHAR2(32 CHAR) ,
  "VOUCHER_ID" VARCHAR2(32 CHAR) ,
  "BILL_INVOICE_FLAG" NUMBER(11) ,
  "BILL_INVOICE_ID" VARCHAR2(32 CHAR) ,
  "TAX_CODE" VARCHAR2(255 CHAR) ,
  "MATERIAL_UNIT" VARCHAR2(255 CHAR) ,
  "ACCOUNTING_YEAR" VARCHAR2(255 CHAR) ,
  "VOUCHER_TIME" DATE ,
  "INPUT_DATE" DATE ,
  "INPUT_TIME" DATE ,
  "STOCK_SPACE_CODE" VARCHAR2(255 CHAR) ,
  "STOCK_SPACE_REMARK" VARCHAR2(255 CHAR) ,
  "COMPANY" VARCHAR2(255 CHAR) ,
  "QUANTITY" NUMBER(7,1) ,
  "ELEMENTARY_ENTITY" VARCHAR2(255 BYTE) ,
  "USER_NAME" VARCHAR2(255 CHAR) ,
  "PAYMENT_WAY" VARCHAR2(255 BYTE) ,
  "MARK" VARCHAR2(255 CHAR) ,
  "PRICE_ENTITY" NUMBER(11,1) ,
  "GOODSANDLABOR_NAME" VARCHAR2(255 CHAR) ,
  "COMBINED_TAX_CODE" VARCHAR2(255 CHAR) ,
  "VOUCHER_ACCOUNTING_YEAR" VARCHAR2(255 CHAR) ,
  "VOUCHER_NO" VARCHAR2(255 BYTE) ,
  "VOUCHER_PROJECT" VARCHAR2(255 CHAR) ,
  "AGREEMENT_NO" VARCHAR2(255 CHAR) ,
  "AGREEMENT_DATE" DATE ,
  "AGREEMENT_ITEM_NO" VARCHAR2(255 CHAR) ,
  "SPARE_DATE" DATE ,
  "ABOLISH_STATUS" NUMBER(11) DEFAULT 0
);

COMMENT ON COLUMN "T_BILL_ITEM"."ID" IS '主键ID';
COMMENT ON COLUMN "T_BILL_ITEM"."PUR_COMPANY_ID" IS '采购商公司ID';
COMMENT ON COLUMN "T_BILL_ITEM"."PUR_COMPANY_SRM_CODE" IS '采购商公司SRM编码';
COMMENT ON COLUMN "T_BILL_ITEM"."PUR_COMPANY_SAP_CODE" IS '采购商公司SAP编码';
COMMENT ON COLUMN "T_BILL_ITEM"."PUR_COMPANY_NAME" IS '采购商公司名称';
COMMENT ON COLUMN "T_BILL_ITEM"."PUR_COMPANY_FULL_NAME" IS '采购商公司全称';
COMMENT ON COLUMN "T_BILL_ITEM"."SUP_COMPANY_ID" IS '供应商公司ID';
COMMENT ON COLUMN "T_BILL_ITEM"."SUP_COMPANY_NAME" IS '供应商公司名称';
COMMENT ON COLUMN "T_BILL_ITEM"."SUP_COMPANY_FULL_NAME" IS '供应商公司全称';
COMMENT ON COLUMN "T_BILL_ITEM"."SUP_COMPANY_SRM_CODE" IS '供应商公司SRM编码';
COMMENT ON COLUMN "T_BILL_ITEM"."SUP_COMPANY_SAP_CODE" IS '供应商公司SAP编码';
COMMENT ON COLUMN "T_BILL_ITEM"."DELIVERY_ORDER_NO" IS '送货单号';
COMMENT ON COLUMN "T_BILL_ITEM"."DELIVERY_ORDER_ITEM_NO" IS '送货单行号';
COMMENT ON COLUMN "T_BILL_ITEM"."PURCHASE_ORDER_NO" IS '采购单号';
COMMENT ON COLUMN "T_BILL_ITEM"."PURCHASE_ORDER_ITEM_NO" IS '采购单行号';
COMMENT ON COLUMN "T_BILL_ITEM"."MATERIAL_ID" IS '物料ID';
COMMENT ON COLUMN "T_BILL_ITEM"."MATERIAL_NO" IS '物料编码';
COMMENT ON COLUMN "T_BILL_ITEM"."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN "T_BILL_ITEM"."MATERIAL_QUANTITY" IS '物料数量';
COMMENT ON COLUMN "T_BILL_ITEM"."MATERIAL_VOUCHER_NO" IS '物料凭证号';
COMMENT ON COLUMN "T_BILL_ITEM"."MATERIAL_VOUCHER_ITEM_NO" IS '物料凭证行号';
COMMENT ON COLUMN "T_BILL_ITEM"."POSTING_TIME" IS '过账日期';
COMMENT ON COLUMN "T_BILL_ITEM"."CURRENCY_TYPE" IS '货币类型';
COMMENT ON COLUMN "T_BILL_ITEM"."BILL_TYPE" IS '移动类型';
COMMENT ON COLUMN "T_BILL_ITEM"."BILL_FLAG" IS '是否对账(已对账=1，未对账=0)';
COMMENT ON COLUMN "T_BILL_ITEM"."IS_ENABLE" IS '记录是否可用(可用=1，不可用=0)';
COMMENT ON COLUMN "T_BILL_ITEM"."FACTORY" IS '工厂';
COMMENT ON COLUMN "T_BILL_ITEM"."PROJECT_TYPES" IS '项目类别';
COMMENT ON COLUMN "T_BILL_ITEM"."TAX_RATE" IS '税率';
COMMENT ON COLUMN "T_BILL_ITEM"."NOT_INCLUDE_TAX_AMOUNT" IS '开票未税金额';
COMMENT ON COLUMN "T_BILL_ITEM"."INCLUDE_TAX_AMOUNT" IS '开票含税金额';
COMMENT ON COLUMN "T_BILL_ITEM"."TAX_AMOUNT" IS '开票税额';
COMMENT ON COLUMN "T_BILL_ITEM"."LATEST_PRICE" IS '最新采购信息记录价格';
COMMENT ON COLUMN "T_BILL_ITEM"."ORDER_PRICE" IS '单价';
COMMENT ON COLUMN "T_BILL_ITEM"."ORDER_AMOUNT" IS '订单总金额';
COMMENT ON COLUMN "T_BILL_ITEM"."BILL_ID" IS '对账清单ID';
COMMENT ON COLUMN "T_BILL_ITEM"."BILL_NO" IS '对账清单号';
COMMENT ON COLUMN "T_BILL_ITEM"."VOUCHER_ID" IS '开票凭证ID';
COMMENT ON COLUMN "T_BILL_ITEM"."BILL_INVOICE_FLAG" IS '是否开过发票（已开=1，未开=0）';
COMMENT ON COLUMN "T_BILL_ITEM"."BILL_INVOICE_ID" IS '发票ID';
COMMENT ON COLUMN "T_BILL_ITEM"."TAX_CODE" IS '税码';
COMMENT ON COLUMN "T_BILL_ITEM"."MATERIAL_UNIT" IS '物料单位';
COMMENT ON COLUMN "T_BILL_ITEM"."ACCOUNTING_YEAR" IS '会计年度';
COMMENT ON COLUMN "T_BILL_ITEM"."INPUT_DATE" IS '输入日期';
COMMENT ON COLUMN "T_BILL_ITEM"."INPUT_TIME" IS '输入时间';
COMMENT ON COLUMN "T_BILL_ITEM"."STOCK_SPACE_CODE" IS '库存地点编码';
COMMENT ON COLUMN "T_BILL_ITEM"."STOCK_SPACE_REMARK" IS '库存地点描述';
COMMENT ON COLUMN "T_BILL_ITEM"."COMPANY" IS '公司';
COMMENT ON COLUMN "T_BILL_ITEM"."QUANTITY" IS '基本单位';
COMMENT ON COLUMN "T_BILL_ITEM"."USER_NAME" IS '用户名';
COMMENT ON COLUMN "T_BILL_ITEM"."PAYMENT_WAY" IS '付款方式';
COMMENT ON COLUMN "T_BILL_ITEM"."MARK" IS '符号';
COMMENT ON COLUMN "T_BILL_ITEM"."PRICE_ENTITY" IS '价格单位';
COMMENT ON COLUMN "T_BILL_ITEM"."GOODSANDLABOR_NAME" IS '货物和劳务名称';
COMMENT ON COLUMN "T_BILL_ITEM"."COMBINED_TAX_CODE" IS '合并税务编码';
COMMENT ON COLUMN "T_BILL_ITEM"."VOUCHER_ACCOUNTING_YEAR" IS '参考凭证会计年度';
COMMENT ON COLUMN "T_BILL_ITEM"."VOUCHER_NO" IS '参考凭证的凭证号';
COMMENT ON COLUMN "T_BILL_ITEM"."VOUCHER_PROJECT" IS '参考凭证项目';
COMMENT ON COLUMN "T_BILL_ITEM"."AGREEMENT_NO" IS '协议号';
COMMENT ON COLUMN "T_BILL_ITEM"."AGREEMENT_DATE" IS '协议日期';
COMMENT ON COLUMN "T_BILL_ITEM"."AGREEMENT_ITEM_NO" IS '协议行号';
COMMENT ON COLUMN "T_BILL_ITEM"."SPARE_DATE" IS '备用日期字段';
COMMENT ON COLUMN "T_BILL_ITEM"."ABOLISH_STATUS" IS '单据状态(0=未回写,1=已作废,2=已回写)';
COMMENT ON TABLE "T_BILL_ITEM" IS '采购结算管理-开票清单行';

-- ----------------------------
-- Table structure for T_BILL_LETTER
-- ----------------------------
-- DROP TABLE "T_BILL_LETTER";
CREATE TABLE "T_BILL_LETTER" (
  "ID" VARCHAR2(32 CHAR) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(255 CHAR) ,
  "PUR_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) ,
  "PUR_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "PUR_COMPANY_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 CHAR) ,
  "CONFIRM_STATUS" NUMBER(7) ,
  "ATTACHMENT_TYPE" NUMBER(7) DEFAULT NULL ,
  "COMPANY_CODE" VARCHAR2(255 CHAR) ,
  "COMPANY_NAME" VARCHAR2(255 CHAR) ,
  "PAY_AMOUNT" NUMBER(15,2) ,
  "RECEIVE_AMOUNT" NUMBER(15,2) ,
  "BAIL_AMOUNT" NUMBER(15,2) ,
  "START_TIME" DATE ,
  "END_TIME" DATE ,
  "ATTACHMENT" VARCHAR2(2048 CHAR) ,
  "REMARK" VARCHAR2(2048 CHAR) ,
  "IS_ENABLE" NUMBER(7) ,
  "CREATE_TIME" DATE ,
  "CREATE_USER" VARCHAR2(255 CHAR) ,
  "UPDATE_TIME" DATE ,
  "UPDATE_USER" VARCHAR2(255 CHAR) ,
  "SPARE_FIELD1" NUMBER(7) ,
  "SPARE_FIELD2" VARCHAR2(255 CHAR) ,
  "SPARE_FIELD3" VARCHAR2(255 CHAR) ,
  "SPARE_FIELD4" DATE ,
  "LETTER_NO" VARCHAR2(255 CHAR) ,
  "CREATE_USER_ID" VARCHAR2(32 CHAR) ,
  "SEND_STATUS" NUMBER(7)
);

COMMENT ON COLUMN "T_BILL_LETTER"."ID" IS '主键';
COMMENT ON COLUMN "T_BILL_LETTER"."PROJECT_ID" IS '表的项目ID';
COMMENT ON COLUMN "T_BILL_LETTER"."PUR_COMPANY_ID" IS '采购商ID';
COMMENT ON COLUMN "T_BILL_LETTER"."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN "T_BILL_LETTER"."PUR_COMPANY_SAP_CODE" IS '采购商SAP编码';
COMMENT ON COLUMN "T_BILL_LETTER"."PUR_COMPANY_FULL_NAME" IS '采购商全称';
COMMENT ON COLUMN "T_BILL_LETTER"."PUR_COMPANY_NAME" IS '采购商简称';
COMMENT ON COLUMN "T_BILL_LETTER"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BILL_LETTER"."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BILL_LETTER"."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN "T_BILL_LETTER"."SUP_COMPANY_FULL_NAME" IS '供应商全称';
COMMENT ON COLUMN "T_BILL_LETTER"."SUP_COMPANY_NAME" IS '供应商简称';
COMMENT ON COLUMN "T_BILL_LETTER"."CONFIRM_STATUS" IS '确认状态 （0=未确认，1=供应商已确认，2=采购方已确认，3=采购方退回）';
COMMENT ON COLUMN "T_BILL_LETTER"."ATTACHMENT_TYPE" IS '是否有差异 (0=无差异，1=有差异)';
COMMENT ON COLUMN "T_BILL_LETTER"."COMPANY_CODE" IS '公司代码';
COMMENT ON COLUMN "T_BILL_LETTER"."COMPANY_NAME" IS '公司名称';
COMMENT ON COLUMN "T_BILL_LETTER"."PAY_AMOUNT" IS '应付款项余额';
COMMENT ON COLUMN "T_BILL_LETTER"."RECEIVE_AMOUNT" IS '应收款项余额';
COMMENT ON COLUMN "T_BILL_LETTER"."BAIL_AMOUNT" IS '保证金余额';
COMMENT ON COLUMN "T_BILL_LETTER"."START_TIME" IS '开始时间';
COMMENT ON COLUMN "T_BILL_LETTER"."END_TIME" IS '截止时间';
COMMENT ON COLUMN "T_BILL_LETTER"."ATTACHMENT" IS '附件';
COMMENT ON COLUMN "T_BILL_LETTER"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BILL_LETTER"."IS_ENABLE" IS '是否可用（0=不可用，1=可用）';
COMMENT ON COLUMN "T_BILL_LETTER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BILL_LETTER"."CREATE_USER" IS '创建人';
COMMENT ON COLUMN "T_BILL_LETTER"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "T_BILL_LETTER"."UPDATE_USER" IS '修改人';
COMMENT ON COLUMN "T_BILL_LETTER"."SPARE_FIELD1" IS '备用状态值';
COMMENT ON COLUMN "T_BILL_LETTER"."SPARE_FIELD2" IS '备用';
COMMENT ON COLUMN "T_BILL_LETTER"."SPARE_FIELD3" IS '备用';
COMMENT ON COLUMN "T_BILL_LETTER"."SPARE_FIELD4" IS '备用日期';
COMMENT ON COLUMN "T_BILL_LETTER"."LETTER_NO" IS '对账函号';
COMMENT ON COLUMN "T_BILL_LETTER"."CREATE_USER_ID" IS '建函人ID';
COMMENT ON COLUMN "T_BILL_LETTER"."SEND_STATUS" IS '发送状态（0=未发送，1=已发送）';
COMMENT ON TABLE "T_BILL_LETTER" IS '对账函';

-- ----------------------------
-- Table structure for T_BILL_MATERIAL_RELATION
-- ----------------------------
-- DROP TABLE "T_BILL_MATERIAL_RELATION";
CREATE TABLE "T_BILL_MATERIAL_RELATION" (
  "ID" VARCHAR2(32 CHAR) NOT NULL ,
  "COMBINED_TAX_CODE" VARCHAR2(255 CHAR) ,
  "GOODSANDLABOR_NAME" VARCHAR2(255 CHAR) ,
  "REMARK" VARCHAR2(4000 BYTE) ,
  "KEYWORD" VARCHAR2(4000 CHAR)
);
COMMENT ON COLUMN "T_BILL_MATERIAL_RELATION"."ID" IS '主键';
COMMENT ON COLUMN "T_BILL_MATERIAL_RELATION"."COMBINED_TAX_CODE" IS '合并编码';
COMMENT ON COLUMN "T_BILL_MATERIAL_RELATION"."GOODSANDLABOR_NAME" IS '货物和劳务名称';
COMMENT ON COLUMN "T_BILL_MATERIAL_RELATION"."REMARK" IS '说明';
COMMENT ON COLUMN "T_BILL_MATERIAL_RELATION"."KEYWORD" IS '关键字';
COMMENT ON TABLE "T_BILL_MATERIAL_RELATION" IS '税务分类码维护（供应商）';

-- ----------------------------
-- Table structure for T_BILL_PAYMENT
-- ----------------------------
-- DROP TABLE "T_BILL_PAYMENT";
CREATE TABLE "T_BILL_PAYMENT" (
  "ID" VARCHAR2(32 CHAR) NOT NULL ,
  "PUR_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) ,
  "PUR_COMPANY_NAME" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) ,
  "BANK_NAME" VARCHAR2(255 CHAR) ,
  "BANK_ADDRESS" VARCHAR2(255 CHAR) ,
  "BANK_ACCOUNT" VARCHAR2(255 CHAR) ,
  "PAYMENT_NO" VARCHAR2(32 CHAR) ,
  "PAYMENT_STATUS" NUMBER(11) ,
  "PAYMENT_TYPE" VARCHAR2(32 CHAR) ,
  "PAYMENT_TIME" DATE ,
  "APPLIED_AMOUNT" NUMBER ,
  "PAYMENT_DESC" VARCHAR2(2048 CHAR) ,
  "ASSIGNED_NO" VARCHAR2(32 CHAR) ,
  "INVOICE_NO" VARCHAR2(32 CHAR) ,
  "INVOICE_TEXT" VARCHAR2(32 CHAR) ,
  "INVOICE_AMOUNT" NUMBER ,
  "VOUCHER_TIME" DATE ,
  "CREATE_TIME" DATE ,
  "FISCAL_YEAR" NUMBER(11)
);
COMMENT ON COLUMN "T_BILL_PAYMENT"."ID" IS '主键ID';
COMMENT ON COLUMN "T_BILL_PAYMENT"."PUR_COMPANY_ID" IS '采购商公司ID';
COMMENT ON COLUMN "T_BILL_PAYMENT"."PUR_COMPANY_SRM_CODE" IS '采购商公司SRM编码';
COMMENT ON COLUMN "T_BILL_PAYMENT"."PUR_COMPANY_SAP_CODE" IS '采购商公司SAP编码';
COMMENT ON COLUMN "T_BILL_PAYMENT"."PUR_COMPANY_NAME" IS '采购商公司名称';
COMMENT ON COLUMN "T_BILL_PAYMENT"."PUR_COMPANY_FULL_NAME" IS '采购商公司全称';
COMMENT ON COLUMN "T_BILL_PAYMENT"."SUP_COMPANY_ID" IS '供应商公司ID';
COMMENT ON COLUMN "T_BILL_PAYMENT"."SUP_COMPANY_NAME" IS '供应商公司名称';
COMMENT ON COLUMN "T_BILL_PAYMENT"."SUP_COMPANY_FULL_NAME" IS '供应商公司全称';
COMMENT ON COLUMN "T_BILL_PAYMENT"."SUP_COMPANY_SRM_CODE" IS '供应商公司SRM编码';
COMMENT ON COLUMN "T_BILL_PAYMENT"."SUP_COMPANY_SAP_CODE" IS '供应商公司SAP编码';
COMMENT ON COLUMN "T_BILL_PAYMENT"."BANK_NAME" IS '供应商公司SAP编码';
COMMENT ON COLUMN "T_BILL_PAYMENT"."BANK_ADDRESS" IS '供应商公司SAP编码';
COMMENT ON COLUMN "T_BILL_PAYMENT"."BANK_ACCOUNT" IS '供应商公司SAP编码';
COMMENT ON COLUMN "T_BILL_PAYMENT"."PAYMENT_NO" IS '支付申请号';
COMMENT ON COLUMN "T_BILL_PAYMENT"."PAYMENT_STATUS" IS '支付状态';
COMMENT ON COLUMN "T_BILL_PAYMENT"."PAYMENT_TYPE" IS '支付形式';
COMMENT ON COLUMN "T_BILL_PAYMENT"."PAYMENT_TIME" IS '支付时间-支付日期';
COMMENT ON COLUMN "T_BILL_PAYMENT"."APPLIED_AMOUNT" IS '申请金额';
COMMENT ON COLUMN "T_BILL_PAYMENT"."PAYMENT_DESC" IS '支付描述（总账标志描述）';
COMMENT ON COLUMN "T_BILL_PAYMENT"."ASSIGNED_NO" IS '分配号';
COMMENT ON COLUMN "T_BILL_PAYMENT"."INVOICE_NO" IS '系统发票-供应商发票号';
COMMENT ON COLUMN "T_BILL_PAYMENT"."INVOICE_TEXT" IS '系统发票文本';
COMMENT ON COLUMN "T_BILL_PAYMENT"."INVOICE_AMOUNT" IS '发票凭证金额';
COMMENT ON COLUMN "T_BILL_PAYMENT"."VOUCHER_TIME" IS '凭证日期';
COMMENT ON COLUMN "T_BILL_PAYMENT"."CREATE_TIME" IS '创建时间--支付申请单创建日期';
COMMENT ON COLUMN "T_BILL_PAYMENT"."FISCAL_YEAR" IS '会计年度';

-- ----------------------------
-- Table structure for T_BILL_PUR_VOUCHER
-- ----------------------------
-- DROP TABLE "T_BILL_PUR_VOUCHER";
CREATE TABLE "T_BILL_PUR_VOUCHER" (
  "ID" VARCHAR2(32 CHAR) DEFAULT '' NOT NULL ,
  "PUR_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) ,
  "PUR_COMPANY_NAME" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) ,
  "DELIVERY_ORDER_NO" VARCHAR2(32 CHAR) ,
  "DELIVERY_ORDER_ITEM_NO" VARCHAR2(32 CHAR) ,
  "PURCHASE_ORDER_NO" VARCHAR2(32 CHAR) ,
  "PURCHASE_ORDER_ITEM_NO" VARCHAR2(32 CHAR) ,
  "MATERIAL_ID" VARCHAR2(32 CHAR) ,
  "MATERIAL_NO" VARCHAR2(32 CHAR) ,
  "MATERIAL_DESC" VARCHAR2(255 CHAR) ,
  "MATERIAL_QUANTITY" NUMBER(11,1) ,
  "MATERIAL_VOUCHER_NO" VARCHAR2(32 CHAR) ,
  "MATERIAL_VOUCHER_ITEM_NO" VARCHAR2(32 CHAR) ,
  "POSTING_TIME" DATE ,
  "CURRENCY_TYPE" VARCHAR2(32 CHAR) ,
  "BILL_TYPE" VARCHAR2(32 CHAR) ,
  "BILL_FLAG" NUMBER(11) DEFAULT 0   ,
  "IS_ENABLE" NUMBER(11) DEFAULT 0   ,
  "FACTORY" VARCHAR2(255 CHAR) ,
  "PROJECT_TYPES" VARCHAR2(255 CHAR) ,
  "TAX_RATE" NUMBER(11,2) ,
  "NOT_INCLUDE_TAX_AMOUNT" NUMBER(13,4) ,
  "INCLUDE_TAX_AMOUNT" NUMBER(13,4) ,
  "TAX_AMOUNT" NUMBER(13,4) ,
  "LATEST_PRICE" NUMBER(11,2) ,
  "ORDER_PRICE" NUMBER(11,2) ,
  "ORDER_AMOUNT" NUMBER(11,2) ,
  "TAX_CODE" VARCHAR2(255 CHAR) ,
  "MATERIAL_UNIT" VARCHAR2(255 CHAR) ,
  "ACCOUNTING_YEAR" VARCHAR2(255 CHAR) ,
  "VOUCHER_TIME" DATE ,
  "INPUT_DATE" DATE ,
  "INPUT_TIME" DATE ,
  "STOCK_SPACE_CODE" VARCHAR2(255 CHAR) ,
  "STOCK_SPACE_REMARK" VARCHAR2(255 CHAR) ,
  "COMPANY" VARCHAR2(255 CHAR) ,
  "QUANTITY" NUMBER(7,1) ,
  "ELEMENTARY_ENTITY" VARCHAR2(255 CHAR) ,
  "USER_NAME" VARCHAR2(255 CHAR) ,
  "PAYMENT_WAY" VARCHAR2(255 CHAR) ,
  "MARK" VARCHAR2(255 CHAR) ,
  "PRICE_ENTITY" NUMBER(11) ,
  "GOODSANDLABOR_NAME" VARCHAR2(255 CHAR) ,
  "COMBINED_TAX_CODE" VARCHAR2(255 CHAR) ,
  "VOUCHER_ACCOUNTING_YEAR" VARCHAR2(255 CHAR) ,
  "VOUCHER_NO" VARCHAR2(255 BYTE) ,
  "VOUCHER_PROJECT" VARCHAR2(255 CHAR) ,
  "CREATE_TIME" DATE ,
  "PRICE_UNIT" NUMBER(15,2)
);
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."ID" IS '主键ID';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."PUR_COMPANY_ID" IS '采购商公司ID';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."PUR_COMPANY_SRM_CODE" IS '采购商公司SRM编码';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."PUR_COMPANY_SAP_CODE" IS '采购商公司SAP编码';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."PUR_COMPANY_NAME" IS '采购商公司名称';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."PUR_COMPANY_FULL_NAME" IS '采购商公司全称';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."SUP_COMPANY_ID" IS '供应商公司ID';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."SUP_COMPANY_NAME" IS '供应商公司名称';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."SUP_COMPANY_FULL_NAME" IS '供应商公司全称';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."SUP_COMPANY_SRM_CODE" IS '供应商公司SRM编码';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."SUP_COMPANY_SAP_CODE" IS '供应商公司SAP编码';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."DELIVERY_ORDER_NO" IS '送货单号';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."DELIVERY_ORDER_ITEM_NO" IS '送货单行号';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."PURCHASE_ORDER_NO" IS '采购单号';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."PURCHASE_ORDER_ITEM_NO" IS '采购单行号';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."MATERIAL_ID" IS '物料ID';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."MATERIAL_NO" IS '物料编码';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."MATERIAL_QUANTITY" IS '物料数量';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."MATERIAL_VOUCHER_NO" IS '物料凭证号';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."MATERIAL_VOUCHER_ITEM_NO" IS '物料凭证行号';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."POSTING_TIME" IS '过账日期-sap入退库，折让单时间';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."CURRENCY_TYPE" IS '货币类型';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."BILL_TYPE" IS '移动类型';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."BILL_FLAG" IS '是否对账(已对账=1，未对账=0)';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."IS_ENABLE" IS '记录是否可用(可用=1，不可用=0)';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."FACTORY" IS '工厂';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."PROJECT_TYPES" IS '采购组织';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."TAX_RATE" IS '税率';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."NOT_INCLUDE_TAX_AMOUNT" IS '开票未税金额';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."INCLUDE_TAX_AMOUNT" IS '开票含税金额';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."TAX_AMOUNT" IS '开票税额';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."LATEST_PRICE" IS '最新采购信息记录价格';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."ORDER_PRICE" IS '单价';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."ORDER_AMOUNT" IS '订单总金额';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."TAX_CODE" IS '税码';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."MATERIAL_UNIT" IS '物料单位';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."ACCOUNTING_YEAR" IS '会计年度';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."VOUCHER_TIME" IS '凭证日期';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."INPUT_DATE" IS '输入日期';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."INPUT_TIME" IS '采购凭证日期';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."STOCK_SPACE_CODE" IS '库存地点编码';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."STOCK_SPACE_REMARK" IS '库存地点描述';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."COMPANY" IS '公司';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."QUANTITY" IS '数量';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."ELEMENTARY_ENTITY" IS '基本单位';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."USER_NAME" IS '用户名';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."PAYMENT_WAY" IS '付款方式';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."MARK" IS '符号';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."PRICE_ENTITY" IS '暂估价单位（1=暂估价）';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."GOODSANDLABOR_NAME" IS '货物和劳务名称';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."COMBINED_TAX_CODE" IS '合并税务编码';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."VOUCHER_ACCOUNTING_YEAR" IS '参考凭证会计年度';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."VOUCHER_NO" IS '参考凭证的凭证号';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."VOUCHER_PROJECT" IS '参考凭证项目';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."CREATE_TIME" IS '获取时间';
COMMENT ON COLUMN "T_BILL_PUR_VOUCHER"."PRICE_UNIT" IS '价格单位';
COMMENT ON TABLE "T_BILL_PUR_VOUCHER" IS '收货凭证表';

-- ----------------------------
-- Table structure for T_BILL_SUP_GROUP
-- ----------------------------
-- DROP TABLE "T_BILL_SUP_GROUP";
CREATE TABLE "T_BILL_SUP_GROUP" (
  "ID" VARCHAR2(32 CHAR) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(255 CHAR) ,
  "PUR_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) ,
  "PUR_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "PUR_COMPANY_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 CHAR) ,
  "SUP_GROUP_NAME" VARCHAR2(255 CHAR) ,
  "SUP_GROUP_DESC" VARCHAR2(255 CHAR) ,
  "CREATE_TIME" DATE ,
  "CREATE_USER" VARCHAR2(255 CHAR) ,
  "UPDATE_TIME" DATE ,
  "UPDATE_USER" VARCHAR2(255 CHAR) ,
  "REMARK" VARCHAR2(255 CHAR) ,
  "IS_ENABLE" NUMBER(7)
);
COMMENT ON COLUMN "T_BILL_SUP_GROUP"."ID" IS '主键';
COMMENT ON COLUMN "T_BILL_SUP_GROUP"."PROJECT_ID" IS '表的项目ID';
COMMENT ON COLUMN "T_BILL_SUP_GROUP"."PUR_COMPANY_ID" IS '采购商ID';
COMMENT ON COLUMN "T_BILL_SUP_GROUP"."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN "T_BILL_SUP_GROUP"."PUR_COMPANY_SAP_CODE" IS '采购商SAP编码';
COMMENT ON COLUMN "T_BILL_SUP_GROUP"."PUR_COMPANY_FULL_NAME" IS '采购商全称';
COMMENT ON COLUMN "T_BILL_SUP_GROUP"."PUR_COMPANY_NAME" IS '采购商简称';
COMMENT ON COLUMN "T_BILL_SUP_GROUP"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BILL_SUP_GROUP"."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BILL_SUP_GROUP"."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN "T_BILL_SUP_GROUP"."SUP_COMPANY_FULL_NAME" IS '供应商全称';
COMMENT ON COLUMN "T_BILL_SUP_GROUP"."SUP_COMPANY_NAME" IS '供应商简称';
COMMENT ON COLUMN "T_BILL_SUP_GROUP"."SUP_GROUP_NAME" IS '组名称';
COMMENT ON COLUMN "T_BILL_SUP_GROUP"."SUP_GROUP_DESC" IS '组描述';
COMMENT ON COLUMN "T_BILL_SUP_GROUP"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BILL_SUP_GROUP"."CREATE_USER" IS '创建人';
COMMENT ON COLUMN "T_BILL_SUP_GROUP"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "T_BILL_SUP_GROUP"."UPDATE_USER" IS '修改人';
COMMENT ON COLUMN "T_BILL_SUP_GROUP"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BILL_SUP_GROUP"."IS_ENABLE" IS '是否可用（0=不可用，1=可用）';
COMMENT ON TABLE "T_BILL_SUP_GROUP" IS '供应商组设置';

-- ----------------------------
-- Table structure for T_BILL_SUP_GROUP_REF
-- ----------------------------
-- DROP TABLE "T_BILL_SUP_GROUP_REF";
CREATE TABLE "T_BILL_SUP_GROUP_REF" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "ACCOUNT_GROUP" VARCHAR2(255 CHAR) ,
  "ACCOUNT_GROUP_DESC" VARCHAR2(255 CHAR)
);
COMMENT ON COLUMN "T_BILL_SUP_GROUP_REF"."ACCOUNT_GROUP" IS '账户组';
COMMENT ON COLUMN "T_BILL_SUP_GROUP_REF"."ACCOUNT_GROUP_DESC" IS '账户组描述';
COMMENT ON TABLE "T_BILL_SUP_GROUP_REF" IS '供应商账户组信息';

-- ----------------------------
-- Table structure for T_BILL_SWITCH
-- ----------------------------
-- DROP TABLE "T_BILL_SWITCH";
CREATE TABLE "T_BILL_SWITCH" (
  "ID" VARCHAR2(32 CHAR) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) ,
  "PUR_COMPANY_NAME" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "PUR_USER_ID" VARCHAR2(32 CHAR) ,
  "PUR_USER_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) ,
  "SUP_USER_ID" VARCHAR2(32 CHAR) ,
  "SUP_USER_NAME" VARCHAR2(255 CHAR) ,
  "IS_ENABLE" NUMBER(11) ,
  "SWITCH_FLAG" NUMBER(11) ,
  "CREATE_TIME" DATE ,
  "UPDATE_TIME" DATE ,
  "START_TIME" NUMBER(11) ,
  "END_TIME" NUMBER(11) ,
  "CATEGORY_NO" VARCHAR2(32 CHAR) ,
  "CATEGORY_NAME" VARCHAR2(255 CHAR) ,
  "VOUCHER_START_TIME" DATE ,
  "VOUCHER_END_TIME" DATE
);
COMMENT ON COLUMN "T_BILL_SWITCH"."ID" IS '主键ID';
COMMENT ON COLUMN "T_BILL_SWITCH"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BILL_SWITCH"."PUR_COMPANY_ID" IS '采购商公司ID';
COMMENT ON COLUMN "T_BILL_SWITCH"."PUR_COMPANY_SRM_CODE" IS '采购商公司SRM编码';
COMMENT ON COLUMN "T_BILL_SWITCH"."PUR_COMPANY_SAP_CODE" IS '采购商公司SAP编码';
COMMENT ON COLUMN "T_BILL_SWITCH"."PUR_COMPANY_NAME" IS '采购商公司名称';
COMMENT ON COLUMN "T_BILL_SWITCH"."PUR_COMPANY_FULL_NAME" IS '采购商公司全称';
COMMENT ON COLUMN "T_BILL_SWITCH"."PUR_USER_ID" IS '采购用户ID';
COMMENT ON COLUMN "T_BILL_SWITCH"."PUR_USER_NAME" IS '采购用户名称';
COMMENT ON COLUMN "T_BILL_SWITCH"."SUP_COMPANY_ID" IS '供应商公司ID';
COMMENT ON COLUMN "T_BILL_SWITCH"."SUP_COMPANY_NAME" IS '供应商公司名称';
COMMENT ON COLUMN "T_BILL_SWITCH"."SUP_COMPANY_FULL_NAME" IS '供应商公司全称';
COMMENT ON COLUMN "T_BILL_SWITCH"."SUP_COMPANY_SRM_CODE" IS '供应商公司SRM编码';
COMMENT ON COLUMN "T_BILL_SWITCH"."SUP_COMPANY_SAP_CODE" IS '供应商公司SAP编码';
COMMENT ON COLUMN "T_BILL_SWITCH"."SUP_USER_ID" IS '供应商用户ID';
COMMENT ON COLUMN "T_BILL_SWITCH"."SUP_USER_NAME" IS '供应商用户名称';
COMMENT ON COLUMN "T_BILL_SWITCH"."IS_ENABLE" IS '记录是否可用(可用=1，不可用=0)';
COMMENT ON COLUMN "T_BILL_SWITCH"."SWITCH_FLAG" IS '开账开关（0=不开启，1=开启）';
COMMENT ON COLUMN "T_BILL_SWITCH"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BILL_SWITCH"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BILL_SWITCH"."START_TIME" IS '供应商开账开始时间（每月多少号）';
COMMENT ON COLUMN "T_BILL_SWITCH"."END_TIME" IS '供应商开账结束时间（每月多少号）';
COMMENT ON COLUMN "T_BILL_SWITCH"."CATEGORY_NO" IS '供应商分组编码';
COMMENT ON COLUMN "T_BILL_SWITCH"."CATEGORY_NAME" IS '供应商分组名称';
COMMENT ON COLUMN "T_BILL_SWITCH"."VOUCHER_START_TIME" IS '限制凭证开始时间';
COMMENT ON COLUMN "T_BILL_SWITCH"."VOUCHER_END_TIME" IS '限制凭证结束日期';

-- ----------------------------
-- Table structure for T_BILL_TAX_CLASSIFY
-- ----------------------------
-- DROP TABLE "T_BILL_TAX_CLASSIFY";
CREATE TABLE "T_BILL_TAX_CLASSIFY" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 CHAR) ,
  "SUP_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 CHAR) ,
  "GOODSANDLABOR_NAME" VARCHAR2(255 CHAR) ,
  "COMBINED_TAX_CODE" VARCHAR2(255 CHAR) ,
  "CUSTOMER_SRM_ID" VARCHAR2(32 CHAR) ,
  "CUSTOMER_SRM_CODE" VARCHAR2(255 CHAR) ,
  "CUSTOMER_SRM_COMPANY_NAME" VARCHAR2(255 CHAR) ,
  "CUSTOMER_MATERIAL_NO" VARCHAR2(255 CHAR) ,
  "CUSTOMER_MATERIAL_DESC" VARCHAR2(255 CHAR) ,
  "MATERIAL_NO" VARCHAR2(255 CHAR) ,
  "MATERIAL_DESC" VARCHAR2(255 CHAR) ,
  "OPERATE_USER_ID" VARCHAR2(32 CHAR) ,
  "OPERATE_USER_NAME" VARCHAR2(255 CHAR) ,
  "CREATE_TIME" DATE ,
  "UPDATE_TIME" DATE ,
  "REMARK" VARCHAR2(255 CHAR) ,
  "IS_ENABLE" NUMBER(7) DEFAULT 1   ,
  "TAX_CODING_INSTRUCTIONS" VARCHAR2(255 CHAR)
);
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."ID" IS '主键';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."PROJECT_ID" IS '表的项目ID';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."SUP_COMPANY_FULL_NAME" IS '供应商全称';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."SUP_COMPANY_NAME" IS '供应商简称';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."GOODSANDLABOR_NAME" IS '货物和劳务名称';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."COMBINED_TAX_CODE" IS '合并税务编码';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."CUSTOMER_SRM_ID" IS '客户srmID';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."CUSTOMER_SRM_CODE" IS '客户srm账号';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."CUSTOMER_SRM_COMPANY_NAME" IS '客户名称';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."CUSTOMER_MATERIAL_NO" IS '客户物料编号';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."CUSTOMER_MATERIAL_DESC" IS '客户物料描述';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."MATERIAL_NO" IS '物料编号';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."OPERATE_USER_ID" IS '操作人id';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."OPERATE_USER_NAME" IS '操作人名称';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."CREATE_TIME" IS '新建时间';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY"."TAX_CODING_INSTRUCTIONS" IS '税务编码说明';
COMMENT ON TABLE "T_BILL_TAX_CLASSIFY" IS '对账单-税务分类码维护';

-- ----------------------------
-- Table structure for T_BILL_TAX_CLASSIFY_MAT
-- ----------------------------
-- DROP TABLE "T_BILL_TAX_CLASSIFY_MAT";
CREATE TABLE "T_BILL_TAX_CLASSIFY_MAT" (
  "ID" VARCHAR2(32 CHAR) NOT NULL ,
  "TAX_ID" VARCHAR2(32 CHAR) ,
  "CUSTOMER_MATERIAL_NO" VARCHAR2(255 CHAR) ,
  "CUSTOMER_MATERIAL_DESC" VARCHAR2(255 CHAR)
);
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY_MAT"."ID" IS '主键';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY_MAT"."TAX_ID" IS '税务分类关联ID';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY_MAT"."CUSTOMER_MATERIAL_NO" IS '客户物料编号';
COMMENT ON COLUMN "T_BILL_TAX_CLASSIFY_MAT"."CUSTOMER_MATERIAL_DESC" IS '客户物料描述';
COMMENT ON TABLE "T_BILL_TAX_CLASSIFY_MAT" IS '税务分类客户物料码';

-- ----------------------------
-- Table structure for T_BILL_USER_INFO
-- ----------------------------
-- DROP TABLE "T_BILL_USER_INFO";
CREATE TABLE "T_BILL_USER_INFO" (
  "ID" VARCHAR2(32 CHAR) NOT NULL ,
  "COMPANY_CODE" VARCHAR2(255 CHAR) ,
  "COMPANY_NAME" VARCHAR2(255 CHAR) ,
  "BUSINESS_TYPE" VARCHAR2(255 CHAR) ,
  "BILL_CONTACT" VARCHAR2(255 CHAR) ,
  "BILL_CONTACT_TEL" VARCHAR2(255 CHAR) ,
  "INVOICE_ADDRESS" VARCHAR2(255 CHAR) ,
  "RECEIVE_USER" VARCHAR2(255 CHAR) ,
  "RECEIVE_USER_TEL" VARCHAR2(255 CHAR) ,
  "REMARK" VARCHAR2(255 CHAR) ,
  "IS_ENABLE" NUMBER(7) ,
  "CREATE_TIME" DATE ,
  "CREATE_USER" VARCHAR2(255 CHAR) ,
  "UPDATE_TIME" DATE ,
  "UPDATE_USER" VARCHAR2(255 CHAR) ,
  "SPARE_FIELD1" NUMBER(7) ,
  "SPARE_FIELD2" VARCHAR2(255 CHAR) ,
  "SPARE_FIELD3" VARCHAR2(255 CHAR) ,
  "SPARE_FIELD4" DATE
);
COMMENT ON COLUMN "T_BILL_USER_INFO"."ID" IS '主键';
COMMENT ON COLUMN "T_BILL_USER_INFO"."COMPANY_CODE" IS '公司代码';
COMMENT ON COLUMN "T_BILL_USER_INFO"."COMPANY_NAME" IS '公司名称';
COMMENT ON COLUMN "T_BILL_USER_INFO"."BUSINESS_TYPE" IS '业务分类';
COMMENT ON COLUMN "T_BILL_USER_INFO"."BILL_CONTACT" IS '对账联系人';
COMMENT ON COLUMN "T_BILL_USER_INFO"."BILL_CONTACT_TEL" IS '联系电话';
COMMENT ON COLUMN "T_BILL_USER_INFO"."INVOICE_ADDRESS" IS '发票邮寄地址';
COMMENT ON COLUMN "T_BILL_USER_INFO"."RECEIVE_USER" IS '邮件收件人';
COMMENT ON COLUMN "T_BILL_USER_INFO"."RECEIVE_USER_TEL" IS '收件人电话';
COMMENT ON COLUMN "T_BILL_USER_INFO"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BILL_USER_INFO"."IS_ENABLE" IS '是否可用（0=不可用，1=可用）';
COMMENT ON COLUMN "T_BILL_USER_INFO"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BILL_USER_INFO"."CREATE_USER" IS '创建人';
COMMENT ON COLUMN "T_BILL_USER_INFO"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "T_BILL_USER_INFO"."UPDATE_USER" IS '修改人';
COMMENT ON COLUMN "T_BILL_USER_INFO"."SPARE_FIELD1" IS '备用状态值（number）';
COMMENT ON COLUMN "T_BILL_USER_INFO"."SPARE_FIELD2" IS '备用';
COMMENT ON COLUMN "T_BILL_USER_INFO"."SPARE_FIELD3" IS '备用';
COMMENT ON COLUMN "T_BILL_USER_INFO"."SPARE_FIELD4" IS '备用';
COMMENT ON TABLE "T_BILL_USER_INFO" IS '对账人员信息表';

-- ----------------------------
-- Table structure for T_BILL_VOUCHER
-- ----------------------------
-- DROP TABLE "T_BILL_VOUCHER";
CREATE TABLE "T_BILL_VOUCHER" (
  "ID" VARCHAR2(32 CHAR) DEFAULT '' NOT NULL ,
  "PUR_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) ,
  "PUR_COMPANY_NAME" VARCHAR2(32 CHAR) ,
  "PUR_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 CHAR) ,
  "SUP_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) ,
  "DELIVERY_ORDER_NO" VARCHAR2(32 CHAR) ,
  "DELIVERY_ORDER_ITEM_NO" VARCHAR2(32 CHAR) ,
  "PURCHASE_ORDER_NO" VARCHAR2(32 CHAR) ,
  "PURCHASE_ORDER_ITEM_NO" VARCHAR2(32 CHAR) ,
  "MATERIAL_ID" VARCHAR2(32 CHAR) ,
  "MATERIAL_NO" VARCHAR2(32 CHAR) ,
  "MATERIAL_DESC" VARCHAR2(255 CHAR) ,
  "MATERIAL_QUANTITY" NUMBER(13,3) ,
  "MATERIAL_VOUCHER_NO" VARCHAR2(32 CHAR) ,
  "MATERIAL_VOUCHER_ITEM_NO" VARCHAR2(32 CHAR) ,
  "POSTING_TIME" DATE ,
  "CURRENCY_TYPE" VARCHAR2(32 CHAR) ,
  "BILL_TYPE" VARCHAR2(32 CHAR) ,
  "BILL_FLAG" NUMBER(11) DEFAULT 0   ,
  "IS_ENABLE" NUMBER(11) DEFAULT 0   ,
  "FACTORY" VARCHAR2(255 CHAR) ,
  "PROJECT_TYPES" VARCHAR2(255 CHAR) ,
  "TAX_RATE" NUMBER(11,2) ,
  "NOT_INCLUDE_TAX_AMOUNT" NUMBER(13,4) ,
  "INCLUDE_TAX_AMOUNT" NUMBER(13,4) ,
  "TAX_AMOUNT" NUMBER(13,4) ,
  "LATEST_PRICE" NUMBER(13,4) ,
  "ORDER_PRICE" NUMBER(13,4) ,
  "ORDER_AMOUNT" NUMBER(11,2) ,
  "TAX_CODE" VARCHAR2(255 CHAR) ,
  "MATERIAL_UNIT" VARCHAR2(255 CHAR) ,
  "ACCOUNTING_YEAR" VARCHAR2(255 CHAR) ,
  "VOUCHER_TIME" DATE ,
  "INPUT_DATE" DATE ,
  "INPUT_TIME" DATE ,
  "STOCK_SPACE_CODE" VARCHAR2(255 CHAR) ,
  "STOCK_SPACE_REMARK" VARCHAR2(255 CHAR) ,
  "COMPANY" VARCHAR2(255 CHAR) ,
  "QUANTITY" NUMBER(7,1) ,
  "ELEMENTARY_ENTITY" VARCHAR2(255 CHAR) ,
  "USER_NAME" VARCHAR2(255 CHAR) ,
  "PAYMENT_WAY" VARCHAR2(255 CHAR) ,
  "MARK" VARCHAR2(255 CHAR) ,
  "PRICE_ENTITY" NUMBER(11,1) ,
  "GOODSANDLABOR_NAME" VARCHAR2(255 CHAR) ,
  "COMBINED_TAX_CODE" VARCHAR2(255 CHAR) ,
  "VOUCHER_ACCOUNTING_YEAR" VARCHAR2(255 CHAR) ,
  "VOUCHER_NO" VARCHAR2(255 BYTE) ,
  "VOUCHER_PROJECT" VARCHAR2(255 CHAR) ,
  "IS_LATEST" NUMBER(7) ,
  "AGREEMENT_NO" VARCHAR2(255 CHAR) ,
  "AGREEMENT_DATE" DATE ,
  "AGREEMENT_ITEM_NO" VARCHAR2(255 CHAR),
  "TOTAL_GROUP_ID" VARCHAR2(50),
  "TOTAL_GROUP_NAME" VARCHAR2(50),
  "ACCOUNT_SET_ID" VARCHAR2(50),
  "ACCOUNT_SET_NAME" VARCHAR2(50),
  "ACCOUNT_CODE" VARCHAR2(50),
  "INSTITUTIONS_ID" VARCHAR2(50),
  "INSTITUTIONS_NAME" VARCHAR2(50),
  "IN_THE_ORGANIZATION_ID" VARCHAR2(50),
  "IN_THE_ORGANIZATION_NAME" VARCHAR2(50),
  "DEPART_ID" VARCHAR2(50),
  "DEPART_NAME" VARCHAR2(50)
);
COMMENT ON COLUMN "T_BILL_VOUCHER"."ID" IS '主键ID';
COMMENT ON COLUMN "T_BILL_VOUCHER"."PUR_COMPANY_ID" IS '采购商公司ID';
COMMENT ON COLUMN "T_BILL_VOUCHER"."PUR_COMPANY_SRM_CODE" IS '采购商公司SRM编码';
COMMENT ON COLUMN "T_BILL_VOUCHER"."PUR_COMPANY_SAP_CODE" IS '采购商公司SAP编码';
COMMENT ON COLUMN "T_BILL_VOUCHER"."PUR_COMPANY_NAME" IS '采购商公司名称';
COMMENT ON COLUMN "T_BILL_VOUCHER"."PUR_COMPANY_FULL_NAME" IS '采购商公司全称';
COMMENT ON COLUMN "T_BILL_VOUCHER"."SUP_COMPANY_ID" IS '供应商公司ID';
COMMENT ON COLUMN "T_BILL_VOUCHER"."SUP_COMPANY_NAME" IS '供应商公司名称';
COMMENT ON COLUMN "T_BILL_VOUCHER"."SUP_COMPANY_FULL_NAME" IS '供应商公司全称';
COMMENT ON COLUMN "T_BILL_VOUCHER"."SUP_COMPANY_SRM_CODE" IS '供应商公司SRM编码';
COMMENT ON COLUMN "T_BILL_VOUCHER"."SUP_COMPANY_SAP_CODE" IS '供应商公司SAP编码';
COMMENT ON COLUMN "T_BILL_VOUCHER"."DELIVERY_ORDER_NO" IS '送货单号';
COMMENT ON COLUMN "T_BILL_VOUCHER"."DELIVERY_ORDER_ITEM_NO" IS '送货单行号';
COMMENT ON COLUMN "T_BILL_VOUCHER"."PURCHASE_ORDER_NO" IS '采购单号';
COMMENT ON COLUMN "T_BILL_VOUCHER"."PURCHASE_ORDER_ITEM_NO" IS '采购单行号';
COMMENT ON COLUMN "T_BILL_VOUCHER"."MATERIAL_ID" IS '物料ID';
COMMENT ON COLUMN "T_BILL_VOUCHER"."MATERIAL_NO" IS '物料编码';
COMMENT ON COLUMN "T_BILL_VOUCHER"."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN "T_BILL_VOUCHER"."MATERIAL_QUANTITY" IS '物料数量';
COMMENT ON COLUMN "T_BILL_VOUCHER"."MATERIAL_VOUCHER_NO" IS '物料凭证号';
COMMENT ON COLUMN "T_BILL_VOUCHER"."MATERIAL_VOUCHER_ITEM_NO" IS '物料凭证行号';
COMMENT ON COLUMN "T_BILL_VOUCHER"."POSTING_TIME" IS '过账日期-sap入退库，折让单时间';
COMMENT ON COLUMN "T_BILL_VOUCHER"."CURRENCY_TYPE" IS '货币类型';
COMMENT ON COLUMN "T_BILL_VOUCHER"."BILL_TYPE" IS '移动类型';
COMMENT ON COLUMN "T_BILL_VOUCHER"."BILL_FLAG" IS '是否对账(已对账=1，未对账=0)';
COMMENT ON COLUMN "T_BILL_VOUCHER"."IS_ENABLE" IS '记录是否可用(可用=1，不可用=0)';
COMMENT ON COLUMN "T_BILL_VOUCHER"."FACTORY" IS '工厂';
COMMENT ON COLUMN "T_BILL_VOUCHER"."PROJECT_TYPES" IS '项目类别';
COMMENT ON COLUMN "T_BILL_VOUCHER"."TAX_RATE" IS '税率';
COMMENT ON COLUMN "T_BILL_VOUCHER"."NOT_INCLUDE_TAX_AMOUNT" IS '开票未税金额';
COMMENT ON COLUMN "T_BILL_VOUCHER"."INCLUDE_TAX_AMOUNT" IS '开票含税金额';
COMMENT ON COLUMN "T_BILL_VOUCHER"."TAX_AMOUNT" IS '开票税额';
COMMENT ON COLUMN "T_BILL_VOUCHER"."LATEST_PRICE" IS '最新采购信息记录价格';
COMMENT ON COLUMN "T_BILL_VOUCHER"."ORDER_PRICE" IS '单价';
COMMENT ON COLUMN "T_BILL_VOUCHER"."ORDER_AMOUNT" IS '订单总金额';
COMMENT ON COLUMN "T_BILL_VOUCHER"."TAX_CODE" IS '税码';
COMMENT ON COLUMN "T_BILL_VOUCHER"."MATERIAL_UNIT" IS '物料单位';
COMMENT ON COLUMN "T_BILL_VOUCHER"."ACCOUNTING_YEAR" IS '会计年度';
COMMENT ON COLUMN "T_BILL_VOUCHER"."VOUCHER_TIME" IS '凭证日期';
COMMENT ON COLUMN "T_BILL_VOUCHER"."INPUT_DATE" IS '输入日期';
COMMENT ON COLUMN "T_BILL_VOUCHER"."INPUT_TIME" IS '输入时间';
COMMENT ON COLUMN "T_BILL_VOUCHER"."STOCK_SPACE_CODE" IS '库存地点编码';
COMMENT ON COLUMN "T_BILL_VOUCHER"."STOCK_SPACE_REMARK" IS '库存地点描述';
COMMENT ON COLUMN "T_BILL_VOUCHER"."COMPANY" IS '公司';
COMMENT ON COLUMN "T_BILL_VOUCHER"."QUANTITY" IS '暂估价标示（1是，0否）';
COMMENT ON COLUMN "T_BILL_VOUCHER"."ELEMENTARY_ENTITY" IS '基本单位';
COMMENT ON COLUMN "T_BILL_VOUCHER"."USER_NAME" IS '用户名';
COMMENT ON COLUMN "T_BILL_VOUCHER"."PAYMENT_WAY" IS '付款方式';
COMMENT ON COLUMN "T_BILL_VOUCHER"."MARK" IS '符号';
COMMENT ON COLUMN "T_BILL_VOUCHER"."PRICE_ENTITY" IS '价格单位';
COMMENT ON COLUMN "T_BILL_VOUCHER"."GOODSANDLABOR_NAME" IS '货物和劳务名称';
COMMENT ON COLUMN "T_BILL_VOUCHER"."COMBINED_TAX_CODE" IS '合并税务编码';
COMMENT ON COLUMN "T_BILL_VOUCHER"."VOUCHER_ACCOUNTING_YEAR" IS '参考凭证会计年度';
COMMENT ON COLUMN "T_BILL_VOUCHER"."VOUCHER_NO" IS '参考凭证的凭证号';
COMMENT ON COLUMN "T_BILL_VOUCHER"."VOUCHER_PROJECT" IS '参考凭证项目';
COMMENT ON COLUMN "T_BILL_VOUCHER"."IS_LATEST" IS '是否最新获取（1=最新，0=不是最新）';
COMMENT ON COLUMN "T_BILL_VOUCHER"."AGREEMENT_NO" IS '协议号';
COMMENT ON COLUMN "T_BILL_VOUCHER"."AGREEMENT_DATE" IS '协议日期';
COMMENT ON COLUMN "T_BILL_VOUCHER"."AGREEMENT_ITEM_NO" IS '协议行号';
COMMENT ON COLUMN "T_BILL_VOUCHER"."TOTAL_GROUP_NAME" IS '总集团名称';
COMMENT ON COLUMN "T_BILL_VOUCHER"."ACCOUNT_SET_ID" IS '账套id';
COMMENT ON COLUMN "T_BILL_VOUCHER"."ACCOUNT_SET_NAME" IS '账套名称';
COMMENT ON COLUMN "T_BILL_VOUCHER"."ACCOUNT_CODE" IS '账套编码';
COMMENT ON COLUMN "T_BILL_VOUCHER"."INSTITUTIONS_ID" IS '机构id';
COMMENT ON COLUMN "T_BILL_VOUCHER"."INSTITUTIONS_NAME" IS '机构名称';
COMMENT ON COLUMN "T_BILL_VOUCHER"."IN_THE_ORGANIZATION_ID" IS '中支机构id';
COMMENT ON COLUMN "T_BILL_VOUCHER"."IN_THE_ORGANIZATION_NAME" IS '中支机构名称';
COMMENT ON COLUMN "T_BILL_VOUCHER"."DEPART_ID" IS '部门id';
COMMENT ON COLUMN "T_BILL_VOUCHER"."DEPART_NAME" IS '部门名称';

COMMENT ON TABLE "T_BILL_VOUCHER" IS '财务协同-入库凭证表';



-- ----------------------------
-- Primary Key structure for table T_BILL
-- ----------------------------
ALTER TABLE "T_BILL" ADD  PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table T_BILL_CATEGORY_SWITCH
-- ----------------------------
ALTER TABLE "T_BILL_CATEGORY_SWITCH" ADD  PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table T_BILL_CONDITIONS
-- ----------------------------
ALTER TABLE "T_BILL_CONDITIONS" ADD  PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table T_BILL_DEALINGS
-- ----------------------------
ALTER TABLE "T_BILL_DEALINGS" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table T_BILL_DEDUCTION
-- ----------------------------
ALTER TABLE "T_BILL_DEDUCTION" ADD  PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table T_BILL_INVOICE
-- ----------------------------
ALTER TABLE "T_BILL_INVOICE" ADD  PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table T_BILL_INVOICE_REBATE
-- ----------------------------
ALTER TABLE "T_BILL_INVOICE_REBATE" ADD  PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table T_BILL_ITEM
-- ----------------------------
ALTER TABLE "T_BILL_ITEM" ADD  PRIMARY KEY ("ID");



-- ----------------------------
-- Primary Key structure for table T_BILL_LETTER
-- ----------------------------
ALTER TABLE "T_BILL_LETTER" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table T_BILL_MATERIAL_RELATION
-- ----------------------------
ALTER TABLE "T_BILL_MATERIAL_RELATION"  PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table T_BILL_PAYMENT
-- ----------------------------
ALTER TABLE "T_BILL_PAYMENT" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table T_BILL_PUR_VOUCHER
-- ----------------------------
ALTER TABLE "T_BILL_PUR_VOUCHER" ADD  PRIMARY KEY ("ID");


-- ----------------------------
-- Primary Key structure for table T_BILL_SUP_GROUP
-- ----------------------------
ALTER TABLE "T_BILL_SUP_GROUP" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table T_BILL_SUP_GROUP_REF
-- ----------------------------
ALTER TABLE "T_BILL_SUP_GROUP_REF" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table T_BILL_SWITCH
-- ----------------------------
ALTER TABLE "T_BILL_SWITCH" ADD  PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table T_BILL_TAX_CLASSIFY
-- ----------------------------
ALTER TABLE "T_BILL_TAX_CLASSIFY" ADD  PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table T_BILL_TAX_CLASSIFY_MAT
-- ----------------------------
ALTER TABLE "T_BILL_TAX_CLASSIFY_MAT" ADD  PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table T_BILL_USER_INFO
-- ----------------------------
ALTER TABLE "T_BILL_USER_INFO" ADD  PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table T_BILL_VOUCHER
-- ----------------------------
ALTER TABLE "T_BILL_VOUCHER" ADD  PRIMARY KEY ("ID");
