/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.template.command;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.els.base.cms.common.AbstractCommand;
import com.els.base.cms.common.CmsInvoker;
import com.els.base.cms.module.utils.TemplateTypeEnum;
import com.els.base.cms.template.entity.CmsTemplate;
import com.els.base.cms.template.entity.CmsTemplateExample;
import com.els.base.cms.utils.InstructionUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.template.BeetlTemplateUtils;
import java.util.Collection;
import java.util.Date;

public class CreateTplCommand
extends AbstractCommand<String> {
    private CmsTemplate cmsTemplate;

    public CreateTplCommand(CmsTemplate cmsTemplate) {
        this.cmsTemplate = cmsTemplate;
    }

    @Override
    public String execute(CmsInvoker invoker) {
        this.valid(this.cmsTemplate);
        this.init(this.cmsTemplate);
        this.add(this.cmsTemplate);
        return null;
    }

    private void add(CmsTemplate cmsTemplate) {
        this.getCmsTemplateService().addObj(cmsTemplate);
    }

    private void init(CmsTemplate cmsTemplate) {
        cmsTemplate.setCreateTime(new Date());
        cmsTemplate.setTemplate(InstructionUtils.removeInstruction(cmsTemplate.getTemplate()));
        try {
            BeetlTemplateUtils.gt.validateScript("str:".concat(cmsTemplate.getTemplate()));
        }
        catch (Exception e) {
            this.logger.error("\u6a21\u677f\u8bed\u6cd5\u5f02\u5e38", (Throwable)e);
            String msg = String.format("\u6a21\u677f\u8bed\u6cd5\u5f02\u5e38:%s", e.getMessage());
            throw new CommonException(msg);
        }
        if (!Constant.YES_INT.equals(cmsTemplate.getIsEnable()) && !Constant.NO_INT.equals(cmsTemplate.getIsEnable())) {
            cmsTemplate.setIsEnable(Constant.YES_INT);
        }
        CmsTemplateExample example = new CmsTemplateExample();
        example.createCriteria().andTypeEqualTo(cmsTemplate.getType()).andIsEnableEqualTo(Constant.YES_INT);
        if (CollectionUtils.isEmpty((Collection)this.getCmsTemplateService().queryAllObjByExample((IExample)example))) {
            cmsTemplate.setIsDefault(Constant.YES_INT);
        } else {
            cmsTemplate.setIsDefault(Constant.NO_INT);
        }
    }

    private void valid(CmsTemplate cmsTemplate) {
        Assert.isNotBlank((String)cmsTemplate.getName(), (String)"\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)cmsTemplate.getCode(), (String)"\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)cmsTemplate.getTemplate(), (String)"\u6a21\u677f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)cmsTemplate.getCreateUserId(), (String)"\u521b\u5efa\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)cmsTemplate.getCreateUserName(), (String)"\u521b\u5efa\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)cmsTemplate.getType(), (String)"\u6a21\u677f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (!(TemplateTypeEnum.MODULE.getCode().equals(cmsTemplate.getType()) || TemplateTypeEnum.ARTICLE.getCode().equals(cmsTemplate.getType()) || TemplateTypeEnum.HOME.getCode().equals(cmsTemplate.getType()))) {
            throw new CommonException("\u6a21\u677f\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
    }
}

