/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.template.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.cms.common.CmsInvoker;
import com.els.base.cms.common.FileRenderUtils;
import com.els.base.cms.template.command.CreateTplCommand;
import com.els.base.cms.template.command.DeleteTplCommand;
import com.els.base.cms.template.command.EnableTplCommand;
import com.els.base.cms.template.command.ModifyTplCommand;
import com.els.base.cms.template.command.SetDefalutCommand;
import com.els.base.cms.template.entity.CmsTemplate;
import com.els.base.cms.template.entity.CmsTemplateExample;
import com.els.base.cms.template.service.CmsTemplateService;
import com.els.base.cms.utils.InstructionUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(value="CMS-\u95e8\u6237\u6a21\u677f")
@Controller
@RequestMapping(value={"cmsTemplate"})
public class CmsTemplateController {
    @Resource
    protected CmsTemplateService cmsTemplateService;
    @Resource
    protected CmsInvoker invoker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u95e8\u6237\u6a21\u677f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@ModelAttribute CmsTemplate cmsTemplate, MultipartHttpServletRequest request) throws IOException {
        cmsTemplate.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        cmsTemplate.setCreateUserName(SpringSecurityUtils.getLoginUser().getNickName());
        cmsTemplate.setTemplate(IOUtils.toString((InputStream)this.getTemplateContent(request).getInputStream(), (String)"UTF-8"));
        this.invoker.invoke(new CreateTplCommand(cmsTemplate));
        return ResponseResult.success();
    }

    private MultipartFile getTemplateContent(MultipartHttpServletRequest request) throws IOException {
        Map fileMap = request.getFileMap();
        if (MapUtils.isEmpty((Map)fileMap)) {
            return null;
        }
        Set fileKeySet = fileMap.keySet();
        if (fileKeySet.size() > 1) {
            throw new CommonException("\u4e0d\u63a5\u53d7\u591a\u4e2a\u6587\u4ef6\u4e0a\u4f20", "file_upload_not_accepted");
        }
        MultipartFile file = null;
        Iterator keyIterator = fileKeySet.iterator();
        while (keyIterator.hasNext()) {
            file = (MultipartFile)fileMap.get(keyIterator.next());
        }
        return file;
    }

    @ApiOperation(value="\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6", httpMethod="GET")
    @RequestMapping(value={"service/download/{templateId}"})
    @ResponseBody
    public ModelAndView download(@PathVariable String templateId, HttpServletRequest request, HttpServletResponse response) {
        try {
            CmsTemplate template = (CmsTemplate)this.cmsTemplateService.queryObjById(templateId);
            if (template == null) {
                response.setStatus(404);
                return null;
            }
            if (StringUtils.isBlank((String)template.getTemplate())) {
                response.setStatus(404);
                return null;
            }
            response.reset();
            String headerStr = MessageFormat.format("attachment;filename=\"{0}.html\";", URLEncoder.encode(template.getName(), "UTF-8"));
            response.setHeader("Content-Disposition", headerStr);
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/octet-stream;charset=UTF-8");
            String templateStr = InstructionUtils.addInstruction(template.getTemplate());
            ServletOutputStream outputStream = response.getOutputStream();
            IOUtils.write((String)templateStr, (OutputStream)outputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u95e8\u6237\u6a21\u677f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@ModelAttribute CmsTemplate cmsTemplate, MultipartHttpServletRequest request) throws IOException {
        Assert.isNotBlank((String)cmsTemplate.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        Assert.isNotNull((Object)cmsTemplate.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        cmsTemplate.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        cmsTemplate.setUpdateUserName(SpringSecurityUtils.getLoginUser().getNickName());
        MultipartFile uploadFile = this.getTemplateContent(request);
        if (uploadFile != null) {
            cmsTemplate.setTemplate(IOUtils.toString((InputStream)uploadFile.getInputStream(), (String)"UTF-8"));
        }
        this.invoker.invoke(new ModifyTplCommand(cmsTemplate));
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u95e8\u6237\u6a21\u677f")
    @RequestMapping(value={"service/deleteBatch"})
    @ResponseBody
    public ResponseResult<String> deleteBatch(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        this.invoker.invoke(new DeleteTplCommand(ids));
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u542f\u7528\u6216\u7981\u7528\u6a21\u677f")
    @RequestMapping(value={"service/setIsEnable"})
    @ResponseBody
    public ResponseResult<String> setIsEnable(@RequestBody List<String> ids, int isEnable) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        this.invoker.invoke(new EnableTplCommand(ids, Constant.YES_INT.equals(isEnable)));
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4")
    @RequestMapping(value={"service/setDefault"})
    @ResponseBody
    public ResponseResult<String> setDefault(String id) {
        Assert.isNotBlank((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        this.invoker.invoke(new SetDefalutCommand(id));
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u95e8\u6237\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CmsTemplate", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CmsTemplate>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CmsTemplateExample example = new CmsTemplateExample();
        example.setPageView((PageView<CmsTemplate>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        CmsTemplateExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.cmsTemplateService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u7684\u6587\u4ef6\u5217\u8868\u3002\u8fd4\u56de\u7684\u6570\u636e\u91cc\uff0cname\u662f\u6587\u4ef6\u540d\uff0cisFolder\u8868\u793a\u662f\u5426\u662f\u6587\u4ef6\u5939")
    @RequestMapping(value={"service/listFile/**"})
    @ResponseBody
    public ResponseResult<List<Map<String, String>>> listFile(HttpServletRequest request) throws IOException {
        File[] fileList;
        String folder = request.getRequestURI().replaceAll(".*?service/listFile/*", "");
        File parent = FileRenderUtils.getRootFolder();
        if (StringUtils.isNotBlank((String)folder)) {
            if (!(parent = new File(parent, folder)).exists()) {
                throw new CommonException("\u6ca1\u6709\u627e\u5230\u6587\u4ef6\u5939[" + folder + "]");
            }
            if (!parent.isDirectory()) {
                throw new CommonException("[" + folder + "]\u4e0d\u662f\u6587\u4ef6\u5939");
            }
        }
        if ((fileList = parent.listFiles()) == null || fileList.length == 0) {
            return ResponseResult.success(null);
        }
        ArrayList fileNameAndType = new ArrayList();
        for (File input : fileList) {
            HashMap<String, String> nameAndType = new HashMap<String, String>();
            nameAndType.put("name", input.getName());
            nameAndType.put("isFolder", String.valueOf(input.isDirectory()));
            fileNameAndType.add(nameAndType);
        }
        return ResponseResult.success(fileNameAndType);
    }

    @ApiOperation(httpMethod="POST", value="\u4e0b\u8f7d\u6307\u5b9a\u8def\u5f84\u7684\u8d44\u6e90\u6587\u4ef6")
    @RequestMapping(value={"service/downloadResource/**"})
    @ResponseBody
    public ModelAndView downloadResource(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String filePath = request.getRequestURI().replaceAll(".*?service/downloadResource/*", "");
        Assert.isNotBlank((String)filePath, (String)"\u4e0b\u8f7d\u7684\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        File parent = FileRenderUtils.getRootFolder();
        File file = new File(parent, filePath);
        if (!file.exists()) {
            throw new CommonException("\u6587\u4ef6[" + filePath + "]\u4e0d\u5b58\u5728");
        }
        if (file.isDirectory()) {
            throw new CommonException("[" + filePath + "]\u662f\u6587\u4ef6\u5939\uff0c\u4e0d\u652f\u6301\u6587\u4ef6\u5939\u4e0b\u8f7d");
        }
        response.reset();
        String headerStr = MessageFormat.format("attachment;filename=\"{0}.html\";", URLEncoder.encode(file.getName(), "UTF-8"));
        response.setHeader("Content-Disposition", headerStr);
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/octet-stream;charset=UTF-8");
        ServletOutputStream outputStream = response.getOutputStream();
        IOUtils.copy((Reader)new FileReader(file), (OutputStream)outputStream);
        return null;
    }

    @ApiOperation(httpMethod="POST", value="\u4e0a\u4f20\u9759\u6001\u8d44\u6e90\u6587\u4ef6,\u6587\u4ef6\u540d\u76f8\u540c\u7684\u8bdd\uff0c\u5c06\u8986\u76d6\u539f\u6709\u6587\u4ef6")
    @RequestMapping(value={"service/uploadStatic/**"})
    @ResponseBody
    public ResponseResult<String> uploadStatic(MultipartHttpServletRequest request) throws IOException {
        String folder = request.getRequestURI().replaceAll(".*?service/uploadStatic/*", "");
        File parent = FileRenderUtils.getRootFolder();
        if (StringUtils.isNotBlank((String)folder)) {
            if (!(parent = new File(parent, folder)).exists()) {
                throw new CommonException("\u6ca1\u6709\u627e\u5230\u6587\u4ef6\u5939[" + folder + "]");
            }
            if (!parent.isDirectory()) {
                throw new CommonException("[" + folder + "]\u4e0d\u662f\u6587\u4ef6\u5939");
            }
        }
        MultipartFile uploadedFile = this.getTemplateContent(request);
        File dest = new File(parent, uploadedFile.getOriginalFilename());
        uploadedFile.transferTo(dest);
        return ResponseResult.success();
    }
}

