/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.article.command;

import com.els.base.cms.article.entity.Article;
import com.els.base.cms.article.entity.ArticleExample;
import com.els.base.cms.article.service.ArticleService;
import com.els.base.cms.common.CmsInvoker;
import com.els.base.cms.common.ICmsCommand;
import com.els.base.cms.common.event.ChangeArticleEvent;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.ApplicationEvent;

public class BatchPublishCommand
implements ICmsCommand<String> {
    private List<String> ids;
    private User user;

    public BatchPublishCommand(List<String> noticeIdList, User loginUser) {
        this.ids = noticeIdList;
        this.user = loginUser;
    }

    @Override
    public String execute(CmsInvoker invoker) {
        Assert.isNotEmpty(this.ids, (String)"\u53d1\u5e03\u7684\u516c\u544a\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)this.user, (String)"\u53d1\u5e03\u7684\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        ArticleExample articleExample = new ArticleExample();
        articleExample.createCriteria().andIdIn((List)this.ids);
        Article temp = new Article();
        temp.setPublishTime(new Date());
        temp.setPublishUserId(this.user.getId());
        temp.setPublishUserName(this.user.getNickName());
        temp.setStatus(Constant.YES_INT);
        this.getArticleService().modifyByExample(temp, articleExample);
        List articles = this.getArticleService().queryAllObjByExample((IExample)articleExample);
        if (CollectionUtils.isEmpty((Collection)articles)) {
            return null;
        }
        for (Article article : articles) {
            SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)new ChangeArticleEvent(null, article));
        }
        return null;
    }

    private ArticleService getArticleService() {
        return (ArticleService)SpringContextHolder.getOneBean(ArticleService.class);
    }
}

