/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.template.service.impl;

import com.els.base.cms.module.utils.TemplateTypeEnum;
import com.els.base.cms.template.dao.CmsTemplateMapper;
import com.els.base.cms.template.entity.CmsTemplate;
import com.els.base.cms.template.entity.CmsTemplateExample;
import com.els.base.cms.template.service.CmsTemplateService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Constant;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultCmsTemplateService")
public class CmsTemplateServiceImpl
implements CmsTemplateService {
    @Resource
    protected CmsTemplateMapper cmsTemplateMapper;

    @CacheEvict(value={"cmsTemplate"}, allEntries=true)
    public void addObj(CmsTemplate t) {
        this.cmsTemplateMapper.insertSelective(t);
    }

    @CacheEvict(value={"cmsTemplate"}, allEntries=true)
    public void deleteObjById(String id) {
        this.cmsTemplateMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"cmsTemplate"}, allEntries=true)
    public void modifyObj(CmsTemplate t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.cmsTemplateMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"cmsTemplate"}, keyGenerator="redisKeyGenerator")
    public CmsTemplate queryObjById(String id) {
        return this.cmsTemplateMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"cmsTemplate"}, keyGenerator="redisKeyGenerator")
    public List<CmsTemplate> queryAllObjByExample(CmsTemplateExample example) {
        return this.cmsTemplateMapper.selectByExample(example);
    }

    @Cacheable(value={"cmsTemplate"}, keyGenerator="redisKeyGenerator")
    public PageView<CmsTemplate> queryObjByPage(CmsTemplateExample example) {
        PageView pageView = example.getPageView();
        pageView.setQueryResult(this.cmsTemplateMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"cmsTemplate"}, allEntries=true)
    public void deleteByExample(CmsTemplateExample example) {
        this.cmsTemplateMapper.deleteByExample(example);
    }

    @CacheEvict(value={"cmsTemplate"}, allEntries=true)
    public void modifyByExample(CmsTemplateExample example, CmsTemplate template) {
        this.cmsTemplateMapper.updateByExampleSelective(template, example);
    }

    public CmsTemplate queryDefaultHomeTemplate() {
        CmsTemplateExample example = new CmsTemplateExample();
        example.createCriteria().andTypeEqualTo(TemplateTypeEnum.HOME.getCode()).andIsEnableEqualTo(Constant.YES_INT);
        example.setOrderByClause("IS_DEFAULT DESC, CREATE_TIME DESC");
        List list = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (CmsTemplate)list.get(0);
    }

    public CmsTemplate queryDefaultArticleTemplate() {
        CmsTemplateExample example = new CmsTemplateExample();
        example.createCriteria().andTypeEqualTo(TemplateTypeEnum.ARTICLE.getCode()).andIsEnableEqualTo(Constant.YES_INT);
        example.setOrderByClause("IS_DEFAULT DESC, CREATE_TIME DESC");
        List list = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (CmsTemplate)list.get(0);
    }
}

