/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.module.service.impl;

import com.els.base.cms.module.dao.CmsModuleMapper;
import com.els.base.cms.module.entity.CmsModule;
import com.els.base.cms.module.entity.CmsModuleExample;
import com.els.base.cms.module.service.CmsModuleService;
import com.els.base.core.entity.PageView;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultCmsModuleService")
public class CmsModuleServiceImpl
implements CmsModuleService {
    @Resource
    protected CmsModuleMapper cmsModuleMapper;

    @CacheEvict(value={"cmsModule"}, allEntries=true)
    public void addObj(CmsModule t) {
        this.cmsModuleMapper.insertSelective(t);
    }

    @CacheEvict(value={"cmsModule"}, allEntries=true)
    public void deleteObjById(String id) {
        this.cmsModuleMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"cmsModule"}, allEntries=true)
    public void modifyObj(CmsModule t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.cmsModuleMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"cmsModule"}, keyGenerator="redisKeyGenerator")
    public CmsModule queryObjById(String id) {
        return this.cmsModuleMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"cmsModule"}, keyGenerator="redisKeyGenerator")
    public List<CmsModule> queryAllObjByExample(CmsModuleExample example) {
        return this.cmsModuleMapper.selectByExample(example);
    }

    @Cacheable(value={"cmsModule"}, keyGenerator="redisKeyGenerator")
    public PageView<CmsModule> queryObjByPage(CmsModuleExample example) {
        PageView<CmsModule> pageView = example.getPageView();
        pageView.setQueryResult(this.cmsModuleMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"cmsModule"}, allEntries=true)
    public void modifyByExample(CmsModuleExample example, CmsModule module) {
        this.cmsModuleMapper.updateByExampleSelective(module, example);
    }

    @Override
    @Cacheable(value={"cmsModule"}, keyGenerator="redisKeyGenerator")
    public CmsModule queryObjByCode(String moduleCode) {
        CmsModuleExample cmsModuleExample = new CmsModuleExample();
        cmsModuleExample.createCriteria().andCodeEqualTo(moduleCode);
        cmsModuleExample.setOrderByClause("ID ASC");
        List<CmsModule> list = this.queryAllObjByExample(cmsModuleExample);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }
}

