/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.template.command;

import com.els.base.cms.common.AbstractCommand;
import com.els.base.cms.common.CmsInvoker;
import com.els.base.cms.common.event.ChangeTemplateEvent;
import com.els.base.cms.module.utils.TemplateTypeEnum;
import com.els.base.cms.template.entity.CmsTemplate;
import com.els.base.cms.utils.InstructionUtils;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.utils.SpringContextHolder;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationEvent;

public class ModifyTplCommand
extends AbstractCommand<String> {
    private CmsTemplate cmsTemplate;

    public ModifyTplCommand(CmsTemplate cmsTemplate) {
        this.cmsTemplate = cmsTemplate;
    }

    @Override
    public String execute(CmsInvoker invoker) {
        CmsTemplate oldTemplate = (CmsTemplate)this.getCmsTemplateService().queryObjById(this.cmsTemplate.getId());
        this.valid(this.cmsTemplate, oldTemplate);
        this.modify(this.cmsTemplate);
        CmsTemplate newTemplate = (CmsTemplate)this.getCmsTemplateService().queryObjById(this.cmsTemplate.getId());
        ChangeTemplateEvent event = ChangeTemplateEvent.build(oldTemplate, newTemplate);
        SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)event);
        return null;
    }

    private void modify(CmsTemplate cmsTemplate) {
        cmsTemplate.setIsDefault(null);
        cmsTemplate.setIsEnable(null);
        if (StringUtils.isBlank((String)cmsTemplate.getTemplate())) {
            this.getCmsTemplateService().modifyObj(cmsTemplate);
            return;
        }
        cmsTemplate.setTemplate(InstructionUtils.removeInstruction(cmsTemplate.getTemplate()));
        this.getCmsTemplateService().modifyObj(cmsTemplate);
    }

    private void valid(CmsTemplate newTemplate, CmsTemplate oldTemplate) {
        Assert.isNotBlank((String)newTemplate.getUpdateUserId(), (String)"\u4fee\u6539\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)newTemplate.getUpdateUserName(), (String)"\u4fee\u6539\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        if (newTemplate.getCode() != null && !newTemplate.getCode().equals(oldTemplate.getCode())) {
            throw new CommonException("\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4fee\u6539");
        }
        if (newTemplate.getTemplate() != null) {
            Assert.isNotBlank((String)newTemplate.getTemplate(), (String)"\u6a21\u677f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (newTemplate.getName() != null) {
            Assert.isNotBlank((String)newTemplate.getName(), (String)"\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(newTemplate.getType() == null || TemplateTypeEnum.MODULE.getCode().equals(newTemplate.getType()) || TemplateTypeEnum.ARTICLE.getCode().equals(newTemplate.getType()) || TemplateTypeEnum.HOME.getCode().equals(newTemplate.getType()))) {
            throw new CommonException("\u6a21\u677f\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
    }
}

