/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.article.command;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.els.base.cms.article.entity.Article;
import com.els.base.cms.article.entity.ArticleExample;
import com.els.base.cms.common.AbstractCommand;
import com.els.base.cms.common.CmsInvoker;
import com.els.base.cms.common.event.ChangeArticleEvent;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import org.springframework.context.ApplicationEvent;

public class DeleteCommand
extends AbstractCommand<String> {
    private List<String> ids;

    public DeleteCommand(List<String> ids) {
        this.ids = ids;
    }

    public String execute(CmsInvoker invoker) {
        ArticleExample articleExample = new ArticleExample();
        articleExample.createCriteria().andStatusEqualTo(Constant.YES_INT).andIdIn(this.ids);
        List list = this.getArticleService().queryAllObjByExample((IExample)articleExample);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            String errorMsg = MessageFormat.format("\u6587\u7ae0[{0}]\u5df2\u53d1\u5e03\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u8fdb\u884c\u4f5c\u5e9f\u64cd\u4f5c\u3002", ((Article)list.get(0)).getTitle());
            throw new CommonException(errorMsg);
        }
        for (String id : this.ids) {
            Article oldArticle = (Article)this.getArticleService().queryObjById((Object)id);
            this.getArticleService().deleteObjById((Object)id);
            SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)new ChangeArticleEvent(oldArticle, null));
        }
        return null;
    }
}

