/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.module.command;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.els.base.cms.common.AbstractCommand;
import com.els.base.cms.common.CmsInvoker;
import com.els.base.cms.common.event.ChangeModuleEvent;
import com.els.base.cms.module.entity.CmsModule;
import com.els.base.cms.module.utils.TemplateTypeEnum;
import com.els.base.cms.template.entity.CmsTemplate;
import com.els.base.cms.template.entity.CmsTemplateExample;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationEvent;

public class CreateModuleCommand
extends AbstractCommand<String> {
    private CmsModule cmsModule;

    public CreateModuleCommand(CmsModule cmsModule) {
        this.cmsModule = cmsModule;
    }

    public String execute(CmsInvoker invoker) {
        this.valid(this.cmsModule);
        this.init(this.cmsModule);
        this.add(this.cmsModule);
        if (Constant.YES_INT.equals(this.cmsModule.getStatus())) {
            ChangeModuleEvent event = new ChangeModuleEvent(this.cmsModule);
            SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)event);
        }
        return null;
    }

    private void add(CmsModule cmsModule2) {
        this.getCmsModuleService().addObj((Serializable)cmsModule2);
    }

    private void init(CmsModule cmsModule) {
        CmsTemplate template;
        if (cmsModule.getSortNo() == null) {
            cmsModule.setSortNo(Integer.valueOf(0));
        }
        if (!Constant.YES_INT.equals(cmsModule.getStatus()) && !Constant.NO_INT.equals(cmsModule.getStatus())) {
            cmsModule.setStatus(Constant.NO_INT);
        }
        cmsModule.setCreateTime(new Date());
        if (StringUtils.isBlank((String)cmsModule.getModuleTemplateId())) {
            template = this.getDefalutModuleTemplate();
            cmsModule.setModuleTemplateId(template.getId());
            cmsModule.setModuleTemplateName(template.getName());
        }
        if (StringUtils.isBlank((String)cmsModule.getArticleTemplateId())) {
            template = this.getDefalutArticleTemplate();
            cmsModule.setArticleTemplateId(template.getId());
            cmsModule.setArticleTemplateName(template.getName());
        }
    }

    private CmsTemplate getDefalutArticleTemplate() {
        CmsTemplateExample example = new CmsTemplateExample();
        example.createCriteria().andIsDefaultEqualTo(Constant.YES_INT).andTypeEqualTo(TemplateTypeEnum.ARTICLE.getCode());
        List list = this.getCmsTemplateService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new CommonException("\u7cfb\u7edf\u8fd8\u6ca1\u6709\u914d\u7f6e\u9ed8\u8ba4\u7684\u6587\u7ae0\u6a21\u677f");
        }
        return (CmsTemplate)list.get(0);
    }

    private CmsTemplate getDefalutModuleTemplate() {
        CmsTemplateExample example = new CmsTemplateExample();
        example.createCriteria().andIsDefaultEqualTo(Constant.YES_INT).andTypeEqualTo(TemplateTypeEnum.MODULE.getCode());
        List list = this.getCmsTemplateService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new CommonException("\u7cfb\u7edf\u8fd8\u6ca1\u6709\u914d\u7f6e\u9ed8\u8ba4\u6a21\u5757\u6a21\u677f");
        }
        return (CmsTemplate)list.get(0);
    }

    private void valid(CmsModule cmsModule) {
        Assert.isNotBlank((String)cmsModule.getCreateUserId(), (String)"\u521b\u5efa\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)cmsModule.getCreateUserName(), (String)"\u521b\u5efa\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)cmsModule.getName(), (String)"\u6a21\u5757\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)cmsModule.getCode(), (String)"\u6a21\u5757\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        if (!cmsModule.getCode().matches("\\w+")) {
            throw new CommonException("\u6a21\u5757\u7f16\u7801\u53ea\u80fd\u6709\u5b57\u6bcd\u7ec4\u6210");
        }
        if (StringUtils.isNotBlank((String)cmsModule.getParentId())) {
            CmsModule m = (CmsModule)this.getCmsModuleService().queryObjById((Object)cmsModule.getParentId());
            Assert.isNotNull((Object)m, (String)"\u4e0a\u7ea7\u6a21\u5757\u4e0d\u5b58\u5728");
            if (Constant.NO_INT.equals(m.getStatus())) {
                throw new CommonException("\u4e0a\u7ea7\u6a21\u5757\u5df2\u7ecf\u88ab\u7981\u7528");
            }
        }
    }
}

