/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.article.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.cms.article.command.BatchCancelCommand;
import com.els.base.cms.article.command.BatchPublishCommand;
import com.els.base.cms.article.command.CreateCommand;
import com.els.base.cms.article.command.DeleteCommand;
import com.els.base.cms.article.command.ModifyCommand;
import com.els.base.cms.article.command.PublishCommand;
import com.els.base.cms.article.entity.Article;
import com.els.base.cms.article.entity.ArticleExample;
import com.els.base.cms.article.service.ArticleService;
import com.els.base.cms.common.CmsInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="CMS-\u95e8\u6237\u6587\u7ae0")
@Controller
@RequestMapping(value={"article"})
public class ArticleController {
    @Resource
    protected ArticleService articleService;
    @Resource
    protected CmsInvoker invoker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u95e8\u6237\u6587\u7ae0")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Article article) {
        Assert.isNotNull((Object)article, (String)"\u6587\u7ae0\u4e0d\u80fd\u4e3a\u7a7a");
        article.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        article.setCreateUserName(SpringSecurityUtils.getLoginUser().getNickName());
        CreateCommand createComand = new CreateCommand(article);
        this.invoker.invoke(createComand);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u95e8\u6237\u6587\u7ae0")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Article article) {
        Assert.isNotBlank((String)article.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        ModifyCommand modifyCommand = new ModifyCommand(article);
        this.invoker.invoke(modifyCommand);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u516c\u544a")
    @RequestMapping(value={"service/deleteBatch"})
    @ResponseBody
    public ResponseResult<String> deleteBatch(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        DeleteCommand deleteCommand = new DeleteCommand(ids);
        this.invoker.invoke(deleteCommand);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u95e8\u6237\u6587\u7ae0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Article", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Article>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ArticleExample example = new ArticleExample();
        example.setPageView((PageView<Article>)new PageView(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.articleService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546-\u53d1\u5e03\u516c\u544a")
    @RequestMapping(value={"service/publish"})
    @ResponseBody
    public ResponseResult<String> publish(@RequestBody Article article) {
        article.setPublishUserId(SpringSecurityUtils.getLoginUserId());
        article.setPublishUserName(SpringSecurityUtils.getLoginUser().getNickName());
        PublishCommand publishCommand = new PublishCommand(article);
        this.invoker.invoke(publishCommand);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546-\u6279\u91cf\u53d1\u5e03\u516c\u544a")
    @RequestMapping(value={"service/batchPublish"})
    @ResponseBody
    public ResponseResult<String> batchPublish(@RequestBody List<String> articleIdList) {
        Assert.isNotEmpty(articleIdList, (String)"\u53d1\u5e03\u7684\u516c\u544a\u4e0d\u80fd\u4e3a\u7a7a");
        BatchPublishCommand publishCommand = new BatchPublishCommand(articleIdList, (User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(publishCommand);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546-\u6279\u91cf\u4f5c\u5e9f\u516c\u544a")
    @RequestMapping(value={"service/batchCancel"})
    @ResponseBody
    public ResponseResult<String> batchCancel(@RequestBody List<String> articleIdList) {
        Assert.isNotEmpty(articleIdList, (String)"\u64a4\u9500\u7684\u516c\u544a\u4e0d\u80fd\u4e3a\u7a7a");
        BatchCancelCommand batchCanCelCommand = new BatchCancelCommand(articleIdList);
        this.invoker.invoke(batchCanCelCommand);
        return ResponseResult.success();
    }
}

