/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.common;

import com.els.base.cms.common.AbstractCommand;
import com.els.base.cms.common.CmsInvoker;
import com.els.base.cms.common.FileRenderUtils;
import com.els.base.cms.module.entity.CmsModule;
import com.els.base.cms.template.entity.CmsTemplate;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.template.BeetlTemplateUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Hashtable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderModuleCommand
extends AbstractCommand<String> {
    private static Logger logger = LoggerFactory.getLogger(RenderModuleCommand.class);
    private CmsModule cmsModule;

    public RenderModuleCommand(CmsModule module) {
        this.cmsModule = module;
    }

    @Override
    public String execute(CmsInvoker invoker) {
        Assert.isNotNull((Object)this.cmsModule, (String)"\u6a21\u5757\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.cmsModule.getModuleTemplateId(), (String)"\u6a21\u677f\u8fd8\u6ca1\u6709\u7ed9\u5185\u9875\u914d\u7f6e\u6a21\u677f\uff0c\u65e0\u6cd5\u751f\u6210\u9875\u9762");
        CmsTemplate moduleTpl = (CmsTemplate)this.getCmsTemplateService().queryObjById(this.cmsModule.getModuleTemplateId());
        if (moduleTpl == null) {
            throw new CommonException("\u7cfb\u7edf\u6ca1\u6709\u53ef\u7528\u7684\u9996\u9875\u6a21\u677f\uff0c\u65e0\u6cd5\u751f\u6210\u9996\u9875");
        }
        try {
            this.deleteOldHomeFile(this.cmsModule);
            this.renderFile(moduleTpl, this.cmsModule);
        }
        catch (IOException e) {
            throw new CommonException("\u751f\u6210\u9996\u9875\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    private void renderFile(CmsTemplate moduleTpl, CmsModule cmsModule) throws IOException {
        if (!Constant.YES_INT.equals(cmsModule.getStatus())) {
            logger.info("\u6a21\u5757[{}],\u672a\u542f\u7528\uff0c\u4e0d\u505a\u6e32\u67d3", (Object)cmsModule.getName());
            return;
        }
        moduleTpl = (CmsTemplate)this.getCmsTemplateService().queryObjById(moduleTpl.getId());
        String template = moduleTpl.getTemplate();
        if (StringUtils.isBlank((String)template)) {
            throw new CommonException("\u6a21\u677f\u5185\u5bb9\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u751f\u6210\u9996\u9875");
        }
        File indexFile = this.getModuleIndexFile(cmsModule);
        FileWriter writer = new FileWriter(indexFile);
        Hashtable<String, CmsModule> data = new Hashtable<String, CmsModule>();
        data.put("module", cmsModule);
        BeetlTemplateUtils.renderFromString((String)template, (Writer)writer, data);
    }

    private File getModuleIndexFile(CmsModule cmsModule) throws IOException {
        File moduleFolder = this.getModuleFolder(cmsModule);
        File indexFile = new File(moduleFolder.getAbsolutePath() + "/" + FileRenderUtils.INEDX_PAGE_FILE_NAME);
        if (!indexFile.exists()) {
            FileUtils.touch((File)indexFile);
        }
        return indexFile;
    }

    private void deleteOldHomeFile(CmsModule cmsModule) throws IOException {
        File dashFolder = FileRenderUtils.getDashFolder();
        String subFolder = DateFormatUtils.format((Date)new Date(), (String)"/yyyyMMddHHmm");
        if (!(dashFolder = new File(dashFolder.getAbsolutePath() + subFolder)).exists()) {
            FileUtils.forceMkdir((File)dashFolder);
        }
        File moduleFolder = this.getModuleFolder(cmsModule);
        FileUtils.copyDirectoryToDirectory((File)moduleFolder, (File)dashFolder);
        FileUtils.cleanDirectory((File)moduleFolder);
    }

    private File getModuleFolder(CmsModule cmsModule) throws IOException {
        File rootFolder = FileRenderUtils.getRootFolder();
        File moduleFloder = FileRenderUtils.getSubFolder(rootFolder, cmsModule.getCode());
        if (!moduleFloder.exists()) {
            FileUtils.forceMkdir((File)moduleFloder);
        }
        return moduleFloder;
    }
}

