/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.common;

import com.els.base.cms.article.entity.Article;
import com.els.base.cms.common.AbstractCommand;
import com.els.base.cms.common.CmsInvoker;
import com.els.base.cms.common.FileRenderUtils;
import com.els.base.cms.common.event.RenderArticleEvent;
import com.els.base.cms.module.entity.CmsModule;
import com.els.base.cms.template.entity.CmsTemplate;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.template.BeetlTemplateUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Hashtable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

public class RenderArticleCommand
extends AbstractCommand<String> {
    private static Logger logger = LoggerFactory.getLogger(RenderArticleCommand.class);
    private Article article;

    public RenderArticleCommand(Article article) {
        this.article = article;
    }

    @Override
    public String execute(CmsInvoker invoker) {
        Assert.isNotNull((Object)this.article, (String)"\u6587\u7ae0\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        CmsTemplate template = this.getArticleTemplate(this.article);
        String filePath = null;
        try {
            filePath = this.renderFile(template, this.article);
        }
        catch (IOException e) {
            throw new CommonException("\u6587\u7ae0\u6e32\u67d3\u5931\u8d25", (Throwable)e);
        }
        Article tmp = new Article();
        tmp.setId(this.article.getId());
        tmp.setFilePath(filePath);
        this.getArticleService().modifyObj(tmp);
        RenderArticleEvent event = new RenderArticleEvent((Article)this.getArticleService().queryObjById(this.article.getId()));
        SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)event);
        return null;
    }

    private CmsTemplate getArticleTemplate(Article article) {
        CmsModule cmsModule;
        CmsTemplate cmsTemplate = null;
        if (StringUtils.isNotBlank((String)article.getTemplateId())) {
            cmsTemplate = (CmsTemplate)this.getCmsTemplateService().queryObjById(article.getTemplateId());
        } else if (StringUtils.isNotBlank((String)article.getModuleId()) && StringUtils.isNotBlank((String)(cmsModule = (CmsModule)this.getCmsModuleService().queryObjById(article.getModuleId())).getArticleTemplateId())) {
            cmsTemplate = (CmsTemplate)this.getCmsTemplateService().queryObjById(cmsModule.getArticleTemplateId());
        }
        if (cmsTemplate == null) {
            cmsTemplate = this.getCmsTemplateService().queryDefaultArticleTemplate();
        }
        Assert.isNotNull((Object)cmsTemplate, (String)"\u627e\u4e0d\u5230\u6587\u7ae0\u6e32\u67d3\u9700\u8981\u7684\u6a21\u677f");
        return cmsTemplate;
    }

    private String renderFile(CmsTemplate template, Article article) throws IOException {
        String templateStr;
        if (!Constant.YES_INT.equals(article.getStatus())) {
            logger.info("\u6587\u7ae0[{}],\u672a\u542f\u7528\uff0c\u4e0d\u505a\u6e32\u67d3", (Object)article.getTitle());
        }
        if (StringUtils.isBlank((String)(templateStr = template.getTemplate()))) {
            throw new CommonException("\u6a21\u677f\u5185\u5bb9\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u751f\u6210\u9996\u9875");
        }
        if (StringUtils.isBlank((String)article.getContent())) {
            article = (Article)this.getArticleService().queryObjById(article.getId());
        }
        File articleFile = null;
        if (StringUtils.isBlank((String)article.getFilePath())) {
            File articleRootFolder = FileRenderUtils.getArticleFolder();
            File fileFolder = FileRenderUtils.getSubFolder(articleRootFolder, DateFormatUtils.format((Date)new Date(), (String)"yyMMdd"));
            articleFile = new File(MessageFormat.format("{0}/{1}.html", fileFolder.getAbsolutePath(), article.getId()));
        } else {
            String articleFilePath = FileRenderUtils.getRootFolder().getAbsolutePath() + article.getFilePath();
            articleFile = new File(articleFilePath);
        }
        if (!articleFile.exists() || !articleFile.isFile()) {
            FileUtils.touch((File)articleFile);
        }
        FileWriter writer = new FileWriter(articleFile);
        Hashtable<String, Article> data = new Hashtable<String, Article>();
        data.put("article", article);
        BeetlTemplateUtils.renderFromString((String)templateStr, (Writer)writer, data);
        String rootPath = FileRenderUtils.getRootFolder().getAbsolutePath();
        String articlePath = articleFile.getAbsolutePath();
        return articlePath.replaceAll(rootPath, "");
    }
}

