/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.article.command;

import com.els.base.cms.article.entity.Article;
import com.els.base.cms.article.entity.ArticleExample;
import com.els.base.cms.article.service.ArticleService;
import com.els.base.cms.common.CmsInvoker;
import com.els.base.cms.common.ICmsCommand;
import com.els.base.cms.common.event.ChangeArticleEvent;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.ApplicationEvent;

public class BatchCancelCommand
implements ICmsCommand<String> {
    private List<String> articleIdList;

    public BatchCancelCommand(List<String> articleIdList) {
        this.articleIdList = articleIdList;
    }

    public String execute(CmsInvoker invoker) {
        Assert.isNotEmpty((Collection)this.articleIdList, (String)"\u64a4\u9500\u7684\u516c\u544a\u4e0d\u80fd\u4e3a\u7a7a");
        ArticleExample articleExample = new ArticleExample();
        articleExample.createCriteria().andIdIn(this.articleIdList).andStatusEqualTo(Constant.YES_INT);
        List articles = this.getArticleService().queryAllObjByExample((IExample)articleExample);
        if (CollectionUtils.isEmpty((Collection)articles)) {
            return null;
        }
        Article temp = new Article();
        temp.setStatus(Constant.NO_INT);
        this.getArticleService().modifyByExample(temp, articleExample);
        for (Article newArticle : articles) {
            Article oldArticle = new Article();
            oldArticle.setStatus(Constant.YES_INT);
            oldArticle.setModuleId(newArticle.getModuleId());
            SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)new ChangeArticleEvent(oldArticle, newArticle));
        }
        return null;
    }

    private ArticleService getArticleService() {
        return (ArticleService)SpringContextHolder.getOneBean(ArticleService.class);
    }
}

