/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.article.command;

import com.els.base.cms.article.command.CreateCommand;
import com.els.base.cms.article.command.ModifyCommand;
import com.els.base.cms.article.entity.Article;
import com.els.base.cms.article.service.ArticleService;
import com.els.base.cms.common.CmsInvoker;
import com.els.base.cms.common.ICmsCommand;
import com.els.base.cms.common.event.ChangeArticleEvent;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationEvent;

public class PublishCommand
implements ICmsCommand<String> {
    private Article article;

    public PublishCommand(Article article) {
        this.article = article;
    }

    public String execute(CmsInvoker invoker) {
        Article oldArticle = null;
        if (StringUtils.isBlank((String)this.article.getId())) {
            invoker.invoke((ICmsCommand)new CreateCommand(this.article));
        } else {
            this.article = (Article)this.getArticleService().queryObjById((Object)this.article.getId());
            invoker.invoke((ICmsCommand)new ModifyCommand(this.article));
        }
        Article temp = new Article();
        temp.setId(this.article.getId());
        temp.setPublishTime(new Date());
        temp.setPublishUserId(this.article.getPublishUserId());
        temp.setPublishUserName(this.article.getPublishUserName());
        temp.setStatus(Constant.YES_INT);
        this.getArticleService().modifyObj((Serializable)this.article);
        SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)new ChangeArticleEvent(oldArticle, this.article));
        return null;
    }

    private ArticleService getArticleService() {
        return (ArticleService)SpringContextHolder.getOneBean(ArticleService.class);
    }
}

