/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.banner.service.impl;

import com.els.base.cms.banner.dao.CmsBannerMapper;
import com.els.base.cms.banner.entity.CmsBanner;
import com.els.base.cms.banner.entity.CmsBannerExample;
import com.els.base.cms.banner.service.CmsBannerService;
import com.els.base.core.entity.PageView;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultCmsBannerService")
public class CmsBannerServiceImpl
implements CmsBannerService {
    @Resource
    protected CmsBannerMapper cmsBannerMapper;

    @CacheEvict(value={"cmsBanner"}, allEntries=true)
    public void addObj(CmsBanner t) {
        t.setCreateTime(new Date());
        this.cmsBannerMapper.insertSelective(t);
    }

    @CacheEvict(value={"cmsBanner"}, allEntries=true)
    public void deleteObjById(String id) {
        this.cmsBannerMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"cmsBanner"}, allEntries=true)
    public void modifyObj(CmsBanner t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.cmsBannerMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"cmsBanner"}, keyGenerator="redisKeyGenerator")
    public CmsBanner queryObjById(String id) {
        return this.cmsBannerMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"cmsBanner"}, keyGenerator="redisKeyGenerator")
    public List<CmsBanner> queryAllObjByExample(CmsBannerExample example) {
        return this.cmsBannerMapper.selectByExample(example);
    }

    @Cacheable(value={"cmsBanner"}, keyGenerator="redisKeyGenerator")
    public PageView<CmsBanner> queryObjByPage(CmsBannerExample example) {
        PageView pageView = example.getPageView();
        pageView.setQueryResult(this.cmsBannerMapper.selectByExampleByPage(example));
        return pageView;
    }
}

