/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.article.command;

import com.els.base.cms.article.entity.Article;
import com.els.base.cms.common.AbstractCommand;
import com.els.base.cms.common.CmsInvoker;
import com.els.base.cms.common.event.ChangeArticleEvent;
import com.els.base.cms.module.entity.CmsModule;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.utils.SpringContextHolder;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationEvent;

public class ModifyCommand
extends AbstractCommand<String> {
    private Article article;

    public ModifyCommand(Article article) {
        this.article = article;
    }

    @Override
    public String execute(CmsInvoker invoker) {
        Article oldArticle = (Article)this.getArticleService().queryObjById(this.article.getId());
        this.init(this.article);
        this.valid(this.article);
        this.modify(this.article);
        this.article = (Article)this.getArticleService().queryObjById(this.article.getId());
        SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)new ChangeArticleEvent(oldArticle, this.article));
        return null;
    }

    private void modify(Article article) {
        this.getArticleService().modifyObj(article);
    }

    private void init(Article article) {
        article.setCreateUserId(null);
        article.setCreateTime(null);
        article.setCreateUserName(null);
        article.setArticleNo(null);
        if (StringUtils.isBlank((String)article.getModuleCode()) || StringUtils.isBlank((String)article.getModuleName())) {
            CmsModule module = (CmsModule)this.getCmsModuleService().queryObjById(article.getModuleId());
            article.setModuleCode(module.getCode());
            article.setModuleName(module.getName());
        }
    }

    private void valid(Article article) {
        Article originArticle = (Article)this.getArticleService().queryObjById(this.article.getId());
        Assert.isNotNull((Object)originArticle, (String)"\u8be5\u6587\u7ae0\u4e0d\u5b58\u5728");
        if (article.getSummary() != null) {
            Assert.isNotBlank((String)article.getSummary(), (String)"\u6458\u8981\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (article.getValidStartTime() != null && article.getValidEndTime() != null && article.getValidStartTime().getTime() > article.getValidEndTime().getTime()) {
            throw new CommonException("\u5f00\u59cb\u751f\u6548\u65f6\u95f4\uff0c\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
        }
    }
}

