/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.common;

import com.els.base.core.exception.CommonException;
import com.els.base.utils.SpringContextHolder;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class FileRenderUtils {
    public static String TMP_FOLDER_NAME = "tmp";
    public static String DASH_FOLDER_NAME = "dash";
    public static String ARTICLE_FOLDER_NAME = "article";
    public static String INEDX_PAGE_FILE_NAME = "index.html";
    private static File staticRootFolder = null;

    public static File getRootFolder() throws IOException {
        if (staticRootFolder != null) {
            return staticRootFolder;
        }
        Properties properties = (Properties)SpringContextHolder.getBean((String)"sysConfig");
        String defaultFileFolder = properties.getProperty("resource.location");
        String rootFolderStr = StringUtils.defaultIfBlank((String)properties.getProperty("cms.static.resources.location"), (String)defaultFileFolder);
        if (StringUtils.isBlank((String)rootFolderStr)) {
            throw new CommonException("\u95e8\u6237\u8d44\u6e90\u6587\u4ef6\u7684\u5b58\u50a8\u76ee\u5f55\u8fd8\u6ca1\u6709\u8bbe\u7f6e\uff0c\u8bf7\u5728conf.properties\u4e0a\u914d\u7f6ecms.static.resources.location");
        }
        File folder = new File(rootFolderStr);
        if (!folder.exists()) {
            FileUtils.forceMkdir((File)folder);
        }
        staticRootFolder = folder;
        return folder;
    }

    public static File getSubFolder(File folder, String subFolderName) throws IOException {
        if (!folder.exists()) {
            throw new CommonException("\u6587\u4ef6\u5939{0}\u4e0d\u5b58\u5728", folder.getAbsolutePath());
        }
        String tmpFolderStr = MessageFormat.format("{0}/{1}", folder.getAbsolutePath(), subFolderName);
        File subFolder = new File(tmpFolderStr);
        if (!subFolder.exists() || !subFolder.isDirectory()) {
            FileUtils.forceMkdir((File)subFolder);
        }
        return subFolder;
    }

    public static File getTmpFolder() throws IOException {
        return FileRenderUtils.getSubFolder(FileRenderUtils.getRootFolder(), TMP_FOLDER_NAME);
    }

    public static File getModuleFolder(String moduleCode) throws IOException {
        return FileRenderUtils.getSubFolder(FileRenderUtils.getRootFolder(), moduleCode);
    }

    public static File getDashFolder() throws IOException {
        return FileRenderUtils.getSubFolder(FileRenderUtils.getRootFolder(), DASH_FOLDER_NAME);
    }

    public static File getArticleFolder() throws IOException {
        return FileRenderUtils.getSubFolder(FileRenderUtils.getRootFolder(), ARTICLE_FOLDER_NAME);
    }
}

