/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.common.tag;

import com.els.base.cms.article.entity.Article;
import com.els.base.cms.article.entity.ArticleExample;
import com.els.base.cms.article.service.ArticleService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.beetl.core.Context;
import org.beetl.core.GeneralVarTagBinding;
import org.beetl.core.VirtualAttributeEval;

public class ArticleListTag
extends GeneralVarTagBinding
implements VirtualAttributeEval {
    private static final String ATTR_NAME_MODULE_CODE = "moduleCode";
    private static final String ATTR_NAME_ARTICLE_SIZE = "articleSize";
    private static final String ATTR_NAME_IS_SHOW_ALL = "isShowAll";

    public Object eval(Object value, String attributeName, Context ctx) {
        if (value == null) {
            return value;
        }
        switch (attributeName) {
            case "moduleCode": {
                return value.toString();
            }
        }
        String attrStr = value.toString();
        if (StringUtils.isBlank((String)attrStr) || !StringUtils.isNumeric((String)attrStr)) {
            return null;
        }
        return Integer.valueOf(attrStr);
    }

    public boolean isSupport(Class c, String attributeName) {
        if (attributeName.equals(ATTR_NAME_MODULE_CODE)) {
            return c.equals(String.class);
        }
        if (attributeName.equals(ATTR_NAME_ARTICLE_SIZE)) {
            return c.equals(Integer.class);
        }
        return false;
    }

    public void render() {
        List articles = this.getArticlePageOfModule();
        if (CollectionUtils.isEmpty((Collection)articles)) {
            return;
        }
        for (int i = 0; i < articles.size(); ++i) {
            HashMap<String, Object> status = new HashMap<String, Object>();
            status.put("current", articles.get(i));
            status.put("index", i);
            this.binds(new Object[]{status});
            this.doBodyRender();
        }
    }

    private List<Article> getArticlePageOfModule() {
        Object articleConfSizeObj;
        String moduleCode = (String)this.getAttributeValue(ATTR_NAME_MODULE_CODE);
        if (StringUtils.isBlank((String)moduleCode)) {
            return null;
        }
        Object articleConfIsShowAllObj = this.getAttributeValue(ATTR_NAME_IS_SHOW_ALL);
        boolean isShowAll = false;
        if (articleConfIsShowAllObj != null && "true".equals(articleConfIsShowAllObj.toString().toLowerCase())) {
            isShowAll = true;
        }
        Integer pageSize = (articleConfSizeObj = this.getAttributeValue(ATTR_NAME_ARTICLE_SIZE)) == null ? 10 : Integer.valueOf(articleConfSizeObj.toString());
        ArticleExample articleExample = new ArticleExample();
        articleExample.setPageView(new PageView(1, pageSize.intValue()));
        articleExample.createCriteria().andModuleCodeEqualTo(moduleCode).andStatusEqualTo(Constant.YES_INT);
        articleExample.setOrderByClause("SORT_NO DESC, PUBLISH_TIME DESC");
        ArticleService articleService = (ArticleService)SpringContextHolder.getOneBean(ArticleService.class);
        if (isShowAll) {
            return articleService.queryAllObjByExample((IExample)articleExample);
        }
        return articleService.queryObjByPage((IExample)articleExample).getQueryResult();
    }
}

