/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.common.tag;

import com.els.base.cms.module.entity.CmsModule;
import com.els.base.cms.module.entity.CmsModuleExample;
import com.els.base.cms.module.service.CmsModuleService;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.beetl.core.Context;
import org.beetl.core.GeneralVarTagBinding;
import org.beetl.core.VirtualAttributeEval;

public class ModuleListTag
extends GeneralVarTagBinding
implements VirtualAttributeEval {
    private static final String ATTR_NAME_BEGIN = "begin";
    private static final String ATTR_NAME_END = "end";

    public void render() {
        List cmsModules = this.getAllModules();
        if (CollectionUtils.isEmpty((Collection)cmsModules)) {
            return;
        }
        Integer begin = (Integer)this.getAttributeValue(ATTR_NAME_BEGIN);
        Integer end = (Integer)this.getAttributeValue(ATTR_NAME_END);
        begin = begin == null || begin < 0 ? 0 : (begin >= cmsModules.size() ? cmsModules.size() - 1 : begin);
        end = end == null || end >= cmsModules.size() ? cmsModules.size() - 1 : end;
        for (int i = begin.intValue(); i <= end; ++i) {
            HashMap<String, Object> status = new HashMap<String, Object>();
            status.put("current", cmsModules.get(i));
            status.put("index", i);
            status.put("isFirst", i == begin);
            status.put("isLast", i == end);
            this.binds(new Object[]{status});
            this.doBodyRender();
        }
    }

    public List<CmsModule> getAllModules() {
        CmsModuleExample example = new CmsModuleExample();
        example.createCriteria().andStatusEqualTo(Constant.YES_INT);
        example.setOrderByClause("SORT_NO DESC");
        CmsModuleService cmsModuleService = (CmsModuleService)SpringContextHolder.getOneBean(CmsModuleService.class);
        return cmsModuleService.queryAllObjByExample((IExample)example);
    }

    public boolean isSupport(Class c, String attributeName) {
        if (attributeName.equals(ATTR_NAME_BEGIN)) {
            return c.equals(Integer.class);
        }
        if (attributeName.equals(ATTR_NAME_END)) {
            return c.equals(Integer.class);
        }
        return false;
    }

    public Object eval(Object value, String attributeName, Context ctx) {
        if (value == null) {
            return value;
        }
        switch (attributeName) {
            default: 
        }
        String attrStr = value.toString();
        if (StringUtils.isBlank((String)attrStr) || !StringUtils.isNumeric((String)attrStr)) {
            return null;
        }
        return Integer.valueOf(attrStr);
    }
}

