/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.module.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.cms.common.CmsInvoker;
import com.els.base.cms.common.RenderAllCommand;
import com.els.base.cms.module.command.CreateModuleCommand;
import com.els.base.cms.module.command.DeleteModuleCommand;
import com.els.base.cms.module.command.EnableModuleCommand;
import com.els.base.cms.module.command.ModifyModuleCommand;
import com.els.base.cms.module.entity.CmsModule;
import com.els.base.cms.module.entity.CmsModuleExample;
import com.els.base.cms.module.service.CmsModuleService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="CMS-\u95e8\u6237\u6a21\u5757")
@Controller
@RequestMapping(value={"cmsModule"})
public class CmsModuleController {
    @Resource
    protected CmsModuleService cmsModuleService;
    @Resource
    protected CmsInvoker invoker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u95e8\u6237\u6a21\u5757")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CmsModule cmsModule) {
        cmsModule.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        cmsModule.setCreateUserName(SpringSecurityUtils.getLoginUser().getNickName());
        this.invoker.invoke(new CreateModuleCommand(cmsModule));
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u95e8\u6237\u6a21\u5757")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CmsModule cmsModule) {
        Assert.isNotBlank((String)cmsModule.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        cmsModule.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        cmsModule.setUpdateUserName(SpringSecurityUtils.getLoginUser().getNickName());
        this.invoker.invoke(new ModifyModuleCommand(cmsModule));
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u95e8\u6237\u6a21\u5757")
    @RequestMapping(value={"service/deleteBatch"})
    @ResponseBody
    public ResponseResult<String> deleteBatch(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.invoker.invoke(new DeleteModuleCommand(ids));
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u542f\u7528\u6216\u7981\u7528\u6a21\u5757")
    @RequestMapping(value={"service/setIsEnable"})
    @ResponseBody
    public ResponseResult<String> setIsEnable(@RequestBody List<String> ids, int isEnable) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        this.invoker.invoke(new EnableModuleCommand(ids, Constant.YES_INT.equals(isEnable)));
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5168\u7ad9\u9875\u9762\u91cd\u65b0\u6e32\u67d3")
    @RequestMapping(value={"service/renderAll"})
    @ResponseBody
    public ResponseResult<String> renderAll() {
        this.invoker.invoke(new RenderAllCommand());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u95e8\u6237\u6a21\u5757")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CmsModule", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CmsModule>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CmsModuleExample example = new CmsModuleExample();
        example.setPageView((PageView<CmsModule>)new PageView(pageNo, pageSize));
        example.setOrderByClause("STATUS DESC, SORT_NO DESC");
        CmsModuleExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.cmsModuleService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

