/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.module.command;

import com.els.base.cms.common.AbstractCommand;
import com.els.base.cms.common.CmsInvoker;
import com.els.base.cms.common.event.ChangeModuleEvent;
import com.els.base.cms.module.entity.CmsModule;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import org.springframework.context.ApplicationEvent;

public class ModifyModuleCommand
extends AbstractCommand<String> {
    private CmsModule cmsModule;

    public ModifyModuleCommand(CmsModule cmsModule) {
        this.cmsModule = cmsModule;
    }

    @Override
    public String execute(CmsInvoker invoker) {
        this.valid(this.cmsModule);
        this.cmsModule.setStatus(null);
        this.cmsModule.setCode(null);
        this.getCmsModuleService().modifyObj(this.cmsModule);
        CmsModule currentModule = (CmsModule)this.getCmsModuleService().queryObjById(this.cmsModule.getId());
        ChangeModuleEvent event = new ChangeModuleEvent(currentModule);
        SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)event);
        return null;
    }

    private void valid(CmsModule cmsModule) {
        Assert.isNotBlank((String)cmsModule.getUpdateUserId(), (String)"\u521b\u5efa\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)cmsModule.getUpdateUserName(), (String)"\u521b\u5efa\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        if (cmsModule.getCode() != null && !cmsModule.getCode().matches("\\w+")) {
            throw new CommonException("\u6a21\u5757\u7f16\u7801\u53ea\u80fd\u6709\u5b57\u6bcd\u7ec4\u6210");
        }
        if (cmsModule.getParentId() != null) {
            CmsModule m = (CmsModule)this.getCmsModuleService().queryObjById(cmsModule.getParentId());
            Assert.isNotNull((Object)m, (String)"\u4e0a\u7ea7\u6a21\u5757\u4e0d\u5b58\u5728");
            if (Constant.NO_INT.equals(m.getStatus())) {
                throw new CommonException("\u4e0a\u7ea7\u6a21\u5757\u5df2\u7ecf\u88ab\u7981\u7528");
            }
        }
    }
}

